/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.jsqlparser.SimpleDmlParser;
import io.debezium.connector.oracle.logminer.HistoryRecorder;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.LogMinerMetrics;
import io.debezium.connector.oracle.logminer.LogMinerQueryResultProcessor;
import io.debezium.connector.oracle.logminer.OracleChangeRecordValueConverter;
import io.debezium.connector.oracle.logminer.Scn;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.TransactionalBuffer;
import io.debezium.connector.oracle.logminer.TransactionalBufferMetrics;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Stopwatch;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerStreamingChangeEventSource
implements StreamingChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerStreamingChangeEventSource.class);
    private static final int LOG_MINING_VIEW_FETCH_SIZE = 10000;
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<TableId> dispatcher;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final OracleOffsetContext offsetContext;
    private final SimpleDmlParser dmlParser;
    private final String catalogName;
    private final boolean isRac;
    private final Set<String> racHosts = new HashSet<String>();
    private final JdbcConfiguration jdbcConfiguration;
    private final OracleConnectorConfig.LogMiningStrategy strategy;
    private final OracleTaskContext taskContext;
    private final ErrorHandler errorHandler;
    private final boolean isContinuousMining;
    private OracleConnectorConfig connectorConfig;
    private TransactionalBufferMetrics transactionalBufferMetrics;
    private LogMinerMetrics logMinerMetrics;
    private TransactionalBuffer transactionalBuffer;
    private long startScn;
    private long endScn;
    private Duration archiveLogRetention;

    public LogMinerStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleOffsetContext offsetContext, OracleConnection jdbcConnection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, OracleTaskContext taskContext) {
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext;
        OracleChangeRecordValueConverter converters = new OracleChangeRecordValueConverter(connectorConfig, jdbcConnection);
        this.connectorConfig = connectorConfig;
        this.catalogName = connectorConfig.getPdbName() != null ? connectorConfig.getPdbName() : connectorConfig.getDatabaseName();
        this.dmlParser = new SimpleDmlParser(this.catalogName, connectorConfig.getSchemaName(), converters);
        this.strategy = connectorConfig.getLogMiningStrategy();
        this.isContinuousMining = connectorConfig.isContinuousMining();
        this.errorHandler = errorHandler;
        this.taskContext = taskContext;
        this.jdbcConfiguration = JdbcConfiguration.adapt((Configuration)connectorConfig.getConfig().subset("database.", true));
        this.isRac = connectorConfig.isRacSystem();
        if (this.isRac) {
            this.racHosts.addAll(connectorConfig.getRacNodes().stream().map(String::toUpperCase).collect(Collectors.toSet()));
            LogMinerHelper.instantiateFlushConnections(this.jdbcConfiguration, this.racHosts);
        }
        this.archiveLogRetention = connectorConfig.getLogMiningArchiveLogRetention();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context) {
        try {
            this.registerTransactionalBuffer();
            this.registerLogMinerMetrics();
            try (Connection connection = this.jdbcConnection.connection(false);){
                long databaseTimeMs = LogMinerHelper.getTimeDifference(connection).toMillis();
                LOGGER.trace("Current milliseconds {}, database time {}", (Object)System.currentTimeMillis(), (Object)databaseTimeMs);
                this.transactionalBufferMetrics.setTimeDifference(new AtomicLong(databaseTimeMs));
                this.startScn = this.offsetContext.getScn();
                LogMinerHelper.createFlushTable(connection);
                if (!this.isContinuousMining && this.startScn < LogMinerHelper.getFirstOnlineLogScn(connection, this.archiveLogRetention)) {
                    throw new DebeziumException("Online REDO LOG files or archive log files do not contain the offset scn " + this.startScn + ".  Please perform a new snapshot.");
                }
                LogMinerHelper.setNlsSessionParameters(this.jdbcConnection);
                LogMinerHelper.checkSupplementalLogging(this.jdbcConnection, this.connectorConfig.getPdbName(), this.schema);
                this.initializeRedoLogsForMining(connection, false, this.archiveLogRetention);
                try (HistoryRecorder historyRecorder = this.connectorConfig.getLogMiningHistoryRecorder();){
                    historyRecorder.prepare(this.logMinerMetrics, this.jdbcConfiguration, this.connectorConfig.getLogMinerHistoryRetentionHours());
                    LogMinerQueryResultProcessor processor = new LogMinerQueryResultProcessor(context, this.logMinerMetrics, this.transactionalBuffer, this.dmlParser, this.offsetContext, this.schema, this.dispatcher, this.transactionalBufferMetrics, this.catalogName, this.clock, historyRecorder);
                    try (PreparedStatement miningView = connection.prepareStatement(SqlUtils.logMinerContentsQuery(this.connectorConfig.getSchemaName(), this.jdbcConnection.username(), this.schema));){
                        Set<String> currentRedoLogFiles = LogMinerHelper.getCurrentRedoLogFiles(connection, this.logMinerMetrics);
                        Stopwatch stopwatch = Stopwatch.reusable();
                        while (context.isRunning()) {
                            this.endScn = LogMinerHelper.getEndScn(connection, this.startScn, this.logMinerMetrics);
                            LogMinerHelper.flushLogWriter(connection, this.jdbcConfiguration, this.isRac, this.racHosts);
                            this.pauseBetweenMiningSessions();
                            Set<String> possibleNewCurrentLogFile = LogMinerHelper.getCurrentRedoLogFiles(connection, this.logMinerMetrics);
                            if (!currentRedoLogFiles.equals(possibleNewCurrentLogFile)) {
                                LOGGER.debug("Redo log switch detected, from {} to {}", currentRedoLogFiles, possibleNewCurrentLogFile);
                                LogMinerHelper.endMining(connection);
                                this.initializeRedoLogsForMining(connection, true, this.archiveLogRetention);
                                this.abandonOldTransactionsIfExist(connection);
                                currentRedoLogFiles = LogMinerHelper.getCurrentRedoLogFiles(connection, this.logMinerMetrics);
                            }
                            LogMinerHelper.startLogMining(connection, this.startScn, this.endScn, this.strategy, this.isContinuousMining);
                            stopwatch.start();
                            miningView.setFetchSize(10000);
                            miningView.setLong(1, this.startScn);
                            miningView.setLong(2, this.endScn);
                            ResultSet rs = miningView.executeQuery();
                            Throwable throwable = null;
                            try {
                                Duration lastDurationOfBatchCapturing = stopwatch.stop().durations().statistics().getTotal();
                                this.logMinerMetrics.setLastDurationOfBatchCapturing(lastDurationOfBatchCapturing);
                                processor.processResult(rs);
                                this.updateStartScn();
                                if (!this.transactionalBuffer.isEmpty()) continue;
                                this.offsetContext.setScn(this.startScn);
                                this.transactionalBuffer.resetLargestScn(null);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (rs == null) continue;
                                if (throwable != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                rs.close();
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            try {
                LogMinerHelper.logError(this.transactionalBufferMetrics, "Mining session stopped due to the {}", t);
                this.errorHandler.setProducerThrowable(t);
            }
            catch (Throwable throwable) {
                LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, this.offsetContext.getScn()});
                LOGGER.info("Transactional buffer metrics dump: {}", (Object)this.transactionalBufferMetrics.toString());
                LOGGER.info("Transactional buffer dump: {}", (Object)this.transactionalBuffer.toString());
                LOGGER.info("LogMiner metrics dump: {}", (Object)this.logMinerMetrics.toString());
                this.unregisterLogMinerMetrics();
                this.unregisterTransactionalBuffer();
                throw throwable;
            }
            LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, this.offsetContext.getScn()});
            LOGGER.info("Transactional buffer metrics dump: {}", (Object)this.transactionalBufferMetrics.toString());
            LOGGER.info("Transactional buffer dump: {}", (Object)this.transactionalBuffer.toString());
            LOGGER.info("LogMiner metrics dump: {}", (Object)this.logMinerMetrics.toString());
            this.unregisterLogMinerMetrics();
            this.unregisterTransactionalBuffer();
        }
        LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, this.offsetContext.getScn()});
        LOGGER.info("Transactional buffer metrics dump: {}", (Object)this.transactionalBufferMetrics.toString());
        LOGGER.info("Transactional buffer dump: {}", (Object)this.transactionalBuffer.toString());
        LOGGER.info("LogMiner metrics dump: {}", (Object)this.logMinerMetrics.toString());
        this.unregisterLogMinerMetrics();
        this.unregisterTransactionalBuffer();
    }

    private void registerTransactionalBuffer() {
        this.transactionalBufferMetrics = new TransactionalBufferMetrics(this.taskContext);
        this.transactionalBufferMetrics.register(LOGGER);
        this.transactionalBuffer = new TransactionalBuffer(this.connectorConfig.getLogicalName(), this.errorHandler, this.transactionalBufferMetrics, this.connectorConfig.getMaxQueueSize());
    }

    private void unregisterTransactionalBuffer() {
        if (this.transactionalBuffer != null) {
            this.transactionalBuffer.close();
        }
        if (this.transactionalBufferMetrics != null) {
            this.transactionalBufferMetrics.unregister(LOGGER);
        }
    }

    private void registerLogMinerMetrics() {
        this.logMinerMetrics = new LogMinerMetrics(this.taskContext);
        this.logMinerMetrics.register(LOGGER);
        if (this.connectorConfig.isLogMiningHistoryRecorded().booleanValue()) {
            this.logMinerMetrics.setRecordMiningHistory(true);
        }
    }

    private void unregisterLogMinerMetrics() {
        if (this.logMinerMetrics != null) {
            this.logMinerMetrics.unregister(LOGGER);
        }
    }

    private void abandonOldTransactionsIfExist(Connection connection) {
        Optional<Long> lastScnToAbandonTransactions = LogMinerHelper.getLastScnToAbandon(connection, this.offsetContext.getScn(), this.logMinerMetrics.getHoursToKeepTransactionInBuffer());
        lastScnToAbandonTransactions.ifPresent(thresholdScn -> {
            LogMinerHelper.logWarn(this.transactionalBufferMetrics, "All transactions with first SCN <= {} will be abandoned, offset: {}", thresholdScn, this.offsetContext.getScn());
            this.transactionalBuffer.abandonLongTransactions((Long)thresholdScn);
            this.offsetContext.setScn((long)thresholdScn);
            this.updateStartScn();
        });
    }

    private void updateStartScn() {
        long nextStartScn;
        long l = nextStartScn = this.transactionalBuffer.getLargestScn().equals(Scn.ZERO) ? this.endScn : this.transactionalBuffer.getLargestScn().longValue();
        if (nextStartScn <= this.startScn) {
            this.transactionalBuffer.resetLargestScn(this.endScn);
        }
        this.startScn = this.endScn;
    }

    private void initializeRedoLogsForMining(Connection connection, boolean postEndMiningSession, Duration archiveLogRetention) throws SQLException {
        if (!postEndMiningSession) {
            if (OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals((Object)this.strategy)) {
                LogMinerHelper.buildDataDictionary(connection);
            }
            if (!this.isContinuousMining) {
                LogMinerHelper.setRedoLogFilesForMining(connection, this.startScn, archiveLogRetention);
            }
        } else if (!this.isContinuousMining) {
            if (OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals((Object)this.strategy)) {
                LogMinerHelper.buildDataDictionary(connection);
            }
            LogMinerHelper.setRedoLogFilesForMining(connection, this.startScn, archiveLogRetention);
        }
    }

    private void pauseBetweenMiningSessions() throws InterruptedException {
        Duration period = Duration.ofMillis(this.logMinerMetrics.getMillisecondToSleepBetweenMiningQuery().intValue());
        Metronome.sleeper((Duration)period, (Clock)this.clock).pause();
    }

    public void commitOffset(Map<String, ?> offset) {
    }
}

