/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.connector.oracle.antlr.OracleDmlParser;
import io.debezium.connector.oracle.antlr.listener.BaseDmlParserListener;
import io.debezium.connector.oracle.antlr.listener.ParserUtils;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueWrapper;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;

abstract class BaseDmlStringParserListener
extends BaseDmlParserListener<String> {
    boolean isUpdate;

    BaseDmlStringParserListener(String catalogName, String schemaName, OracleDmlParser parser) {
        super(catalogName, schemaName, parser);
    }

    public void enterTable_alias(PlSqlParser.Table_aliasContext ctx) {
        this.alias = ctx.getText().toUpperCase();
    }

    void parseRecursively(PlSqlParser.Logical_expressionContext logicalExpression) {
        int count = logicalExpression.logical_expression().size();
        if (count == 0) {
            String nullValue = logicalExpression.getStop().getText();
            String expression = logicalExpression.getText();
            String columnName = "";
            String value = "";
            if (expression.contains("=")) {
                columnName = expression.substring(0, expression.indexOf("=")).toUpperCase();
                value = expression.substring(expression.indexOf("=") + 1);
            }
            if ("null".equalsIgnoreCase(nullValue)) {
                columnName = expression.substring(0, expression.toUpperCase().indexOf("ISNULL")).toUpperCase();
                value = nullValue;
            }
            columnName = ParserUtils.stripeAlias(columnName, this.alias);
            columnName = ParserUtils.stripeQuotes(columnName);
            Column column = this.table.columnWithName(columnName);
            String stripedValue = ParserUtils.removeApostrophes(value);
            LogMinerColumnValueWrapper logMinerColumnValueWrapper = (LogMinerColumnValueWrapper)this.oldColumnValues.get(columnName);
            if (logMinerColumnValueWrapper != null) {
                Object valueObject = ParserUtils.convertValueToSchemaType(column, stripedValue, this.converter);
                logMinerColumnValueWrapper.setProcessed(true);
                logMinerColumnValueWrapper.getColumnValue().setColumnData(valueObject);
            }
        }
        for (int i = 0; i < count; ++i) {
            this.parseRecursively(logicalExpression.logical_expression(i));
        }
    }
}

