/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.logminer.LogMinerMetricsMXBean;
import io.debezium.metrics.Metrics;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class LogMinerMetrics
extends Metrics
implements LogMinerMetricsMXBean {
    public static final int DEFAULT_BATCH_SIZE = 20000;
    private static final int MAX_SLEEP_TIME = 3000;
    private static final int DEFAULT_SLEEP_TIME = 1000;
    private static final int MIN_SLEEP_TIME = 0;
    private static final int MIN_BATCH_SIZE = 1000;
    private static final int MAX_BATCH_SIZE = 100000;
    private static final int DEFAULT_HOURS_TO_KEEP_TRANSACTION = 4;
    private static final int SLEEP_TIME_INCREMENT = 200;
    private final AtomicLong currentScn = new AtomicLong();
    private final AtomicInteger logMinerQueryCount = new AtomicInteger();
    private final AtomicInteger totalCapturedDmlCount = new AtomicInteger();
    private final AtomicReference<Duration> totalDurationOfFetchingQuery = new AtomicReference();
    private final AtomicInteger lastCapturedDmlCount = new AtomicInteger();
    private final AtomicReference<Duration> lastDurationOfFetchingQuery = new AtomicReference();
    private final AtomicLong maxCapturedDmlCount = new AtomicLong();
    private final AtomicReference<Duration> maxDurationOfFetchingQuery = new AtomicReference();
    private final AtomicReference<Duration> totalBatchProcessingDuration = new AtomicReference();
    private final AtomicReference<Duration> lastBatchProcessingDuration = new AtomicReference();
    private final AtomicReference<Duration> maxBatchProcessingDuration = new AtomicReference();
    private final AtomicLong maxBatchProcessingThroughput = new AtomicLong();
    private final AtomicReference<String[]> currentLogFileName;
    private final AtomicReference<String[]> redoLogStatus;
    private final AtomicInteger switchCounter = new AtomicInteger();
    private final AtomicInteger batchSize = new AtomicInteger();
    private final AtomicInteger millisecondToSleepBetweenMiningQuery = new AtomicInteger();
    private final AtomicBoolean recordMiningHistory = new AtomicBoolean();
    private final AtomicInteger hoursToKeepTransaction = new AtomicInteger();
    private final AtomicLong networkConnectionProblemsCounter = new AtomicLong();

    LogMinerMetrics(CdcSourceTaskContext taskContext) {
        super(taskContext, "log-miner");
        this.currentScn.set(-1L);
        this.currentLogFileName = new AtomicReference();
        this.redoLogStatus = new AtomicReference();
        this.switchCounter.set(0);
        this.reset();
    }

    @Override
    public void reset() {
        this.batchSize.set(20000);
        this.millisecondToSleepBetweenMiningQuery.set(1000);
        this.totalCapturedDmlCount.set(0);
        this.maxDurationOfFetchingQuery.set(Duration.ZERO);
        this.lastDurationOfFetchingQuery.set(Duration.ZERO);
        this.logMinerQueryCount.set(0);
        this.hoursToKeepTransaction.set(4);
        this.maxBatchProcessingDuration.set(Duration.ZERO);
        this.totalDurationOfFetchingQuery.set(Duration.ZERO);
        this.lastCapturedDmlCount.set(0);
        this.maxCapturedDmlCount.set(0L);
        this.totalBatchProcessingDuration.set(Duration.ZERO);
        this.maxBatchProcessingThroughput.set(0L);
        this.lastBatchProcessingDuration.set(Duration.ZERO);
        this.networkConnectionProblemsCounter.set(0L);
    }

    public void setCurrentScn(Long scn) {
        this.currentScn.set(scn);
    }

    public void setCurrentLogFileName(Set<String> names) {
        this.currentLogFileName.set((String[])names.stream().toArray(String[]::new));
    }

    public void setRedoLogStatus(Map<String, String> status) {
        String[] statusArray = (String[])status.entrySet().stream().map(e -> (String)e.getKey() + " | " + (String)e.getValue()).toArray(String[]::new);
        this.redoLogStatus.set(statusArray);
    }

    public void setSwitchCount(int counter) {
        this.switchCounter.set(counter);
    }

    public void setLastCapturedDmlCount(int dmlCount) {
        this.lastCapturedDmlCount.set(dmlCount);
        if ((long)dmlCount > this.maxCapturedDmlCount.get()) {
            this.maxCapturedDmlCount.set(dmlCount);
        }
        this.totalCapturedDmlCount.getAndAdd(dmlCount);
    }

    public void setLastDurationOfBatchCapturing(Duration lastDuration) {
        this.lastDurationOfFetchingQuery.set(lastDuration);
        this.totalDurationOfFetchingQuery.accumulateAndGet(this.lastDurationOfFetchingQuery.get(), Duration::plus);
        if (this.maxDurationOfFetchingQuery.get().toMillis() < this.lastDurationOfFetchingQuery.get().toMillis()) {
            this.maxDurationOfFetchingQuery.set(lastDuration);
        }
        this.logMinerQueryCount.incrementAndGet();
    }

    public void setLastDurationOfBatchProcessing(Duration lastDuration) {
        this.lastBatchProcessingDuration.set(lastDuration);
        this.totalBatchProcessingDuration.accumulateAndGet(lastDuration, Duration::plus);
        if (this.maxBatchProcessingDuration.get().toMillis() < lastDuration.toMillis()) {
            this.maxBatchProcessingDuration.set(lastDuration);
        }
        if (this.getLastBatchProcessingThroughput() > this.maxBatchProcessingThroughput.get()) {
            this.maxBatchProcessingThroughput.set(this.getLastBatchProcessingThroughput());
        }
    }

    public void incrementNetworkConnectionProblemsCounter() {
        this.networkConnectionProblemsCounter.incrementAndGet();
    }

    @Override
    public Long getCurrentScn() {
        return this.currentScn.get();
    }

    @Override
    public long getTotalCapturedDmlCount() {
        return this.totalCapturedDmlCount.get();
    }

    @Override
    public String[] getCurrentRedoLogFileName() {
        return this.currentLogFileName.get();
    }

    @Override
    public String[] getRedoLogStatus() {
        return this.redoLogStatus.get();
    }

    @Override
    public int getSwitchCounter() {
        return this.switchCounter.get();
    }

    @Override
    public Long getLastDurationOfFetchingQuery() {
        return this.lastDurationOfFetchingQuery.get() == null ? 0L : this.lastDurationOfFetchingQuery.get().toMillis();
    }

    @Override
    public long getLastBatchProcessingDuration() {
        return this.lastBatchProcessingDuration.get().toMillis();
    }

    @Override
    public Long getMaxDurationOfFetchingQuery() {
        return this.maxDurationOfFetchingQuery.get() == null ? 0L : this.maxDurationOfFetchingQuery.get().toMillis();
    }

    @Override
    public Long getMaxCapturedDmlInBatch() {
        return this.maxCapturedDmlCount.get();
    }

    @Override
    public int getLastCapturedDmlCount() {
        return this.lastCapturedDmlCount.get();
    }

    @Override
    public long getAverageBatchProcessingThroughput() {
        if (this.totalBatchProcessingDuration.get().isZero()) {
            return 0L;
        }
        return Math.round(this.totalCapturedDmlCount.floatValue() / (float)this.totalBatchProcessingDuration.get().toMillis() * 1000.0f);
    }

    @Override
    public long getLastBatchProcessingThroughput() {
        if (this.lastBatchProcessingDuration.get().isZero()) {
            return 0L;
        }
        return Math.round(this.lastCapturedDmlCount.floatValue() / (float)this.lastBatchProcessingDuration.get().toMillis() * 1000.0f);
    }

    @Override
    public long getFetchingQueryCount() {
        return this.logMinerQueryCount.get();
    }

    @Override
    public int getBatchSize() {
        return this.batchSize.get();
    }

    @Override
    public Integer getMillisecondToSleepBetweenMiningQuery() {
        return this.millisecondToSleepBetweenMiningQuery.get();
    }

    @Override
    public boolean getRecordMiningHistory() {
        return this.recordMiningHistory.get();
    }

    @Override
    public int getHoursToKeepTransactionInBuffer() {
        return this.hoursToKeepTransaction.get();
    }

    @Override
    public long getMaxBatchProcessingThroughput() {
        return this.maxBatchProcessingThroughput.get();
    }

    @Override
    public long getNetworkConnectionProblemsCounter() {
        return this.networkConnectionProblemsCounter.get();
    }

    @Override
    public void setBatchSize(int size) {
        if (size >= 1000 && size <= 100000) {
            this.batchSize.set(size);
        }
    }

    @Override
    public void setMillisecondToSleepBetweenMiningQuery(Integer milliseconds) {
        if (milliseconds != null && milliseconds >= 0 && milliseconds < 3000) {
            this.millisecondToSleepBetweenMiningQuery.set(milliseconds);
        }
    }

    @Override
    public void changeSleepingTime(boolean increment) {
        int sleepTime = this.millisecondToSleepBetweenMiningQuery.get();
        if (increment && sleepTime < 3000) {
            this.millisecondToSleepBetweenMiningQuery.getAndAdd(200);
        } else if (sleepTime > 0) {
            this.millisecondToSleepBetweenMiningQuery.getAndAdd(-200);
        }
    }

    @Override
    public void changeBatchSize(boolean increment) {
        if (increment && this.batchSize.get() < 100000) {
            this.batchSize.getAndAdd(1000);
        } else if (this.batchSize.get() > 1000) {
            this.batchSize.getAndAdd(-1000);
        }
    }

    @Override
    public void setRecordMiningHistory(boolean doRecording) {
        this.recordMiningHistory.set(doRecording);
    }

    @Override
    public void setHoursToKeepTransactionInBuffer(int hours) {
        if (hours > 0 && hours <= 48) {
            this.hoursToKeepTransaction.set(hours);
        }
    }

    public String toString() {
        return "LogMinerMetrics{currentScn=" + this.currentScn + ", logMinerQueryCount=" + this.logMinerQueryCount + ", totalCapturedDmlCount=" + this.totalCapturedDmlCount + ", totalDurationOfFetchingQuery=" + this.totalDurationOfFetchingQuery + ", lastCapturedDmlCount=" + this.lastCapturedDmlCount + ", lastDurationOfFetchingQuery=" + this.lastDurationOfFetchingQuery + ", maxCapturedDmlCount=" + this.maxCapturedDmlCount + ", maxDurationOfFetchingQuery=" + this.maxDurationOfFetchingQuery + ", totalBatchProcessingDuration=" + this.totalBatchProcessingDuration + ", lastBatchProcessingDuration=" + this.lastBatchProcessingDuration + ", maxBatchProcessingDuration=" + this.maxBatchProcessingDuration + ", maxBatchProcessingThroughput=" + this.maxBatchProcessingThroughput + ", currentLogFileName=" + this.currentLogFileName + ", redoLogStatus=" + this.redoLogStatus + ", switchCounter=" + this.switchCounter + ", batchSize=" + this.batchSize + ", millisecondToSleepBetweenMiningQuery=" + this.millisecondToSleepBetweenMiningQuery + ", recordMiningHistory=" + this.recordMiningHistory + ", hoursToKeepTransaction=" + this.hoursToKeepTransaction + ", networkConnectionProblemsCounter" + this.networkConnectionProblemsCounter + '}';
    }
}

