/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.antlr.listener.BaseParserListener;
import io.debezium.connector.oracle.antlr.listener.ColumnDefinitionParserListener;
import io.debezium.connector.oracle.antlr.listener.ParserUtils;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class CreateTableParserListener
extends BaseParserListener {
    private final List<ParseTreeListener> listeners;
    private TableEditor tableEditor;
    private String catalogName;
    private String schemaName;
    private OracleDdlParser parser;
    private ColumnDefinitionParserListener columnDefinitionParserListener;

    CreateTableParserListener(String catalogName, String schemaName, OracleDdlParser parser, List<ParseTreeListener> listeners) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.parser = parser;
        this.listeners = listeners;
    }

    public void enterCreate_table(PlSqlParser.Create_tableContext ctx) {
        if (ctx.relational_table() == null) {
            throw new IllegalArgumentException("Only relational tables are supported");
        }
        TableId tableId = new TableId(this.catalogName, this.schemaName, this.getTableName(ctx.tableview_name()));
        this.tableEditor = this.parser.databaseTables().editOrCreateTable(tableId);
        super.enterCreate_table(ctx);
    }

    public void exitCreate_table(PlSqlParser.Create_tableContext ctx) {
        Table table = this.getTable();
        assert (table != null);
        this.parser.runIfNotNull(() -> {
            this.listeners.remove((Object)this.columnDefinitionParserListener);
            this.columnDefinitionParserListener = null;
            this.parser.databaseTables().overwriteTable(table);
        }, this.tableEditor, table);
        super.exitCreate_table(ctx);
    }

    public void enterColumn_definition(PlSqlParser.Column_definitionContext ctx) {
        this.parser.runIfNotNull(() -> {
            String columnName = ParserUtils.stripeQuotes(this.getColumnName(ctx.column_name()));
            ColumnEditor columnEditor = Column.editor().name(columnName);
            if (this.columnDefinitionParserListener == null) {
                this.columnDefinitionParserListener = new ColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser.dataTypeResolver());
                this.columnDefinitionParserListener.enterColumn_definition(ctx);
                this.listeners.add((ParseTreeListener)this.columnDefinitionParserListener);
            } else {
                this.columnDefinitionParserListener.setColumnEditor(columnEditor);
            }
        }, this.tableEditor);
        super.enterColumn_definition(ctx);
    }

    public void exitColumn_definition(PlSqlParser.Column_definitionContext ctx) {
        this.parser.runIfNotNull(() -> this.tableEditor.addColumn(this.columnDefinitionParserListener.getColumn()), new Object[]{this.tableEditor, this.columnDefinitionParserListener});
        super.exitColumn_definition(ctx);
    }

    public void exitOut_of_line_constraint(PlSqlParser.Out_of_line_constraintContext ctx) {
        if (ctx.PRIMARY() != null) {
            List pkColumnNames = ctx.column_name().stream().map(ParserUtils::getColumnName).collect(Collectors.toList());
            this.tableEditor.setPrimaryKeyNames(pkColumnNames);
        }
        super.exitOut_of_line_constraint(ctx);
    }

    private Table getTable() {
        return this.tableEditor != null ? this.tableEditor.create() : null;
    }
}

