/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.util;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHelper.class);
    public static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    public static final String CONNECTOR_USER = "c##xstrm";
    public static final String CONNECTOR_USER_LOGMINER = "c##dbzuser";
    public static final String CONNECTOR_NAME = "oracle";
    public static final String SERVER_NAME = "server1";
    public static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    public static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    public static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";
    public static final String CONNECTOR_USER_PASS = "xs";
    public static final String CONNECTOR_USER_PASS_LOGMINER = "dbz";
    public static final String HOST = "localhost";
    public static final String SCHEMA_USER = "debezium";
    public static final String SCHEMA_PASS = "dbz";
    public static final String DATABASE = "ORCLPDB1";
    public static final String DATABASE_CDB = "ORCLCDB";

    public static String getConnectorUserName() {
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.LOG_MINER)) {
            return CONNECTOR_USER_LOGMINER;
        }
        return CONNECTOR_USER;
    }

    public static String getConnectorUserPassword() {
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.LOG_MINER)) {
            return "dbz";
        }
        return CONNECTOR_USER_PASS;
    }

    private static JdbcConfiguration defaultJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, TestHelper.getConnectorUserName())).withDefault(JdbcConfiguration.PASSWORD, TestHelper.getConnectorUserPassword())).withDefault(JdbcConfiguration.DATABASE, DATABASE_CDB)).build();
    }

    public static Configuration.Builder defaultConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.defaultJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.XSTREAM)) {
            builder.with(OracleConnectorConfig.XSTREAM_SERVER_NAME, "dbzxout");
        }
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(OracleConnectorConfig.SERVER_NAME, SERVER_NAME)).with(OracleConnectorConfig.PDB_NAME, DATABASE)).with(OracleConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(OracleConnectorConfig.SCHEMA_NAME, SCHEMA_USER)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with(OracleConnectorConfig.INCLUDE_SCHEMA_CHANGES, false);
    }

    public static OracleConnection defaultConnection() {
        Configuration config = TestHelper.defaultConfig().build();
        Configuration jdbcConfig = config.subset("database.", true);
        OracleConnection jdbcConnection = new OracleConnection(jdbcConfig, TestHelper.class::getClassLoader);
        String pdbName = new OracleConnectorConfig(config).getPdbName();
        if (pdbName != null) {
            jdbcConnection.setSessionToPdb(pdbName);
        }
        return jdbcConnection;
    }

    private static JdbcConfiguration testJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, SCHEMA_USER)).withDefault(JdbcConfiguration.PASSWORD, "dbz")).withDefault(JdbcConfiguration.DATABASE, DATABASE)).build();
    }

    private static JdbcConfiguration adminJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.admin.")).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, "sys as sysdba")).withDefault(JdbcConfiguration.PASSWORD, "top_secret")).withDefault(JdbcConfiguration.DATABASE, DATABASE)).build();
    }

    private static Configuration.Builder testConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.testJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        return builder;
    }

    private static Configuration.Builder adminConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.adminJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        return builder;
    }

    public static OracleConnection testConnection() {
        Configuration config = TestHelper.testConfig().build();
        Configuration jdbcConfig = config.subset("database.", true);
        OracleConnection jdbcConnection = new OracleConnection(jdbcConfig, TestHelper.class::getClassLoader);
        try {
            jdbcConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        String pdbName = new OracleConnectorConfig(config).getPdbName();
        if (pdbName != null) {
            jdbcConnection.setSessionToPdb(pdbName);
        }
        return jdbcConnection;
    }

    public static OracleConnection adminConnection() {
        Configuration config = TestHelper.adminConfig().build();
        Configuration jdbcConfig = config.subset("database.", true);
        OracleConnection jdbcConnection = new OracleConnection(jdbcConfig, TestHelper.class::getClassLoader);
        try {
            jdbcConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        String pdbName = new OracleConnectorConfig(config).getPdbName();
        if (pdbName != null) {
            jdbcConnection.setSessionToPdb(pdbName);
        }
        return jdbcConnection;
    }

    public static void dropTable(OracleConnection connection, String table) {
        block2: {
            try {
                connection.execute(new String[]{"DROP TABLE " + table});
            }
            catch (SQLException e) {
                if (e.getMessage().contains("ORA-00942") && 942 == e.getErrorCode()) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    public static int defaultMessageConsumerPollTimeout() {
        return 120;
    }

    public static OracleConnectorConfig.ConnectorAdapter adapter() {
        String s = System.getProperty(OracleConnectorConfig.CONNECTOR_ADAPTER.name());
        return s == null || s.length() == 0 ? OracleConnectorConfig.ConnectorAdapter.XSTREAM : OracleConnectorConfig.ConnectorAdapter.parse((String)s);
    }
}

