/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.relational.TableId;
import java.io.IOException;
import java.sql.SQLRecoverableException;
import java.time.LocalDateTime;
import java.util.HashSet;
import org.fest.assertions.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class SqlUtilsTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Test
    public void testStatements() {
        SqlUtils.setRac((boolean)false);
        String result = SqlUtils.addLogFileStatement((String)"ADD", (String)"FILENAME");
        String expected = "BEGIN sys.dbms_logmnr.add_logfile(LOGFILENAME => 'FILENAME', OPTIONS => ADD);END;";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        OracleDatabaseSchema schema = (OracleDatabaseSchema)Mockito.mock(OracleDatabaseSchema.class);
        TableId table1 = new TableId("catalog", "schema", "table1");
        TableId table2 = new TableId("catalog", "schema", "table2");
        HashSet<TableId> tables = new HashSet<TableId>();
        Mockito.when((Object)schema.tableIds()).thenReturn(tables);
        result = SqlUtils.logMinerContentsQuery((String)"DATABASE", (String)"SCHEMA", (OracleDatabaseSchema)schema);
        expected = "SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, USERNAME  FROM V$LOGMNR_CONTENTS WHERE  OPERATION_CODE in (1,2,3,5)  AND SEG_OWNER = 'DATABASE'  AND SCN >= ? AND SCN < ?  OR (OPERATION_CODE IN (5,7,34,36) AND USERNAME NOT IN ('SYS','SYSTEM','SCHEMA'))ORDER BY SCN";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        tables.add(table1);
        tables.add(table2);
        result = SqlUtils.logMinerContentsQuery((String)"DATABASE", (String)"SCHEMA", (OracleDatabaseSchema)schema);
        expected = "SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, USERNAME  FROM V$LOGMNR_CONTENTS WHERE  OPERATION_CODE in (1,2,3,5)  AND SEG_OWNER = 'DATABASE'  AND TABLE_NAME IN ('table1','table2') AND SEG_NAME IN ('table1','table2')  AND SCN >= ? AND SCN < ?  OR (OPERATION_CODE IN (5,7,34,36) AND USERNAME NOT IN ('SYS','SYSTEM','SCHEMA'))ORDER BY SCN";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.startLogMinerStatement((Long)10L, (Long)20L, (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG, (boolean)true);
        expected = "BEGIN sys.dbms_logmnr.start_logmnr(startScn => '10', endScn => '20', OPTIONS => DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG  + DBMS_LOGMNR.CONTINUOUS_MINE  + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.startLogMinerStatement((Long)10L, (Long)20L, (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO, (boolean)false);
        expected = "BEGIN sys.dbms_logmnr.start_logmnr(startScn => '10', endScn => '20', OPTIONS => DBMS_LOGMNR.DICT_FROM_REDO_LOGS + DBMS_LOGMNR.DDL_DICT_TRACKING  + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.truncateTableStatement((String)"table_name");
        expected = "TRUNCATE TABLE table_name";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.diffInDaysQuery((Long)123L);
        expected = "select sysdate - CAST(scn_to_timestamp(123) as date) from dual";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.diffInDaysQuery(null);
        Assertions.assertThat((String)result).isNull();
        result = SqlUtils.bulkHistoryInsertStmt((String)"table_name");
        expected = "INSERT  /*+ APPEND */ INTO table_name SELECT * FROM LOG_MINING_TEMP";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.redoLogStatusQuery();
        expected = "SELECT F.MEMBER, R.STATUS FROM V$LOGFILE F, V$LOG R WHERE F.GROUP# = R.GROUP# ORDER BY 2";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.switchHistoryQuery();
        expected = "SELECT 'TOTAL', COUNT(1) FROM V$ARCHIVED_LOG WHERE FIRST_TIME > TRUNC(SYSDATE) AND DEST_ID IN (SELECT DEST_ID FROM V$ARCHIVE_DEST_STATUS WHERE STATUS='VALID' AND TYPE='LOCAL')";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.currentRedoNameQuery();
        expected = "SELECT F.MEMBER FROM V$LOG LOG, V$LOGFILE F  WHERE LOG.GROUP#=F.GROUP# AND LOG.STATUS='CURRENT'";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.supplementalLoggingCheckQuery();
        expected = "SELECT 'KEY', SUPPLEMENTAL_LOG_DATA_ALL FROM V$DATABASE";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.currentScnQuery();
        expected = "SELECT CURRENT_SCN FROM V$DATABASE";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.oldestFirstChangeQuery();
        expected = "SELECT MIN(FIRST_CHANGE#) FROM V$LOG";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.allOnlineLogsQuery();
        expected = "SELECT MIN(F.MEMBER) AS FILE_NAME, L.NEXT_CHANGE# AS NEXT_CHANGE, F.GROUP#  FROM V$LOG L, V$LOGFILE F  WHERE F.GROUP# = L.GROUP# AND L.NEXT_CHANGE# > 0  GROUP BY F.GROUP#, L.NEXT_CHANGE# ORDER BY 3";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.tableExistsQuery((String)"table_name");
        expected = "SELECT '1' AS ONE FROM USER_TABLES WHERE TABLE_NAME = 'table_name'";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.logMiningHistoryDdl((String)"table_name");
        expected = "create  TABLE table_name(row_sequence NUMBER(19,0), captured_scn NUMBER(19,0), table_name VARCHAR2(30 CHAR), seg_owner VARCHAR2(30 CHAR), operation_code NUMBER(19,0), change_time TIMESTAMP(6), transaction_id VARCHAR2(50 CHAR), csf NUMBER(19,0), redo_sql VARCHAR2(4000 CHAR)) nologging";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.oneDayArchivedLogsQuery((Long)10L);
        expected = "SELECT NAME AS FILE_NAME, NEXT_CHANGE# AS NEXT_CHANGE FROM V$ARCHIVED_LOG  WHERE NAME IS NOT NULL AND FIRST_TIME >= SYSDATE - 1 AND ARCHIVED = 'YES'  AND STATUS = 'A' AND NEXT_CHANGE# > 10 ORDER BY 2";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.deleteLogFileStatement((String)"file_name");
        expected = "BEGIN SYS.DBMS_LOGMNR.REMOVE_LOGFILE(LOGFILENAME => 'file_name');END;";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.getHistoryTableNamesQuery();
        expected = "SELECT TABLE_NAME, '1' FROM USER_TABLES WHERE TABLE_NAME LIKE 'LM_HIST_%'";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.dropHistoryTableStatement((String)"table_name");
        expected = "DROP TABLE TABLE_NAME PURGE";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
    }

    @Test
    public void shouldParseHistoryTableNames() {
        String name = SqlUtils.buildHistoryTableName((LocalDateTime)LocalDateTime.now());
        long diff = SqlUtils.parseRetentionFromName((String)name);
        Assertions.assertThat((long)diff).isEqualTo(0L);
        name = SqlUtils.buildHistoryTableName((LocalDateTime)LocalDateTime.now().minusHours(10L));
        diff = SqlUtils.parseRetentionFromName((String)name);
        Assertions.assertThat((long)diff).isEqualTo(10L);
        diff = SqlUtils.parseRetentionFromName((String)"LM_HIST_10_2_4_5");
        Assertions.assertThat((long)diff).isEqualTo(0L);
    }

    @Test
    public void shouldDetectConnectionProblems() {
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new IOException("connection"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new SQLRecoverableException("connection"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Throwable())).isFalse();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-03135 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-12543 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-00604 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-01089 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-00600 problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("ORA-99999 problem"))).isFalse();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("NO MORE DATA TO READ FROM SOCKET problem"))).isTrue();
        Assertions.assertThat((boolean)SqlUtils.connectionProblem((Throwable)new Exception("12543 problem"))).isFalse();
    }
}

