/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.connector.oracle.xstream.XStreamChangeRecordEmitter;
import io.debezium.connector.oracle.xstream.XStreamSchemaChangeEventEmitter;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import oracle.streams.ChunkColumnValue;
import oracle.streams.DDLLCR;
import oracle.streams.LCR;
import oracle.streams.RowLCR;
import oracle.streams.StreamsException;
import oracle.streams.XStreamLCRCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LcrEventHandler
implements XStreamLCRCallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LcrEventHandler.class);
    private final ErrorHandler errorHandler;
    private final EventDispatcher<TableId> dispatcher;
    private final Clock clock;
    private final RelationalDatabaseSchema schema;
    private final OracleOffsetContext offsetContext;
    private final boolean tablenameCaseInsensitive;

    public LcrEventHandler(ErrorHandler errorHandler, EventDispatcher<TableId> dispatcher, Clock clock, RelationalDatabaseSchema schema, OracleOffsetContext offsetContext, boolean tablenameCaseInsensitive) {
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext;
        this.tablenameCaseInsensitive = tablenameCaseInsensitive;
    }

    public void processLCR(LCR lcr) throws StreamsException {
        LOGGER.trace("Received LCR {}", (Object)lcr);
        LcrPosition lcrPosition = new LcrPosition(lcr.getPosition());
        if (lcrPosition.compareTo(this.offsetContext.getLcrPosition()) <= 0) {
            if (LOGGER.isDebugEnabled()) {
                LcrPosition recPosition = this.offsetContext.getLcrPosition();
                LOGGER.debug("Ignoring change event with already processed SCN/LCR Position {}/{}, last recorded {}/{}", new Object[]{lcrPosition, lcrPosition.getScn(), recPosition != null ? recPosition : "none", recPosition != null ? Long.valueOf(recPosition.getScn()) : "none"});
            }
            return;
        }
        this.offsetContext.setScn(lcrPosition.getScn());
        this.offsetContext.setLcrPosition(lcrPosition);
        this.offsetContext.setTransactionId(lcr.getTransactionId());
        this.offsetContext.setSourceTime(lcr.getSourceTime().timestampValue().toInstant());
        this.offsetContext.setTableId(new TableId(lcr.getSourceDatabaseName(), lcr.getObjectOwner(), lcr.getObjectName()));
        try {
            if (lcr instanceof RowLCR) {
                this.dispatchDataChangeEvent((RowLCR)lcr);
            } else if (lcr instanceof DDLLCR) {
                this.dispatchSchemaChangeEvent((DDLLCR)lcr);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.info("Received signal to stop, event loop will halt");
        }
        catch (Exception e) {
            this.errorHandler.setProducerThrowable((Throwable)e);
        }
    }

    private void dispatchDataChangeEvent(RowLCR lcr) throws InterruptedException {
        LOGGER.debug("Processing DML event {}", (Object)lcr);
        if ("COMMIT".equals(lcr.getCommandType())) {
            this.dispatcher.dispatchTransactionCommittedEvent((OffsetContext)this.offsetContext);
            return;
        }
        TableId tableId = this.getTableId((LCR)lcr);
        this.dispatcher.dispatchDataChangeEvent((DataCollectionId)tableId, (ChangeRecordEmitter)new XStreamChangeRecordEmitter(this.offsetContext, lcr, this.schema.tableFor(tableId), this.clock));
    }

    private void dispatchSchemaChangeEvent(DDLLCR ddlLcr) throws InterruptedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing DDL event {}", (Object)ddlLcr.getDDLText());
        }
        TableId tableId = this.getTableId((LCR)ddlLcr);
        this.dispatcher.dispatchSchemaChangeEvent((DataCollectionId)tableId, (SchemaChangeEventEmitter)new XStreamSchemaChangeEventEmitter(this.offsetContext, tableId, ddlLcr));
    }

    private TableId getTableId(LCR lcr) {
        if (!this.tablenameCaseInsensitive) {
            return new TableId(lcr.getSourceDatabaseName(), lcr.getObjectOwner(), lcr.getObjectName());
        }
        return new TableId(lcr.getSourceDatabaseName().toLowerCase(), lcr.getObjectOwner(), lcr.getObjectName().toLowerCase());
    }

    public void processChunk(ChunkColumnValue arg0) throws StreamsException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public LCR createLCR() throws StreamsException {
        throw new UnsupportedOperationException("Should never be called");
    }

    public ChunkColumnValue createChunk() throws StreamsException {
        throw new UnsupportedOperationException("Should never be called");
    }
}

