/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.time.MicroDuration;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.NumberConversions;
import io.debezium.util.Strings;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleChangeRecordValueConverter
extends JdbcValueConverters {
    private static final Pattern INTERVAL_DAY_SECOND_PATTERN = Pattern.compile("([+\\-])?(\\d+) (\\d+):(\\d+):(\\d+).(\\d+)");
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleChangeRecordValueConverter.class);
    private static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd").toFormatter();
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).optionalEnd().toFormatter();
    private static final DateTimeFormatter TIMESTAMP_TZ_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).optionalEnd().appendPattern(" XXX").toFormatter();
    private final JdbcConnection connection;

    public OracleChangeRecordValueConverter(JdbcConnection connection) {
        this.connection = connection;
    }

    public SchemaBuilder schemaBuilder(Column column) {
        if (column == null) {
            LOGGER.warn("Column is null, investigate");
            return null;
        }
        LOGGER.trace("Building schema for column {} of type {} named {} with constraints ({},{})", new Object[]{column.name(), column.jdbcType(), column.typeName(), column.length(), column.scale()});
        switch (column.jdbcType()) {
            case 2: {
                return this.getNumericSchema(column);
            }
            case 100: {
                return SchemaBuilder.float32();
            }
            case 101: {
                return SchemaBuilder.float64();
            }
            case -102: 
            case -101: {
                return ZonedTimestamp.builder();
            }
            case -104: 
            case -103: {
                return MicroDuration.builder();
            }
            case 2002: {
                return SchemaBuilder.string();
            }
        }
        return super.schemaBuilder(column);
    }

    private SchemaBuilder getNumericSchema(Column column) {
        if (column.scale().isPresent()) {
            Integer scale = (Integer)column.scale().get();
            if (scale <= 0) {
                if (scale == 0 && column.length() == 1) {
                    return SchemaBuilder.bool();
                }
                int width = column.length() - scale;
                if (width < 3) {
                    return SchemaBuilder.int8();
                }
                if (width < 5) {
                    return SchemaBuilder.int16();
                }
                if (width < 10 || width == 10 && scale == 0) {
                    return SchemaBuilder.int32();
                }
                if (width < 19) {
                    return SchemaBuilder.int64();
                }
            }
            return super.schemaBuilder(column);
        }
        return VariableScaleDecimal.builder();
    }

    public ValueConverter converter(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 2002: 
            case 2005: {
                return data -> this.convertString(column, fieldDefn, data);
            }
            case 2004: {
                return data -> this.convertBinary(column, fieldDefn, data, this.binaryMode);
            }
            case 100: {
                return data -> this.convertFloat(column, fieldDefn, data);
            }
            case 101: {
                return data -> this.convertDouble(column, fieldDefn, data);
            }
            case 2: {
                return this.getNumericConverter(column, fieldDefn);
            }
            case 6: {
                return data -> this.getFloatConverter(column, fieldDefn, data);
            }
            case 93: {
                return data -> this.convertToLocalDateTime(column, fieldDefn, data);
            }
            case -102: 
            case -101: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
            case -103: {
                return data -> this.convertIntervalYearMonth(column, fieldDefn, data);
            }
            case -104: {
                return data -> this.convertIntervalDaySecond(column, fieldDefn, data);
            }
        }
        return super.converter(column, fieldDefn);
    }

    private Object convertToLocalDateTime(Column column, Field fieldDefn, Object value) {
        String valueString;
        if (value instanceof String && (valueString = (String)value).toLowerCase().startsWith("to_timestamp")) {
            String dateText = valueString.substring("to_timestamp".length() + 2, valueString.length() - 2);
            LocalDateTime dateTime = LocalDateTime.from(TIMESTAMP_FORMATTER.parse(dateText.trim()));
            return dateTime.atZone(ZoneId.of("GMT")).toInstant().toEpochMilli() * 1000L;
        }
        return value;
    }

    private ValueConverter getNumericConverter(Column column, Field fieldDefn) {
        if (column.scale().isPresent()) {
            Integer scale = (Integer)column.scale().get();
            if (scale <= 0) {
                if (scale == 0 && column.length() == 1) {
                    return data -> this.convertBoolean(column, fieldDefn, data);
                }
                int width = column.length() - scale;
                if (width < 3) {
                    return data -> this.convertNumericAsTinyInt(column, fieldDefn, data);
                }
                if (width < 5) {
                    return data -> this.convertNumericAsSmallInt(column, fieldDefn, data);
                }
                if (width < 10 || width == 10 && scale == 0) {
                    return data -> this.convertNumericAsInteger(column, fieldDefn, data);
                }
                if (width < 19) {
                    return data -> this.convertNumericAsBigInteger(column, fieldDefn, data);
                }
            }
            return data -> this.convertNumeric(column, fieldDefn, data);
        }
        return data -> this.convertVariableScale(column, fieldDefn, data);
    }

    private Object getFloatConverter(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            return Float.valueOf(Float.parseFloat((String)data));
        }
        return this.convertVariableScale(column, fieldDefn, data);
    }

    protected Object convertString(Column column, Field fieldDefn, Object data) {
        if (data instanceof CHAR) {
            return ((CHAR)data).stringValue();
        }
        if (data instanceof CLOB) {
            return ((CLOB)data).toString();
        }
        return super.convertString(column, fieldDefn, data);
    }

    protected Object convertBinary(Column column, Field fieldDefn, Object data, CommonConnectorConfig.BinaryHandlingMode mode) {
        if (data instanceof BLOB) {
            return ((BLOB)data).getBytes();
        }
        return super.convertBinary(column, fieldDefn, data, mode);
    }

    protected Object convertInteger(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).intValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertInteger(column, fieldDefn, data);
    }

    protected Object convertFloat(Column column, Field fieldDefn, Object data) {
        if (data instanceof Float) {
            return data;
        }
        if (data instanceof NUMBER) {
            return Float.valueOf(((NUMBER)data).floatValue());
        }
        if (data instanceof BINARY_FLOAT) {
            try {
                return Float.valueOf(((BINARY_FLOAT)data).floatValue());
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertFloat(column, fieldDefn, data);
    }

    protected Object convertDouble(Column column, Field fieldDefn, Object data) {
        if (data instanceof BINARY_DOUBLE) {
            try {
                return ((BINARY_DOUBLE)data).doubleValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertDouble(column, fieldDefn, data);
    }

    protected Object convertDecimal(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).bigDecimalValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        if (data instanceof BigDecimal) {
            data = this.withScaleAdjustedIfNeeded(column, (BigDecimal)data);
        }
        return super.convertDecimal(column, fieldDefn, data);
    }

    protected BigDecimal withScaleAdjustedIfNeeded(Column column, BigDecimal data) {
        if (column.scale().isPresent() && (Integer)column.scale().get() > data.scale()) {
            data = data.setScale((Integer)column.scale().get());
        }
        return data;
    }

    protected Object convertNumeric(Column column, Field fieldDefn, Object data) {
        return this.convertDecimal(column, fieldDefn, data);
    }

    private Object convertNumericAsTinyInt(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).byteValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return this.convertTinyInt(column, fieldDefn, data);
    }

    private Object convertNumericAsSmallInt(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).shortValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertSmallInt(column, fieldDefn, data);
    }

    private Object convertNumericAsInteger(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).intValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertInteger(column, fieldDefn, data);
    }

    private Object convertNumericAsBigInteger(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).longValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertBigInt(column, fieldDefn, data);
    }

    protected Object convertBoolean(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            return Byte.parseByte((String)data) == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return super.convertBoolean(column, fieldDefn, data);
    }

    protected Object convertTinyInt(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.BYTE_FALSE, r -> {
            if (data instanceof Byte) {
                r.deliver(data);
            } else if (data instanceof Number) {
                Number value = (Number)data;
                r.deliver((Object)value.byteValue());
            } else if (data instanceof Boolean) {
                r.deliver((Object)NumberConversions.getByte((boolean)((Boolean)data)));
            } else if (data instanceof String) {
                r.deliver((Object)Byte.parseByte((String)data));
            }
        });
    }

    private Object convertVariableScale(Column column, Field fieldDefn, Object data) {
        if ((data = this.convertNumeric(column, fieldDefn, data)) == null) {
            return null;
        }
        if (data instanceof SpecialValueDecimal) {
            return VariableScaleDecimal.fromLogical((Schema)fieldDefn.schema(), (SpecialValueDecimal)((SpecialValueDecimal)data));
        }
        if (data instanceof BigDecimal) {
            return VariableScaleDecimal.fromLogical((Schema)fieldDefn.schema(), (SpecialValueDecimal)new SpecialValueDecimal((BigDecimal)data));
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    private Object fromOracleTimeClasses(Column column, Object data) {
        try {
            if (data instanceof TIMESTAMP) {
                data = ((TIMESTAMP)data).timestampValue();
            } else if (data instanceof DATE) {
                data = ((DATE)data).timestampValue();
            } else if (data instanceof TIMESTAMPTZ) {
                TIMESTAMPTZ ts = (TIMESTAMPTZ)data;
                data = ZonedDateTime.ofInstant(ts.timestampValue(this.connection.connection()).toInstant(), ts.getTimeZone().toZoneId());
            } else if (data instanceof TIMESTAMPLTZ) {
                return null;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
        }
        return data;
    }

    protected Object convertTimestampToEpochMicros(Column column, Field fieldDefn, Object data) {
        return super.convertTimestampToEpochMicros(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    protected Object convertTimestampToEpochMillis(Column column, Field fieldDefn, Object data) {
        return super.convertTimestampToEpochMillis(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    protected Object convertTimestampToEpochNanos(Column column, Field fieldDefn, Object data) {
        return super.convertTimestampToEpochNanos(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        return super.convertTimestampWithZone(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    private Object convertIntervalYearMonth(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.DOUBLE_FALSE, r -> {
            if (data instanceof Number) {
                r.deliver((Object)((Number)data).doubleValue());
            } else if (data instanceof INTERVALYM) {
                String interval = ((INTERVALYM)data).stringValue();
                int sign = 1;
                int start = 0;
                if (interval.charAt(0) == '-') {
                    sign = -1;
                    start = 1;
                }
                for (int i = 1; i < interval.length(); ++i) {
                    if (interval.charAt(i) != '-') continue;
                    int year = sign * Integer.parseInt(interval.substring(start, i));
                    int month = sign * Integer.parseInt(interval.substring(i + 1));
                    r.deliver((Object)MicroDuration.durationMicros((int)year, (int)month, (int)0, (int)0, (int)0, (double)0.0, (Double)30.4375));
                }
            }
        });
    }

    private Object convertIntervalDaySecond(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.DOUBLE_FALSE, r -> {
            String interval;
            Matcher m;
            if (data instanceof Number) {
                r.deliver((Object)((Number)data).doubleValue());
            } else if (data instanceof INTERVALDS && (m = INTERVAL_DAY_SECOND_PATTERN.matcher(interval = ((INTERVALDS)data).stringValue())).matches()) {
                int sign = "-".equals(m.group(1)) ? -1 : 1;
                r.deliver((Object)MicroDuration.durationMicros((int)0, (int)0, (int)(sign * Integer.valueOf(m.group(2))), (int)(sign * Integer.valueOf(m.group(3))), (int)(sign * Integer.valueOf(m.group(4))), (double)(sign * Integer.valueOf(m.group(5))), (int)(sign * Integer.valueOf(Strings.pad((String)m.group(6), (int)6, (char)'0'))), (Double)30.4375));
            }
        });
    }
}

