/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.LogMinerMetrics;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class LogMinerMetricsTest {
    private LogMinerMetrics metrics;
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Before
    public void before() {
        CdcSourceTaskContext taskContext = (CdcSourceTaskContext)Mockito.mock(CdcSourceTaskContext.class);
        Mockito.when((Object)taskContext.getConnectorName()).thenReturn((Object)"connector name");
        Mockito.when((Object)taskContext.getConnectorType()).thenReturn((Object)"connector type");
        this.metrics = new LogMinerMetrics(taskContext);
    }

    @Test
    public void testMetrics() {
        this.metrics.incrementCapturedDmlCount();
        Assertions.assertThat((this.metrics.getCapturedDmlCount() == 1 ? 1 : 0) != 0).isTrue();
        this.metrics.setCurrentScn(Long.valueOf(1000L));
        Assertions.assertThat((this.metrics.getCurrentScn() == 1000L ? 1 : 0) != 0).isTrue();
        this.metrics.setBatchSize(10);
        Assertions.assertThat((this.metrics.getBatchSize() == 5000 ? 1 : 0) != 0).isTrue();
        this.metrics.setBatchSize(1000000);
        Assertions.assertThat((this.metrics.getBatchSize() == 5000 ? 1 : 0) != 0).isTrue();
        this.metrics.setBatchSize(6000);
        Assertions.assertThat((this.metrics.getBatchSize() == 6000 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMillisecondToSleepBetweenMiningQuery() == 1000 ? 1 : 0) != 0).isTrue();
        this.metrics.changeSleepingTime(true);
        Assertions.assertThat((this.metrics.getMillisecondToSleepBetweenMiningQuery() == 1200 ? 1 : 0) != 0).isTrue();
        this.metrics.changeSleepingTime(false);
        Assertions.assertThat((this.metrics.getMillisecondToSleepBetweenMiningQuery() == 1000 ? 1 : 0) != 0).isTrue();
        this.metrics.setMillisecondToSleepBetweenMiningQuery(Integer.valueOf(20));
        Assertions.assertThat((this.metrics.getMillisecondToSleepBetweenMiningQuery() == 1000 ? 1 : 0) != 0).isTrue();
        this.metrics.setMillisecondToSleepBetweenMiningQuery(Integer.valueOf(4000));
        Assertions.assertThat((this.metrics.getMillisecondToSleepBetweenMiningQuery() == 1000 ? 1 : 0) != 0).isTrue();
        this.metrics.setMillisecondToSleepBetweenMiningQuery(Integer.valueOf(2000));
        Assertions.assertThat((this.metrics.getMillisecondToSleepBetweenMiningQuery() == 2000 ? 1 : 0) != 0).isTrue();
        this.metrics.setLastLogMinerQueryDuration(Duration.ofMillis(100L));
        Assertions.assertThat((this.metrics.getLastLogMinerQueryDuration() == 100L ? 1 : 0) != 0).isTrue();
        this.metrics.setLastLogMinerQueryDuration(Duration.ofMillis(200L));
        Assertions.assertThat((this.metrics.getLastLogMinerQueryDuration() == 200L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getAverageLogMinerQueryDuration() == 150L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getLogMinerQueryCount() == 2 ? 1 : 0) != 0).isTrue();
        this.metrics.setCurrentLogFileName(new HashSet<String>(Arrays.asList("name", "name1")));
        Assertions.assertThat((boolean)this.metrics.getCurrentRedoLogFileName()[0].equals("name")).isTrue();
        Assertions.assertThat((boolean)this.metrics.getCurrentRedoLogFileName()[1].equals("name1")).isTrue();
        this.metrics.setSwitchCount(5);
        Assertions.assertThat((this.metrics.getSwitchCounter() == 5 ? 1 : 0) != 0).isTrue();
        this.metrics.setProcessedCapturedBatchDuration(Duration.ofMillis(1000L));
        Assertions.assertThat((this.metrics.getLastProcessedCapturedBatchDuration() == 1000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getProcessedCapturedBatchCount() == 1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getAverageProcessedCapturedBatchDuration() == 1000L ? 1 : 0) != 0).isTrue();
        this.metrics.setRedoLogStatus(Collections.singletonMap("name", "current"));
        Assertions.assertThat((boolean)this.metrics.getRedoLogStatus()[0].equals("name | current")).isTrue();
        Assertions.assertThat((boolean)this.metrics.toString().contains("logMinerQueryCount"));
    }
}

