/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.logminer.LogMinerMetricsMXBean;
import io.debezium.metrics.Metrics;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class LogMinerMetrics
extends Metrics
implements LogMinerMetricsMXBean {
    private static final int MAX_SLEEP_TIME = 3000;
    private static final int DEFAULT_SLEEP_TIME = 1000;
    private static final int MIN_SLEEP_TIME = 100;
    private static final int MIN_BATCH_SIZE = 1000;
    private static final int MAX_BATCH_SIZE = 100000;
    private static final int DEFAULT_BATCH_SIZE = 5000;
    private static final int SLEEP_TIME_INCREMENT = 200;
    private final AtomicLong currentScn = new AtomicLong();
    private final AtomicInteger capturedDmlCount = new AtomicInteger();
    private final AtomicReference<String[]> currentLogFileName;
    private final AtomicReference<String[]> redoLogStatus;
    private final AtomicInteger switchCounter = new AtomicInteger();
    private final AtomicReference<Duration> lastLogMinerQueryDuration = new AtomicReference();
    private final AtomicReference<Duration> averageLogMinerQueryDuration = new AtomicReference();
    private final AtomicInteger logMinerQueryCount = new AtomicInteger();
    private final AtomicReference<Duration> lastProcessedCapturedBatchDuration = new AtomicReference();
    private final AtomicInteger processedCapturedBatchCount = new AtomicInteger();
    private final AtomicReference<Duration> averageProcessedCapturedBatchDuration = new AtomicReference();
    private final AtomicInteger batchSize = new AtomicInteger();
    private final AtomicInteger millisecondToSleepBetweenMiningQuery = new AtomicInteger();

    LogMinerMetrics(CdcSourceTaskContext taskContext) {
        super(taskContext, "log-miner");
        this.batchSize.set(5000);
        this.millisecondToSleepBetweenMiningQuery.set(1000);
        this.currentScn.set(-1L);
        this.capturedDmlCount.set(0);
        this.currentLogFileName = new AtomicReference();
        this.redoLogStatus = new AtomicReference();
        this.switchCounter.set(0);
        this.averageLogMinerQueryDuration.set(Duration.ZERO);
        this.lastLogMinerQueryDuration.set(Duration.ZERO);
        this.logMinerQueryCount.set(0);
        this.lastProcessedCapturedBatchDuration.set(Duration.ZERO);
        this.processedCapturedBatchCount.set(0);
        this.averageProcessedCapturedBatchDuration.set(Duration.ZERO);
    }

    public void setCurrentScn(Long scn) {
        this.currentScn.set(scn);
    }

    public void incrementCapturedDmlCount() {
        this.capturedDmlCount.incrementAndGet();
    }

    public void setCurrentLogFileName(Set<String> names) {
        this.currentLogFileName.set((String[])names.stream().toArray(String[]::new));
    }

    public void setRedoLogStatus(Map<String, String> status) {
        String[] statusArray = (String[])status.entrySet().stream().map(e -> (String)e.getKey() + " | " + (String)e.getValue()).toArray(String[]::new);
        this.redoLogStatus.set(statusArray);
    }

    public void setSwitchCount(int counter) {
        this.switchCounter.set(counter);
    }

    public void setLastLogMinerQueryDuration(Duration fetchDuration) {
        this.setDurationMetrics(fetchDuration, this.lastLogMinerQueryDuration, this.logMinerQueryCount, this.averageLogMinerQueryDuration);
    }

    public void setProcessedCapturedBatchDuration(Duration processDuration) {
        this.setDurationMetrics(processDuration, this.lastProcessedCapturedBatchDuration, this.processedCapturedBatchCount, this.averageProcessedCapturedBatchDuration);
    }

    @Override
    public Long getCurrentScn() {
        return this.currentScn.get();
    }

    @Override
    public int getCapturedDmlCount() {
        return this.capturedDmlCount.get();
    }

    @Override
    public String[] getCurrentRedoLogFileName() {
        return this.currentLogFileName.get();
    }

    @Override
    public String[] getRedoLogStatus() {
        return this.redoLogStatus.get();
    }

    @Override
    public int getSwitchCounter() {
        return this.switchCounter.get();
    }

    @Override
    public Long getLastLogMinerQueryDuration() {
        return this.lastLogMinerQueryDuration.get() == null ? 0L : this.lastLogMinerQueryDuration.get().toMillis();
    }

    @Override
    public Long getAverageLogMinerQueryDuration() {
        return this.averageLogMinerQueryDuration.get() == null ? 0L : this.averageLogMinerQueryDuration.get().toMillis();
    }

    @Override
    public Long getLastProcessedCapturedBatchDuration() {
        return this.lastProcessedCapturedBatchDuration.get() == null ? 0L : this.lastProcessedCapturedBatchDuration.get().toMillis();
    }

    @Override
    public int getLogMinerQueryCount() {
        return this.logMinerQueryCount.get();
    }

    @Override
    public int getProcessedCapturedBatchCount() {
        return this.processedCapturedBatchCount.get();
    }

    @Override
    public Long getAverageProcessedCapturedBatchDuration() {
        return this.averageProcessedCapturedBatchDuration.get() == null ? 0L : this.averageProcessedCapturedBatchDuration.get().toMillis();
    }

    @Override
    public int getBatchSize() {
        return this.batchSize.get();
    }

    @Override
    public Integer getMillisecondToSleepBetweenMiningQuery() {
        return this.millisecondToSleepBetweenMiningQuery.get();
    }

    @Override
    public void setBatchSize(int size) {
        if (size >= 1000 && size <= 100000) {
            this.batchSize.set(size);
        }
    }

    @Override
    public void setMillisecondToSleepBetweenMiningQuery(Integer milliseconds) {
        if (milliseconds != null && milliseconds >= 100 && milliseconds < 3000) {
            this.millisecondToSleepBetweenMiningQuery.set(milliseconds);
        }
    }

    @Override
    public void changeSleepingTime(boolean increment) {
        int change;
        int sleepTime = this.millisecondToSleepBetweenMiningQuery.get();
        int n = change = increment ? 200 : -200;
        if (sleepTime >= 100 && sleepTime < 3000) {
            this.millisecondToSleepBetweenMiningQuery.getAndAdd(change);
        }
    }

    private void setDurationMetrics(Duration duration, AtomicReference<Duration> lastDuration, AtomicInteger counter, AtomicReference<Duration> averageDuration) {
        if (duration != null) {
            lastDuration.set(duration);
            int count = counter.incrementAndGet();
            Duration currentAverage = averageDuration.get() == null ? Duration.ZERO : averageDuration.get();
            averageDuration.set(currentAverage.multipliedBy(count - 1).plus(duration).dividedBy(count));
        }
    }

    public String toString() {
        return "LogMinerMetrics{currentEndScn=" + this.currentScn.get() + ", currentLogFileNames=" + Arrays.toString(this.currentLogFileName.get()) + ", redoLogStatus=" + Arrays.toString(this.redoLogStatus.get()) + ", capturedDmlCount=" + this.capturedDmlCount.get() + ", switchCounter=" + this.switchCounter.get() + ", lastLogMinerQueryDuration=" + this.lastLogMinerQueryDuration.get() + ", logMinerQueryCount=" + this.logMinerQueryCount.get() + ", averageLogMinerQueryDuration=" + this.averageLogMinerQueryDuration.get() + ", lastProcessedCapturedBatchDuration=" + this.lastProcessedCapturedBatchDuration.get() + ", processedCapturedBatchCount=" + this.processedCapturedBatchCount.get() + ", averageProcessedCapturedBatchDuration=" + this.averageProcessedCapturedBatchDuration.get() + ", millisecondToSleepBetweenMiningQuery=" + this.millisecondToSleepBetweenMiningQuery.get() + ", batchSize=" + this.batchSize.get() + '}';
    }
}

