/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.LogMinerMetrics;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.TransactionalBufferMetrics;
import io.debezium.jdbc.JdbcConnection;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerHelper {
    private static final String UNKNOWN = "unknown";
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerHelper.class);

    static void buildDataDictionary(Connection connection) throws SQLException {
        LogMinerHelper.executeCallableStatement(connection, "BEGIN DBMS_LOGMNR_D.BUILD (options => DBMS_LOGMNR_D.STORE_IN_REDO_LOGS); END;");
    }

    /*
     * Exception decompiling
     */
    public static long getCurrentScn(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void createAuditTable(Connection connection) throws SQLException {
        String recordExists;
        String tableExists = (String)LogMinerHelper.getSingleResult(connection, "SELECT '1' AS ONE FROM USER_TABLES WHERE TABLE_NAME = 'LOG_MINING_AUDIT'", DATATYPE.STRING);
        if (tableExists == null) {
            LogMinerHelper.executeCallableStatement(connection, "CREATE TABLE LOG_MINING_AUDIT(LAST_SCN NUMBER(19,0))");
        }
        if ((recordExists = (String)LogMinerHelper.getSingleResult(connection, "SELECT '1' AS ONE FROM LOG_MINING_AUDIT", DATATYPE.STRING)) == null) {
            LogMinerHelper.executeCallableStatement(connection, "INSERT INTO LOG_MINING_AUDIT VALUES(0)");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
    }

    static long getEndScn(Connection connection, long startScn, LogMinerMetrics metrics) throws SQLException {
        long currentScn = LogMinerHelper.getCurrentScn(connection);
        metrics.setCurrentScn(currentScn);
        int miningDiapason = metrics.getBatchSize();
        LogMinerHelper.executeCallableStatement(connection, "UPDATE LOG_MINING_AUDIT SET LAST_SCN =" + currentScn);
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
        boolean isNextScnCloseToDbCurrent = currentScn < startScn + (long)miningDiapason;
        metrics.changeSleepingTime(isNextScnCloseToDbCurrent);
        return isNextScnCloseToDbCurrent ? currentScn : startScn + (long)miningDiapason;
    }

    static Duration getTimeDifference(Connection connection) throws SQLException {
        Timestamp dbCurrentMillis = (Timestamp)LogMinerHelper.getSingleResult(connection, "select current_timestamp from dual", DATATYPE.TIMESTAMP);
        if (dbCurrentMillis == null) {
            return Duration.ZERO;
        }
        Instant fromDb = dbCurrentMillis.toInstant();
        Instant now = Instant.now();
        return Duration.between(fromDb, now);
    }

    static void startOnlineMining(Connection connection, Long startScn, Long endScn, OracleConnectorConfig.LogMiningStrategy strategy, boolean isContinuousMining) throws SQLException {
        String statement = SqlUtils.getStartLogMinerStatement(startScn, endScn, strategy, isContinuousMining);
        LogMinerHelper.executeCallableStatement(connection, statement);
    }

    static Set<String> getCurrentRedoLogFiles(Connection connection, LogMinerMetrics metrics) throws SQLException {
        String checkQuery = "select f.member from v$log log, v$logfile f  where log.group#=f.group# and log.status='CURRENT'";
        HashSet<String> fileNames = new HashSet<String>();
        try (PreparedStatement st = connection.prepareStatement(checkQuery);
             ResultSet result = st.executeQuery();){
            while (result.next()) {
                fileNames.add(result.getString(1));
                LOGGER.trace(" Current Redo log fileName: {} ", fileNames);
            }
        }
        LogMinerHelper.updateRedoLogMetrics(connection, metrics, fileNames);
        return fileNames;
    }

    static long getFirstOnlineLogScn(Connection connection) throws SQLException {
        LOGGER.trace("getting first scn of all online logs");
        Statement s = connection.createStatement();
        ResultSet res = s.executeQuery("SELECT MIN(FIRST_CHANGE#) FROM V$LOG");
        res.next();
        long firstScnOfOnlineLog = res.getLong(1);
        res.close();
        return firstScnOfOnlineLog;
    }

    static void setNlsSessionParameters(JdbcConnection connection) throws SQLException {
        connection.executeWithoutCommitting(new String[]{"ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'"});
    }

    private static void updateRedoLogMetrics(Connection connection, LogMinerMetrics metrics, Set<String> fileNames) {
        try {
            Map<String, String> logStatuses = LogMinerHelper.getRedoLogStatus(connection);
            metrics.setRedoLogStatus(logStatuses);
            int counter = LogMinerHelper.getSwitchCount(connection);
            metrics.setSwitchCount(counter);
            metrics.setCurrentLogFileName(fileNames);
        }
        catch (SQLException e) {
            LOGGER.error("Cannot update metrics");
        }
    }

    private static Map<String, String> getRedoLogStatus(Connection connection) throws SQLException {
        return LogMinerHelper.getMap(connection, "SELECT F.MEMBER, R.STATUS FROM V$LOGFILE F, V$LOG R WHERE F.GROUP# = R.GROUP# ORDER BY 2", UNKNOWN);
    }

    private static int getSwitchCount(Connection connection) {
        try {
            Map<String, String> total = LogMinerHelper.getMap(connection, "select 'total', count(1) from v$archived_log where first_time > trunc(sysdate) and dest_id = (select dest_id from V$ARCHIVE_DEST_STATUS where status='VALID' and type='LOCAL')", UNKNOWN);
            if (total != null && total.get("total") != null) {
                return Integer.parseInt(total.get("total"));
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get switch counter due to the {}", (Throwable)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkSupplementalLogging(OracleConnection connection, String pdbName) throws SQLException {
        try {
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            String key = "KEY";
            String validateGlobalLogging = "SELECT 'KEY',  SUPPLEMENTAL_LOG_DATA_ALL from V$DATABASE";
            Map<String, String> globalLogging = LogMinerHelper.getMap(connection.connection(false), validateGlobalLogging, UNKNOWN);
            if ("no".equalsIgnoreCase(globalLogging.get("KEY"))) {
                throw new RuntimeException("Supplemental logging was not set. Use command: ALTER DATABASE ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS");
            }
        }
        finally {
            if (pdbName != null) {
                connection.resetSessionToCdb();
            }
        }
    }

    static void endMining(Connection connection) {
        String stopMining = "BEGIN SYS.DBMS_LOGMNR.END_LOGMNR(); END;";
        try {
            LogMinerHelper.executeCallableStatement(connection, stopMining);
        }
        catch (SQLException e) {
            if (e.getMessage().toUpperCase().contains("ORA-01307")) {
                LOGGER.info("Log Miner session was already closed");
            }
            LOGGER.error("Cannot close Log Miner session gracefully: {}", (Throwable)e);
        }
    }

    static void setRedoLogFilesForMining(Connection connection, Long lastProcessedScn) throws SQLException {
        Map<String, Long> logFilesForMining = LogMinerHelper.getLogFilesForOffsetScn(connection, lastProcessedScn);
        if (logFilesForMining.isEmpty()) {
            throw new IllegalStateException("The online log files do not contain offset SCN: " + lastProcessedScn + ", re-snapshot is required.");
        }
        List logFilesNamesForMining = logFilesForMining.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        for (String file : logFilesNamesForMining) {
            String addLogFileStatement = SqlUtils.getAddLogFileStatement("DBMS_LOGMNR.ADDFILE", file);
            LogMinerHelper.executeCallableStatement(connection, addLogFileStatement);
            LOGGER.trace("add log file to the mining session = {}", (Object)file);
        }
        LOGGER.debug("Last mined SCN: {}, Log file list to mine: {}\n", (Object)lastProcessedScn, logFilesForMining);
    }

    static Optional<Long> getLastScnFromTheOldestOnlineRedo(Connection connection, Long offsetScn) throws SQLException {
        Map<String, String> allOnlineRedoLogFiles = LogMinerHelper.getMap(connection, "SELECT MIN(F.MEMBER) AS FILE_NAME, L.NEXT_CHANGE# AS NEXT_CHANGE, F.GROUP#  FROM V$LOG L, V$LOGFILE F  WHERE F.GROUP# = L.GROUP# AND L.NEXT_CHANGE# > 0  GROUP BY F.GROUP#, L.NEXT_CHANGE# ORDER BY 3", "-1");
        Map<String, Long> logFilesToMine = LogMinerHelper.getLogFilesForOffsetScn(connection, offsetScn);
        LOGGER.debug("Redo log size = {}, needed for mining files size = {}", (Object)allOnlineRedoLogFiles.size(), (Object)logFilesToMine.size());
        if (allOnlineRedoLogFiles.size() - logFilesToMine.size() <= 1) {
            List lastScnsInRedoLogToMine = logFilesToMine.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
            return lastScnsInRedoLogToMine.stream().min(Long::compareTo);
        }
        return Optional.empty();
    }

    static void logWarn(TransactionalBufferMetrics metrics, String format, Object ... args) {
        LOGGER.warn(format, args);
        metrics.incrementWarningCounter();
    }

    static void logError(TransactionalBufferMetrics metrics, String format, Object ... args) {
        LOGGER.error(format, args);
        metrics.incrementErrorCounter();
    }

    private static int getRedoLogGroupSize(Connection connection) throws SQLException {
        return LogMinerHelper.getMap(connection, "SELECT MIN(F.MEMBER) AS FILE_NAME, L.NEXT_CHANGE# AS NEXT_CHANGE, F.GROUP#  FROM V$LOG L, V$LOGFILE F  WHERE F.GROUP# = L.GROUP# AND L.NEXT_CHANGE# > 0  GROUP BY F.GROUP#, L.NEXT_CHANGE# ORDER BY 3", "-1").size();
    }

    private static Map<String, Long> getLogFilesForOffsetScn(Connection connection, Long offsetScn) throws SQLException {
        Map<String, String> redoLogFiles = LogMinerHelper.getMap(connection, "SELECT MIN(F.MEMBER) AS FILE_NAME, L.NEXT_CHANGE# AS NEXT_CHANGE, F.GROUP#  FROM V$LOG L, V$LOGFILE F  WHERE F.GROUP# = L.GROUP# AND L.NEXT_CHANGE# > 0  GROUP BY F.GROUP#, L.NEXT_CHANGE# ORDER BY 3", "-1");
        return redoLogFiles.entrySet().stream().filter(entry -> new BigInteger((String)entry.getValue()).longValue() > offsetScn || new BigInteger((String)entry.getValue()).longValue() == -1L).collect(Collectors.toMap(Map.Entry::getKey, e -> new BigInteger((String)e.getValue()).longValue() == -1L ? Long.MAX_VALUE : new BigInteger((String)e.getValue()).longValue()));
    }

    private static void executeCallableStatement(Connection connection, String statement) throws SQLException {
        Objects.requireNonNull(statement);
        try (CallableStatement s = connection.prepareCall(statement);){
            s.execute();
        }
    }

    /*
     * Exception decompiling
     */
    private static Map<String, String> getMap(Connection connection, String query, String nullReplacement) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static Object getSingleResult(Connection connection, String query, DATATYPE type) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static enum DATATYPE {
        LONG,
        TIMESTAMP,
        STRING;

    }
}

