/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.relational.TableId;
import java.util.HashSet;
import org.fest.assertions.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class SqlUtilsTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Test
    public void testStatements() {
        String result = SqlUtils.getAddLogFileStatement((String)"ADD", (String)"FILENAME");
        String expected = "BEGIN sys.dbms_logmnr.add_logfile(LOGFILENAME => 'FILENAME', OPTIONS => ADD);END;";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        OracleDatabaseSchema schema = (OracleDatabaseSchema)Mockito.mock(OracleDatabaseSchema.class);
        TableId table1 = new TableId("catalog", "schema", "table1");
        TableId table2 = new TableId("catalog", "schema", "table2");
        HashSet<TableId> tables = new HashSet<TableId>();
        Mockito.when((Object)schema.tableIds()).thenReturn(tables);
        result = SqlUtils.queryLogMinerContents((String)"DATABASE", (String)"SCHEMA", (OracleDatabaseSchema)schema);
        expected = "SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, USERNAME  FROM V$LOGMNR_CONTENTS WHERE  OPERATION_CODE in (1,2,3,5)  AND SEG_OWNER = 'DATABASE'  AND SCN >= ? AND SCN < ?  OR (OPERATION_CODE IN (5,7,34,36) AND USERNAME NOT IN ('SYS','SYSTEM','SCHEMA'))ORDER BY SCN";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        tables.add(table1);
        tables.add(table2);
        result = SqlUtils.queryLogMinerContents((String)"DATABASE", (String)"SCHEMA", (OracleDatabaseSchema)schema);
        expected = "SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, USERNAME  FROM V$LOGMNR_CONTENTS WHERE  OPERATION_CODE in (1,2,3,5)  AND SEG_OWNER = 'DATABASE'  AND table_name IN ('table1','table2') AND SEG_NAME IN ('table1','table2')  AND SCN >= ? AND SCN < ?  OR (OPERATION_CODE IN (5,7,34,36) AND USERNAME NOT IN ('SYS','SYSTEM','SCHEMA'))ORDER BY SCN";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.getStartLogMinerStatement((Long)10L, (Long)20L, (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG, (boolean)true);
        expected = "BEGIN sys.dbms_logmnr.start_logmnr(startScn => '10', endScn => '20', OPTIONS => DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG  + DBMS_LOGMNR.CONTINUOUS_MINE  + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
        result = SqlUtils.getStartLogMinerStatement((Long)10L, (Long)20L, (OracleConnectorConfig.LogMiningStrategy)OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO, (boolean)false);
        expected = "BEGIN sys.dbms_logmnr.start_logmnr(startScn => '10', endScn => '20', OPTIONS => DBMS_LOGMNR.DICT_FROM_REDO_LOGS + DBMS_LOGMNR.DDL_DICT_TRACKING  + DBMS_LOGMNR.NO_ROWID_IN_STMT);END;";
        Assertions.assertThat((boolean)expected.equals(result)).isTrue();
    }
}

