/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIs;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.TransactionalBufferMetrics;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class TransactionalBufferMetricsTest {
    private TransactionalBufferMetrics metrics;
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Before
    public void before() {
        CdcSourceTaskContext taskContext = (CdcSourceTaskContext)Mockito.mock(CdcSourceTaskContext.class);
        Mockito.when((Object)taskContext.getConnectorName()).thenReturn((Object)"connector name");
        Mockito.when((Object)taskContext.getConnectorType()).thenReturn((Object)"connector type");
        this.metrics = new TransactionalBufferMetrics(taskContext);
    }

    @After
    public void after() {
        this.metrics.reset();
    }

    @Test
    @SkipWhenAdapterNameIs(value=SkipWhenAdapterNameIs.AdapterName.LOGMINER, reason="Lag calculations fail")
    public void testLagMetrics() {
        long lag = this.metrics.getLagFromSource();
        Assertions.assertThat((lag == 0L ? 1 : 0) != 0).isTrue();
        Instant dbEventTime = Instant.now().minusMillis(2000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSource();
        Assertions.assertThat((lag == 2000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMaxLagFromSource() == 2000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMinLagFromSource() == 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getAverageLagFromSource() == 2000L ? 1 : 0) != 0).isTrue();
        dbEventTime = Instant.now().plusMillis(2000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSource();
        Assertions.assertThat((lag == -2000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMaxLagFromSource() == 2000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMinLagFromSource() == -2000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getAverageLagFromSource() == 0L ? 1 : 0) != 0).isTrue();
        this.metrics.reset();
        this.metrics.setTimeDifference(new AtomicLong(-1000L));
        dbEventTime = Instant.now().minusMillis(2000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSource();
        Assertions.assertThat((lag == 3000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMaxLagFromSource() == 3000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMinLagFromSource() == 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getAverageLagFromSource() == 3000L ? 1 : 0) != 0).isTrue();
        dbEventTime = Instant.now().minusMillis(3000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSource();
        Assertions.assertThat((lag == 4000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMaxLagFromSource() == 4000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMinLagFromSource() == 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getAverageLagFromSource() == 3500L ? 1 : 0) != 0).isTrue();
        this.metrics.reset();
        this.metrics.setTimeDifference(new AtomicLong(1000L));
        dbEventTime = Instant.now().minusMillis(2000L);
        this.metrics.calculateLagMetrics(dbEventTime);
        lag = this.metrics.getLagFromSource();
        Assertions.assertThat((lag == 1000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMaxLagFromSource() == 1000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getMinLagFromSource() == 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getAverageLagFromSource() == 1000L ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testOtherMetrics() {
        this.metrics.incrementScnFreezeCounter();
        Assertions.assertThat((this.metrics.getScnFreezeCounter() == 1 ? 1 : 0) != 0).isTrue();
        this.metrics.incrementErrorCounter();
        Assertions.assertThat((this.metrics.getErrorCounter() == 1 ? 1 : 0) != 0).isTrue();
        this.metrics.incrementWarningCounter();
        Assertions.assertThat((this.metrics.getWarningCounter() == 1 ? 1 : 0) != 0).isTrue();
        this.metrics.incrementCommittedDmlCounter(5000);
        for (int i = 0; i < 1000; ++i) {
            this.metrics.incrementCapturedDmlCounter();
            this.metrics.incrementCommittedTransactions();
        }
        Assertions.assertThat((this.metrics.getCapturedDmlCount() == 1000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getCapturedDmlThroughput() > 10000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getNumberOfCommittedTransactions() == 1000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.metrics.getCommitThroughput() >= 1000L ? 1 : 0) != 0).isTrue();
        this.metrics.incrementRolledBackTransactions();
        Assertions.assertThat((this.metrics.getNumberOfRolledBackTransactions() == 1L ? 1 : 0) != 0).isTrue();
        this.metrics.setActiveTransactions(Integer.valueOf(5));
        Assertions.assertThat((this.metrics.getNumberOfActiveTransactions() == 5 ? 1 : 0) != 0).isTrue();
        this.metrics.addRolledBackTransactionId("rolledback id");
        Assertions.assertThat((this.metrics.getNumberOfRolledBackTransactions() == 1L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)this.metrics.getRolledBackTransactionIds().contains("rolledback id")).isTrue();
        this.metrics.addAbandonedTransactionId("abandoned id");
        Assertions.assertThat((this.metrics.getAbandonedTransactionIds().size() == 1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)this.metrics.getAbandonedTransactionIds().contains("abandoned id")).isTrue();
        this.metrics.setOldestScn(Long.valueOf(10L));
        Assertions.assertThat((this.metrics.getOldestScn() == 10L ? 1 : 0) != 0).isTrue();
        this.metrics.setCommittedScn(Long.valueOf(10L));
        Assertions.assertThat((this.metrics.getCommittedScn() == 10L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)this.metrics.toString().contains("capturedDmlCounter=1000")).isTrue();
    }
}

