/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.logminer.TransactionalBufferMetricsMXBean;
import io.debezium.metrics.Metrics;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class TransactionalBufferMetrics
extends Metrics
implements TransactionalBufferMetricsMXBean {
    private final AtomicLong oldestScn = new AtomicLong();
    private final AtomicLong committedScn = new AtomicLong();
    private final AtomicReference<Duration> lagFromTheSource = new AtomicReference();
    private final AtomicInteger activeTransactions = new AtomicInteger();
    private final AtomicLong rolledBackTransactions = new AtomicLong();
    private final AtomicLong committedTransactions = new AtomicLong();
    private final AtomicLong capturedDmlCounter = new AtomicLong();
    private final AtomicLong committedDmlCounter = new AtomicLong();
    private final AtomicInteger commitQueueCapacity = new AtomicInteger();
    private final AtomicReference<Duration> maxLagFromTheSource = new AtomicReference();
    private final AtomicReference<Duration> minLagFromTheSource = new AtomicReference();
    private final AtomicReference<Duration> averageLagsFromTheSource = new AtomicReference();
    private final AtomicReference<Set<String>> abandonedTransactionIds = new AtomicReference();
    private final AtomicReference<Set<String>> rolledBackTransactionIds = new AtomicReference();
    private final Instant startTime;
    private static final long MILLIS_PER_SECOND = 1000L;
    private final AtomicLong timeDifference = new AtomicLong();
    private final AtomicInteger errorCounter = new AtomicInteger();
    private final AtomicInteger warningCounter = new AtomicInteger();
    private final AtomicInteger scnFreezeCounter = new AtomicInteger();

    TransactionalBufferMetrics(CdcSourceTaskContext taskContext) {
        super(taskContext, "log-miner-transactional-buffer");
        this.startTime = Instant.now();
        this.oldestScn.set(-1L);
        this.committedScn.set(-1L);
        this.timeDifference.set(0L);
        this.reset();
    }

    void setOldestScn(Long scn) {
        this.oldestScn.set(scn);
    }

    public void setCommittedScn(Long scn) {
        this.committedScn.set(scn);
    }

    public void setTimeDifference(AtomicLong timeDifference) {
        this.timeDifference.set(timeDifference.get());
    }

    void calculateLagMetrics(Instant changeTime) {
        if (changeTime != null) {
            Instant correctedChangeTime = changeTime.plus(Duration.ofMillis(this.timeDifference.longValue()));
            this.lagFromTheSource.set(Duration.between(correctedChangeTime, Instant.now()).abs());
            if (this.maxLagFromTheSource.get().toMillis() < this.lagFromTheSource.get().toMillis()) {
                this.maxLagFromTheSource.set(this.lagFromTheSource.get());
            }
            if (this.minLagFromTheSource.get().toMillis() > this.lagFromTheSource.get().toMillis()) {
                this.minLagFromTheSource.set(this.lagFromTheSource.get());
            }
            if (this.averageLagsFromTheSource.get().isZero()) {
                this.averageLagsFromTheSource.set(this.lagFromTheSource.get());
            } else {
                this.averageLagsFromTheSource.set(this.averageLagsFromTheSource.get().plus(this.lagFromTheSource.get()).dividedBy(2L));
            }
        }
    }

    void setActiveTransactions(Integer counter) {
        if (counter != null) {
            this.activeTransactions.set(counter);
        }
    }

    void incrementRolledBackTransactions() {
        this.rolledBackTransactions.incrementAndGet();
    }

    void incrementCommittedTransactions() {
        this.committedTransactions.incrementAndGet();
    }

    void incrementCapturedDmlCounter() {
        this.capturedDmlCounter.incrementAndGet();
    }

    void incrementCommittedDmlCounter(int counter) {
        this.committedDmlCounter.getAndAdd(counter);
    }

    void addAbandonedTransactionId(String transactionId) {
        if (transactionId != null) {
            this.abandonedTransactionIds.get().add(transactionId);
        }
    }

    void addRolledBackTransactionId(String transactionId) {
        if (transactionId != null) {
            this.rolledBackTransactionIds.get().add(transactionId);
        }
    }

    void incrementErrorCounter() {
        this.errorCounter.incrementAndGet();
    }

    void incrementWarningCounter() {
        this.warningCounter.incrementAndGet();
    }

    void incrementScnFreezeCounter() {
        this.scnFreezeCounter.incrementAndGet();
    }

    @Override
    public Long getOldestScn() {
        return this.oldestScn.get();
    }

    @Override
    public Long getCommittedScn() {
        return this.committedScn.get();
    }

    @Override
    public int getNumberOfActiveTransactions() {
        return this.activeTransactions.get();
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.rolledBackTransactions.get();
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.committedTransactions.get();
    }

    @Override
    public long getCommitThroughput() {
        long timeSpent = Duration.between(this.startTime, Instant.now()).isZero() ? 1L : Duration.between(this.startTime, Instant.now()).toMillis();
        return this.committedTransactions.get() * 1000L / timeSpent;
    }

    @Override
    public long getCapturedDmlThroughput() {
        long timeSpent = Duration.between(this.startTime, Instant.now()).isZero() ? 1L : Duration.between(this.startTime, Instant.now()).toMillis();
        return this.committedDmlCounter.get() * 1000L / timeSpent;
    }

    @Override
    public long getCapturedDmlCount() {
        return this.capturedDmlCounter.longValue();
    }

    @Override
    public long getLagFromSource() {
        return this.lagFromTheSource.get().toMillis();
    }

    @Override
    public long getMaxLagFromSource() {
        return this.maxLagFromTheSource.get().toMillis();
    }

    @Override
    public long getMinLagFromSource() {
        return this.minLagFromTheSource.get().toMillis();
    }

    @Override
    public long getAverageLagFromSource() {
        return this.averageLagsFromTheSource.get().toMillis();
    }

    @Override
    public Set<String> getAbandonedTransactionIds() {
        return this.abandonedTransactionIds.get();
    }

    @Override
    public Set<String> getRolledBackTransactionIds() {
        return this.rolledBackTransactionIds.get();
    }

    @Override
    public int getErrorCounter() {
        return this.errorCounter.get();
    }

    @Override
    public int getWarningCounter() {
        return this.warningCounter.get();
    }

    @Override
    public int getScnFreezeCounter() {
        return this.scnFreezeCounter.get();
    }

    @Override
    public int getCommitQueueCapacity() {
        return this.commitQueueCapacity.get();
    }

    void setCommitQueueCapacity(int commitQueueCapacity) {
        this.commitQueueCapacity.set(commitQueueCapacity);
    }

    @Override
    public void reset() {
        this.maxLagFromTheSource.set(Duration.ZERO);
        this.minLagFromTheSource.set(Duration.ZERO);
        this.averageLagsFromTheSource.set(Duration.ZERO);
        this.activeTransactions.set(0);
        this.rolledBackTransactions.set(0L);
        this.committedTransactions.set(0L);
        this.capturedDmlCounter.set(0L);
        this.committedDmlCounter.set(0L);
        this.abandonedTransactionIds.set(new HashSet());
        this.rolledBackTransactionIds.set(new HashSet());
        this.lagFromTheSource.set(Duration.ZERO);
        this.errorCounter.set(0);
        this.warningCounter.set(0);
        this.scnFreezeCounter.set(0);
        this.commitQueueCapacity.set(0);
    }

    public String toString() {
        return "TransactionalBufferMetrics{oldestScn=" + this.oldestScn.get() + ", committedScn=" + this.committedScn.get() + ", lagFromTheSource=" + this.lagFromTheSource.get() + ", activeTransactions=" + this.activeTransactions.get() + ", rolledBackTransactions=" + this.rolledBackTransactions.get() + ", committedTransactions=" + this.committedTransactions.get() + ", capturedDmlCounter=" + this.capturedDmlCounter.get() + ", committedDmlCounter=" + this.committedDmlCounter.get() + ", maxLagFromTheSource=" + this.maxLagFromTheSource.get() + ", minLagFromTheSource=" + this.minLagFromTheSource.get() + ", averageLagsFromTheSource=" + this.averageLagsFromTheSource.get() + ", abandonedTransactionIds=" + this.abandonedTransactionIds.get() + ", errorCounter=" + this.errorCounter.get() + ", warningCounter=" + this.warningCounter.get() + ", scnFreezeCounter=" + this.scnFreezeCounter.get() + ", commitQueueCapacity=" + this.commitQueueCapacity.get() + '}';
    }
}

