/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.RowMapper;
import io.debezium.connector.oracle.logminer.TransactionalBufferMetrics;
import io.debezium.relational.TableId;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class RowMapperTest {
    private ResultSet rs;
    private TransactionalBufferMetrics metrics;
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();

    @Before
    public void before() {
        this.rs = (ResultSet)Mockito.mock(ResultSet.class);
        this.metrics = (TransactionalBufferMetrics)Mockito.mock(TransactionalBufferMetrics.class);
    }

    @Test
    public void testChangeTime() throws SQLException {
        Mockito.when((Object)this.rs.getTimestamp(4)).thenReturn((Object)new Timestamp(1000L));
        Timestamp time = RowMapper.getChangeTime((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((time.getTime() == 1000L ? 1 : 0) != 0).isTrue();
        Mockito.when((Object)this.rs.getTimestamp(4)).thenThrow(SQLException.class);
        time = RowMapper.getChangeTime((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((time.getTime() == new Timestamp(Instant.now().getEpochSecond()).getTime() ? 1 : 0) != 0).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)2))).getTimestamp(4);
    }

    @Test
    public void testOperationCode() throws SQLException {
        Mockito.when((Object)this.rs.getInt(3)).thenReturn((Object)100);
        int operation = RowMapper.getOperationCode((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((operation == 100 ? 1 : 0) != 0).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs)).getInt(3);
        Mockito.when((Object)this.rs.getInt(3)).thenThrow(SQLException.class);
        operation = RowMapper.getOperationCode((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((operation == 0 ? 1 : 0) != 0).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)2))).getInt(3);
    }

    @Test
    public void testTableName() throws SQLException {
        Mockito.when((Object)this.rs.getString(7)).thenReturn((Object)"table_name");
        String tableName = RowMapper.getTableName((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)tableName.equals("table_name")).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs)).getString(7);
        Mockito.when((Object)this.rs.getString(7)).thenThrow(SQLException.class);
        tableName = RowMapper.getTableName((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)tableName.equals("")).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)2))).getString(7);
    }

    @Test
    public void testSeqOwner() throws SQLException {
        Mockito.when((Object)this.rs.getString(8)).thenReturn((Object)"owner");
        String owner = RowMapper.getSegOwner((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)owner.equals("owner")).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs)).getString(8);
        Mockito.when((Object)this.rs.getString(8)).thenThrow(SQLException.class);
        owner = RowMapper.getSegOwner((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)owner.equals("")).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)2))).getString(8);
    }

    @Test
    public void testGetScn() throws SQLException {
        Mockito.when((Object)this.rs.getBigDecimal(1)).thenReturn((Object)new BigDecimal(1));
        BigDecimal scn = RowMapper.getScn((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)scn.equals(new BigDecimal(1))).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs)).getBigDecimal(1);
        Mockito.when((Object)this.rs.getBigDecimal(1)).thenThrow(SQLException.class);
        scn = RowMapper.getScn((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)scn.equals(new BigDecimal(-1))).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)2))).getBigDecimal(1);
    }

    @Test
    public void testGetTransactionId() throws SQLException {
        Mockito.when((Object)this.rs.getBytes(5)).thenReturn((Object)"tr_id".getBytes());
        String transactionId = RowMapper.getTransactionId((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)transactionId.equals("74725F6964")).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs)).getBytes(5);
        Mockito.when((Object)this.rs.getBytes(5)).thenThrow(SQLException.class);
        transactionId = RowMapper.getTransactionId((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)transactionId.equals("")).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)2))).getBytes(5);
    }

    @Test
    public void testSqlRedo() throws SQLException {
        Mockito.when((Object)this.rs.getInt(6)).thenReturn((Object)0);
        Mockito.when((Object)this.rs.getString(2)).thenReturn((Object)"short_sql");
        String sql = RowMapper.getSqlRedo((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)sql.equals("short_sql")).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs)).getInt(6);
        ((ResultSet)Mockito.verify((Object)this.rs)).getString(2);
        Mockito.when((Object)this.rs.getInt(6)).thenReturn((Object)1).thenReturn((Object)0);
        Mockito.when((Object)this.rs.getString(2)).thenReturn((Object)"long").thenReturn((Object)"_sql");
        sql = RowMapper.getSqlRedo((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)sql.equals("long_sql")).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)3))).getInt(6);
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)3))).getString(2);
        char[] chars = new char[4000];
        Arrays.fill(chars, 'a');
        Mockito.when((Object)this.rs.getString(2)).thenReturn((Object)new String(chars));
        Mockito.when((Object)this.rs.getInt(6)).thenReturn((Object)1);
        sql = RowMapper.getSqlRedo((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((sql.length() == 40000 ? 1 : 0) != 0).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)13))).getInt(6);
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)13))).getString(2);
        Mockito.when((Object)this.rs.getInt(6)).thenReturn((Object)0);
        Mockito.when((Object)this.rs.getString(2)).thenReturn(null);
        sql = RowMapper.getSqlRedo((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((sql == null ? 1 : 0) != 0).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)13))).getInt(6);
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)14))).getString(2);
        Mockito.when((Object)this.rs.getInt(6)).thenReturn((Object)0);
        Mockito.when((Object)this.rs.getString(2)).thenThrow(SQLException.class);
        sql = RowMapper.getSqlRedo((TransactionalBufferMetrics)this.metrics, (ResultSet)this.rs);
        Assertions.assertThat((boolean)sql.equals("")).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)13))).getInt(6);
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)15))).getString(2);
    }

    @Test
    public void testGetTableId() throws SQLException {
        Mockito.when((Object)this.rs.getString(8)).thenReturn((Object)"schema");
        Mockito.when((Object)this.rs.getString(7)).thenReturn((Object)"table");
        TableId tableId = RowMapper.getTableId((String)"catalog", (ResultSet)this.rs);
        Assertions.assertThat((boolean)tableId.toString().equals("CATALOG.SCHEMA.TABLE")).isTrue();
        ((ResultSet)Mockito.verify((Object)this.rs)).getString(8);
        Mockito.when((Object)this.rs.getString(8)).thenThrow(SQLException.class);
        tableId = null;
        try {
            tableId = RowMapper.getTableId((String)"catalog", (ResultSet)this.rs);
            Assertions.assertThat((boolean)false).isTrue();
        }
        catch (SQLException e) {
            Assertions.assertThat((Object)tableId).isNull();
        }
    }
}

