/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.jsqlparser.SimpleDmlParser;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.LogMinerMetrics;
import io.debezium.connector.oracle.logminer.LogMinerQueryResultProcessor;
import io.debezium.connector.oracle.logminer.OracleChangeRecordValueConverter;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.TransactionalBuffer;
import io.debezium.connector.oracle.logminer.TransactionalBufferMetrics;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import oracle.net.ns.NetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerStreamingChangeEventSource
implements StreamingChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerStreamingChangeEventSource.class);
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<TableId> dispatcher;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final OracleOffsetContext offsetContext;
    private final SimpleDmlParser dmlParser;
    private final String catalogName;
    private OracleConnectorConfig connectorConfig;
    private TransactionalBufferMetrics transactionalBufferMetrics;
    private LogMinerMetrics logMinerMetrics;
    private TransactionalBuffer transactionalBuffer;
    private final OracleConnectorConfig.LogMiningStrategy strategy;
    private final OracleTaskContext taskContext;
    private final ErrorHandler errorHandler;
    private final boolean isContinuousMining;
    private long startScn;
    private long endScn;

    public LogMinerStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleOffsetContext offsetContext, OracleConnection jdbcConnection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, OracleTaskContext taskContext) {
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext;
        OracleChangeRecordValueConverter converters = new OracleChangeRecordValueConverter(jdbcConnection);
        this.connectorConfig = connectorConfig;
        this.catalogName = connectorConfig.getPdbName() != null ? connectorConfig.getPdbName() : connectorConfig.getDatabaseName();
        this.dmlParser = new SimpleDmlParser(this.catalogName, connectorConfig.getSchemaName(), converters);
        this.strategy = connectorConfig.getLogMiningStrategy();
        this.isContinuousMining = connectorConfig.isContinuousMining();
        this.errorHandler = errorHandler;
        this.taskContext = taskContext;
    }

    public void execute(ChangeEventSource.ChangeEventSourceContext context) {
        this.transactionalBufferMetrics = new TransactionalBufferMetrics(this.taskContext);
        this.transactionalBufferMetrics.register(LOGGER);
        this.transactionalBuffer = new TransactionalBuffer(this.connectorConfig.getLogicalName(), this.errorHandler, this.transactionalBufferMetrics, this.connectorConfig.getMaxQueueSize());
        this.logMinerMetrics = new LogMinerMetrics(this.taskContext);
        this.logMinerMetrics.register(LOGGER);
        while (context.isRunning()) {
            try (Connection connection = this.jdbcConnection.connection(false);
                 PreparedStatement fetchFromMiningView = connection.prepareStatement(SqlUtils.queryLogMinerContents(this.connectorConfig.getSchemaName(), this.jdbcConnection.username(), this.schema));){
                this.startScn = this.offsetContext.getScn();
                LogMinerHelper.createAuditTable(connection);
                LOGGER.trace("current millis {}, db time {}", (Object)System.currentTimeMillis(), (Object)LogMinerHelper.getTimeDifference(connection).toMillis());
                this.transactionalBufferMetrics.setTimeDifference(new AtomicLong(LogMinerHelper.getTimeDifference(connection).toMillis()));
                if (!this.isContinuousMining && this.startScn < LogMinerHelper.getFirstOnlineLogScn(connection)) {
                    throw new RuntimeException("Online REDO LOG files don't contain the offset SCN. Clean offset and start over");
                }
                LogMinerHelper.setNlsSessionParameters(this.jdbcConnection);
                LogMinerHelper.checkSupplementalLogging(this.jdbcConnection, this.connectorConfig.getPdbName());
                if (this.strategy == OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO) {
                    LogMinerHelper.buildDataDictionary(connection);
                }
                if (!this.isContinuousMining) {
                    LogMinerHelper.setRedoLogFilesForMining(connection, this.startScn);
                }
                LogMinerQueryResultProcessor processor = new LogMinerQueryResultProcessor(context, this.logMinerMetrics, this.transactionalBuffer, this.dmlParser, this.offsetContext, this.schema, this.dispatcher, this.transactionalBufferMetrics, this.catalogName, this.clock);
                Set<String> currentRedoLogFiles = LogMinerHelper.getCurrentRedoLogFiles(connection, this.logMinerMetrics);
                while (context.isRunning()) {
                    this.endScn = LogMinerHelper.getEndScn(connection, this.startScn, this.logMinerMetrics);
                    Metronome metronome = Metronome.sleeper((Duration)Duration.ofMillis(this.logMinerMetrics.getMillisecondToSleepBetweenMiningQuery().intValue()), (Clock)this.clock);
                    metronome.pause();
                    Set<String> possibleNewCurrentLogFile = LogMinerHelper.getCurrentRedoLogFiles(connection, this.logMinerMetrics);
                    if (!currentRedoLogFiles.equals(possibleNewCurrentLogFile)) {
                        LOGGER.debug("\n\n***** SWITCH occurred *****\n from:{} , to:{} \n\n", currentRedoLogFiles, possibleNewCurrentLogFile);
                        LogMinerHelper.endMining(connection);
                        if (!this.isContinuousMining) {
                            if (this.strategy == OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO) {
                                LogMinerHelper.buildDataDictionary(connection);
                            }
                            this.abandonOldTransactionsIfExist(connection);
                            LogMinerHelper.setRedoLogFilesForMining(connection, this.startScn);
                        }
                        currentRedoLogFiles = LogMinerHelper.getCurrentRedoLogFiles(connection, this.logMinerMetrics);
                    }
                    LogMinerHelper.startOnlineMining(connection, this.startScn, this.endScn, this.strategy, this.isContinuousMining);
                    Instant startTime = Instant.now();
                    fetchFromMiningView.setFetchSize(10000);
                    fetchFromMiningView.setLong(1, this.startScn);
                    fetchFromMiningView.setLong(2, this.endScn);
                    ResultSet res = fetchFromMiningView.executeQuery();
                    this.logMinerMetrics.setLastLogMinerQueryDuration(Duration.between(startTime, Instant.now()));
                    processor.processResult(res);
                    this.updateStartScn();
                    if (this.transactionalBuffer.isEmpty()) {
                        this.offsetContext.setScn(this.startScn);
                        this.transactionalBuffer.resetLargestScn(null);
                    }
                    res.close();
                }
            }
            catch (Throwable e) {
                block39: {
                    try {
                        if (!this.connectionProblem(e)) break block39;
                        LogMinerHelper.logWarn(this.transactionalBufferMetrics, "Disconnection occurred. {} ", e.toString());
                    }
                    catch (Throwable throwable) {
                        LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, this.offsetContext.getScn()});
                        LOGGER.info("Transactional buffer metrics dump: {}", (Object)this.transactionalBufferMetrics.toString());
                        LOGGER.info("Transactional buffer dump: {}", (Object)this.transactionalBuffer.toString());
                        LOGGER.info("LogMiner metrics dump: {}", (Object)this.logMinerMetrics.toString());
                        throw throwable;
                    }
                    LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, this.offsetContext.getScn()});
                    LOGGER.info("Transactional buffer metrics dump: {}", (Object)this.transactionalBufferMetrics.toString());
                    LOGGER.info("Transactional buffer dump: {}", (Object)this.transactionalBuffer.toString());
                    LOGGER.info("LogMiner metrics dump: {}", (Object)this.logMinerMetrics.toString());
                    continue;
                }
                LogMinerHelper.logError(this.transactionalBufferMetrics, "Mining session was stopped due to the {} ", e.toString());
                throw new RuntimeException(e);
            }
            LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, this.offsetContext.getScn()});
            LOGGER.info("Transactional buffer metrics dump: {}", (Object)this.transactionalBufferMetrics.toString());
            LOGGER.info("Transactional buffer dump: {}", (Object)this.transactionalBuffer.toString());
            LOGGER.info("LogMiner metrics dump: {}", (Object)this.logMinerMetrics.toString());
        }
        this.logMinerMetrics.unregister(LOGGER);
        this.transactionalBufferMetrics.unregister(LOGGER);
    }

    private void abandonOldTransactionsIfExist(Connection connection) throws SQLException {
        Optional<Long> lastScnToAbandonTransactions = LogMinerHelper.getLastScnFromTheOldestOnlineRedo(connection, this.offsetContext.getScn());
        lastScnToAbandonTransactions.ifPresent(thresholdScn -> {
            LogMinerHelper.logWarn(this.transactionalBufferMetrics, "All transactions with first SCN <= {} will be abandoned, offset: {}", thresholdScn, this.offsetContext.getScn());
            this.transactionalBuffer.abandonLongTransactions((Long)thresholdScn);
            this.offsetContext.setScn((long)thresholdScn);
            this.updateStartScn();
        });
    }

    private void updateStartScn() {
        long nextStartScn;
        long l = nextStartScn = this.transactionalBuffer.getLargestScn().equals(BigDecimal.ZERO) ? this.endScn : this.transactionalBuffer.getLargestScn().longValue();
        if (nextStartScn <= this.startScn) {
            this.transactionalBuffer.resetLargestScn(this.endScn);
        }
        this.startScn = this.endScn;
    }

    public void commitOffset(Map<String, ?> offset) {
    }

    private boolean connectionProblem(Throwable e) {
        if (e.getMessage() == null || e.getCause() == null) {
            return false;
        }
        return e.getMessage().startsWith("ORA-03135") || e.getMessage().startsWith("ORA-12543") || e.getMessage().startsWith("ORA-00604") || e.getMessage().startsWith("ORA-01089") || e.getCause() instanceof IOException || e instanceof SQLRecoverableException || e.getMessage().toUpperCase().startsWith("NO MORE DATA TO READ FROM SOCKET") || e.getCause().getCause() instanceof NetException;
    }
}

