/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class OracleConnectionFactory
implements JdbcConnection.ConnectionFactory {
    public Connection connect(JdbcConfiguration config) throws SQLException {
        String hostName = config.getHostname();
        int port = config.getPort();
        String database = config.getDatabase();
        String user = config.getUser();
        String password = config.getPassword();
        String url = "jdbc:oracle:" + OracleConnectionFactory.getDriverType(config) + ":@" + hostName + ":" + port + "/" + database;
        return DriverManager.getConnection(url, user, password);
    }

    private static String getDriverType(JdbcConfiguration config) {
        return OracleConnectorConfig.ConnectorAdapter.parse(config.getString(OracleConnectorConfig.CONNECTOR_ADAPTER)).getDriverType();
    }
}

