/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.RelationalChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.util.Clock;
import oracle.streams.ColumnValue;
import oracle.streams.RowLCR;

public class XStreamChangeRecordEmitter
extends RelationalChangeRecordEmitter {
    private final RowLCR lcr;
    private final Table table;

    public XStreamChangeRecordEmitter(OffsetContext offset, RowLCR lcr, Table table, Clock clock) {
        super(offset, clock);
        this.lcr = lcr;
        this.table = table;
    }

    protected Envelope.Operation getOperation() {
        switch (this.lcr.getCommandType()) {
            case "INSERT": {
                return Envelope.Operation.CREATE;
            }
            case "DELETE": {
                return Envelope.Operation.DELETE;
            }
            case "UPDATE": {
                return Envelope.Operation.UPDATE;
            }
        }
        throw new IllegalArgumentException("Received event of unexpected command type: " + this.lcr);
    }

    protected Object[] getOldColumnValues() {
        return this.getColumnValues(this.lcr.getOldValues());
    }

    protected Object[] getNewColumnValues() {
        return this.getColumnValues(this.lcr.getNewValues());
    }

    private Object[] getColumnValues(ColumnValue[] columnValues) {
        Object[] values = new Object[this.table.columns().size()];
        for (ColumnValue columnValue : columnValues) {
            int index = this.table.columnWithName(columnValue.getColumnName()).position() - 1;
            values[index] = columnValue.getColumnData();
        }
        return values;
    }
}

