/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.fest.assertions.MapAssert;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class OracleConnectorIT
extends AbstractConnectorTest {
    private static final long MICROS_PER_SECOND = TimeUnit.SECONDS.toMicros(1L);
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private static OracleConnection connection;

    @BeforeClass
    public static void beforeClass() throws SQLException {
        connection = TestHelper.testConnection();
        TestHelper.dropTable(connection, "debezium.customer");
        TestHelper.dropTable(connection, "debezium.masked_hashed_column_table");
        TestHelper.dropTable(connection, "debezium.truncated_column_table");
        TestHelper.dropTable(connection, "debezium.dt_table");
        String ddl = "create table debezium.customer (  id numeric(9,0) not null,   name varchar2(1000),   score decimal(6, 2),   registered timestamp,   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.customer to  c##xstrm"});
        connection.execute(new String[]{"ALTER TABLE debezium.customer ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        String ddl2 = "create table debezium.masked_hashed_column_table (  id numeric(9,0) not null,   name varchar2(255),   name2 varchar2(255),   name3 varchar2(20),  primary key (id))";
        connection.execute(new String[]{ddl2});
        connection.execute(new String[]{"GRANT SELECT ON debezium.masked_hashed_column_table to  c##xstrm"});
        connection.execute(new String[]{"ALTER TABLE debezium.masked_hashed_column_table ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        String ddl3 = "create table debezium.truncated_column_table (  id numeric(9,0) not null,   name varchar2(20),   primary key (id))";
        connection.execute(new String[]{ddl3});
        connection.execute(new String[]{"GRANT SELECT ON debezium.truncated_column_table to  c##xstrm"});
        connection.execute(new String[]{"ALTER TABLE debezium.truncated_column_table ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        String ddl4 = "create table dt_table (  id numeric(9,0) not null,   c1 int,   c2 int,   c3a numeric(5,2),   c3b varchar(128),   f1 float(10),   f2 decimal(8,4),   primary key (id))";
        connection.execute(new String[]{ddl4});
        connection.execute(new String[]{"GRANT SELECT ON debezium.dt_table to  c##xstrm"});
        connection.execute(new String[]{"ALTER TABLE debezium.dt_table ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Before
    public void before() throws SQLException {
        connection.execute(new String[]{"delete from debezium.customer"});
        connection.execute(new String[]{"delete from debezium.masked_hashed_column_table"});
        connection.execute(new String[]{"delete from debezium.truncated_column_table"});
        connection.execute(new String[]{"delete from debezium.dt_table"});
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @Test
    public void shouldTakeSnapshot() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "DEBEZIUM\\.CUSTOMER")).build();
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (2, 'Bruce', 2345.67, null)"});
        connection.execute(new String[]{"COMMIT"});
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount += 2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record1 = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValidRead((SourceRecord)record1, (String)"ID", (int)1);
        Struct after = (Struct)((Struct)record1.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
        Assertions.assertThat(record1.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat(record1.sourceOffset().get(SNAPSHOT_COMPLETED_KEY)).isEqualTo((Object)false);
        Struct source = (Struct)((Struct)record1.value()).get("source");
        Assertions.assertThat((Object)source.get("snapshot")).isEqualTo((Object)"true");
        SourceRecord record2 = (SourceRecord)testTableRecords.get(1);
        VerifyRecord.isValidRead((SourceRecord)record2, (String)"ID", (int)2);
        after = (Struct)((Struct)record2.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)after.get("REGISTERED")).isNull();
        Assertions.assertThat(record2.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat(record2.sourceOffset().get(SNAPSHOT_COMPLETED_KEY)).isEqualTo((Object)true);
        source = (Struct)((Struct)record2.value()).get("source");
        Assertions.assertThat((Object)source.get("snapshot")).isEqualTo((Object)"last");
    }

    @Test
    public void shouldContinueWithStreamingAfterSnapshot() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "DEBEZIUM\\.CUSTOMER")).build();
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (2, 'Bruce', 2345.67, null)"});
        connection.execute(new String[]{"COMMIT"});
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount += 2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record1 = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValidRead((SourceRecord)record1, (String)"ID", (int)1);
        Struct after = (Struct)((Struct)record1.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Struct source = (Struct)((Struct)record1.value()).get("source");
        Assertions.assertThat((Object)source.get("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((Object)source.get("scn")).isNotNull();
        Assertions.assertThat((Object)source.get("name")).isEqualTo((Object)"server1");
        Assertions.assertThat((Object)source.get("version")).isNotNull();
        Assertions.assertThat((Object)source.get("txId")).isNull();
        Assertions.assertThat((Object)source.get("ts_ms")).isNotNull();
        Assertions.assertThat(record1.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat(record1.sourceOffset().get(SNAPSHOT_COMPLETED_KEY)).isEqualTo((Object)false);
        SourceRecord record2 = (SourceRecord)testTableRecords.get(1);
        VerifyRecord.isValidRead((SourceRecord)record2, (String)"ID", (int)2);
        after = (Struct)((Struct)record2.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat(record2.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat(record2.sourceOffset().get(SNAPSHOT_COMPLETED_KEY)).isEqualTo((Object)true);
        expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (3, 'Brian', 2345.67, null)"});
        connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(++expectedRecordCount);
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record3 = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record3, (String)"ID", (int)3);
        after = (Struct)((Struct)record3.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((boolean)record3.sourceOffset().containsKey("snapshot")).isFalse();
        Assertions.assertThat((boolean)record3.sourceOffset().containsKey(SNAPSHOT_COMPLETED_KEY)).isFalse();
        source = (Struct)((Struct)record3.value()).get("source");
        Assertions.assertThat((Object)source.get("snapshot")).isEqualTo((Object)"false");
        Assertions.assertThat((Object)source.get("scn")).isNotNull();
        Assertions.assertThat((Object)source.get("name")).isEqualTo((Object)"server1");
        Assertions.assertThat((Object)source.get("version")).isNotNull();
        Assertions.assertThat((Object)source.get("txId")).isNotNull();
        Assertions.assertThat((Object)source.get("ts_ms")).isNotNull();
    }

    @Test
    @FixFor(value={"DBZ-1223"})
    public void shouldStreamTransaction() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "DEBEZIUM\\.CUSTOMER")).build();
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (2, 'Bruce', 2345.67, null)"});
        connection.execute(new String[]{"COMMIT"});
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount += 2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record1 = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValidRead((SourceRecord)record1, (String)"ID", (int)1);
        Struct after = (Struct)((Struct)record1.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Struct source = (Struct)((Struct)record1.value()).get("source");
        Assertions.assertThat((Object)source.get("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((Object)source.get("scn")).isNotNull();
        Assertions.assertThat((Object)source.get("name")).isEqualTo((Object)"server1");
        Assertions.assertThat((Object)source.get("version")).isNotNull();
        Assertions.assertThat((Object)source.get("txId")).isNull();
        Assertions.assertThat((Object)source.get("ts_ms")).isNotNull();
        Assertions.assertThat(record1.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat(record1.sourceOffset().get(SNAPSHOT_COMPLETED_KEY)).isEqualTo((Object)false);
        SourceRecord record2 = (SourceRecord)testTableRecords.get(1);
        VerifyRecord.isValidRead((SourceRecord)record2, (String)"ID", (int)2);
        after = (Struct)((Struct)record2.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat(record2.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat(record2.sourceOffset().get(SNAPSHOT_COMPLETED_KEY)).isEqualTo((Object)true);
        expectedRecordCount = 30;
        connection.setAutoCommit(false);
        this.sendTxBatch(expectedRecordCount, 100);
        this.sendTxBatch(expectedRecordCount, 200);
    }

    private void sendTxBatch(int expectedRecordCount, int offset) throws SQLException, InterruptedException {
        for (int i = offset; i < expectedRecordCount + offset; ++i) {
            connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO debezium.customer VALUES (%s, 'Brian%s', 2345.67, null)", i, i)});
        }
        connection.connection().commit();
        this.assertTxBatch(expectedRecordCount, offset);
    }

    private void assertTxBatch(int expectedRecordCount, int offset) throws InterruptedException {
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        for (int i = 0; i < expectedRecordCount; ++i) {
            SourceRecord record3 = (SourceRecord)testTableRecords.get(i);
            VerifyRecord.isValidInsert((SourceRecord)record3, (String)"ID", (int)(i + offset));
            Struct after = (Struct)((Struct)record3.value()).get("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)(i + offset));
            Assertions.assertThat((boolean)record3.sourceOffset().containsKey("snapshot")).isFalse();
            Assertions.assertThat((boolean)record3.sourceOffset().containsKey(SNAPSHOT_COMPLETED_KEY)).isFalse();
            Assertions.assertThat((boolean)record3.sourceOffset().containsKey("lcr_position")).isTrue();
            Assertions.assertThat((boolean)record3.sourceOffset().containsKey("scn")).isFalse();
            Struct source = (Struct)((Struct)record3.value()).get("source");
            Assertions.assertThat((Object)source.get("snapshot")).isEqualTo((Object)"false");
            Assertions.assertThat((Object)source.get("scn")).isNotNull();
            Assertions.assertThat((Object)source.get("lcr_position")).isNotNull();
            Assertions.assertThat((Object)source.get("name")).isEqualTo((Object)"server1");
            Assertions.assertThat((Object)source.get("version")).isNotNull();
            Assertions.assertThat((Object)source.get("txId")).isNotNull();
            Assertions.assertThat((Object)source.get("ts_ms")).isNotNull();
        }
    }

    @Test
    public void shouldStreamAfterRestart() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "DEBEZIUM\\.CUSTOMER")).build();
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (2, 'Bruce', 2345.67, null)"});
        connection.execute(new String[]{"COMMIT"});
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount += 2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        expectedRecordCount = 30;
        connection.setAutoCommit(false);
        this.sendTxBatch(expectedRecordCount, 100);
        this.sendTxBatch(expectedRecordCount, 200);
        this.stopConnector();
        int OFFSET = 300;
        for (int i = 300; i < expectedRecordCount + 300; ++i) {
            connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO debezium.customer VALUES (%s, 'Brian%s', 2345.67, null)", i, i)});
        }
        connection.connection().commit();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        this.assertTxBatch(expectedRecordCount, 300);
        this.sendTxBatch(expectedRecordCount, 400);
        this.sendTxBatch(expectedRecordCount, 500);
    }

    @Test
    public void shouldStreamAfterRestartAfterSnapshot() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "DEBEZIUM\\.CUSTOMER")).build();
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (2, 'Bruce', 2345.67, null)"});
        connection.execute(new String[]{"COMMIT"});
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount += 2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        this.stopConnector();
        connection.setAutoCommit(false);
        int OFFSET = 100;
        for (int i = 100; i < expectedRecordCount + 100; ++i) {
            connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO debezium.customer VALUES (%s, 'Brian%s', 2345.67, null)", i, i)});
        }
        connection.connection().commit();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        this.assertTxBatch(expectedRecordCount, 100);
        this.sendTxBatch(expectedRecordCount, 200);
    }

    @Test
    public void shouldReadChangeStreamForExistingTable() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "DEBEZIUM\\.CUSTOMER")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"COMMIT"});
        ++expectedRecordCount;
        connection.execute(new String[]{"UPDATE debezium.customer SET name = 'Bruce', score = 2345.67, registered = TO_DATE('2018/03/23', 'yyyy-mm-dd') WHERE id = 1"});
        connection.execute(new String[]{"COMMIT"});
        ++expectedRecordCount;
        connection.execute(new String[]{"UPDATE debezium.customer SET id = 2 WHERE id = 1"});
        connection.execute(new String[]{"COMMIT"});
        expectedRecordCount += 3;
        connection.execute(new String[]{"DELETE debezium.customer WHERE id = 2"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount += 2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)1);
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
        Map offset = ((SourceRecord)testTableRecords.get(0)).sourceOffset();
        Assertions.assertThat(offset.get("snapshot")).isNull();
        Assertions.assertThat(offset.get(SNAPSHOT_COMPLETED_KEY)).isNull();
        VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)testTableRecords.get(1)), (String)"ID", (int)1);
        Struct before = (Struct)((Struct)((SourceRecord)testTableRecords.get(1)).value()).get("before");
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)before.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)before.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
        after = (Struct)((Struct)((SourceRecord)testTableRecords.get(1)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)testTableRecords.get(2)), (String)"ID", (int)1);
        before = (Struct)((Struct)((SourceRecord)testTableRecords.get(2)).value()).get("before");
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)before.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)before.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)testTableRecords.get(3)));
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(4)), (String)"ID", (int)2);
        after = (Struct)((Struct)((SourceRecord)testTableRecords.get(4)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)testTableRecords.get(5)), (String)"ID", (int)2);
        before = (Struct)((Struct)((SourceRecord)testTableRecords.get(5)).value()).get("before");
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)before.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)before.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)before.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)testTableRecords.get(6)));
    }

    @Test
    @FixFor(value={"DBZ-835"})
    public void deleteWithoutTombstone() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "DEBEZIUM\\.CUSTOMER")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(OracleConnectorConfig.TOMBSTONES_ON_DELETE, false)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"COMMIT"});
        ++expectedRecordCount;
        connection.execute(new String[]{"DELETE debezium.customer WHERE id = 1"});
        connection.execute(new String[]{"COMMIT"});
        ++expectedRecordCount;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (2, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)testTableRecords.get(1)), (String)"ID", (int)1);
        Struct before = ((Struct)((SourceRecord)testTableRecords.get(1)).value()).getStruct("before");
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)before.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)before.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)before.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(2)), (String)"ID", (int)2);
    }

    @Test
    public void shouldReadChangeStreamForTableCreatedWhileStreaming() throws Exception {
        TestHelper.dropTable(connection, "debezium.customer2");
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "DEBEZIUM\\.CUSTOMER2")).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        String ddl = "create table debezium.customer2 (  id numeric(9,0) not null,   name varchar2(1000),   score decimal(6, 2),   registered timestamp,   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.customer2 to c##xstrm"});
        connection.execute(new String[]{"INSERT INTO debezium.customer2 VALUES (2, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER2");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)2);
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
    }

    @Test
    @FixFor(value={"DBZ-800"})
    public void shouldReceiveHeartbeatAlsoWhenChangingNonWhitelistedTable() throws Exception {
        TestHelper.dropTable(connection, "debezium.dbz800a");
        TestHelper.dropTable(connection, "debezium.dbz800b");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(Heartbeat.HEARTBEAT_INTERVAL, "1")).with(OracleConnectorConfig.TABLE_WHITELIST, "DEBEZIUM\\.DBZ800B")).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        connection.execute(new String[]{"CREATE TABLE debezium.dbz800a (id NUMBER(9) NOT NULL, aaa VARCHAR2(100), PRIMARY KEY (id) )"});
        connection.execute(new String[]{"CREATE TABLE debezium.dbz800b (id NUMBER(9) NOT NULL, bbb VARCHAR2(100), PRIMARY KEY (id) )"});
        connection.execute(new String[]{"INSERT INTO debezium.dbz800a VALUES (1, 'AAA')"});
        connection.execute(new String[]{"INSERT INTO debezium.dbz800b VALUES (2, 'BBB')"});
        connection.execute(new String[]{"COMMIT"});
        List records = this.consumeRecordsByTopic(3).allRecordsInOrder();
        this.verifyHeartbeatRecord((SourceRecord)records.get(0));
        this.verifyHeartbeatRecord((SourceRecord)records.get(1));
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)records.get(2)), (String)"ID", (int)2);
    }

    @Test
    @FixFor(value={"DBZ-775"})
    public void shouldConsumeEventsWithMaskedAndTruncatedColumnsWithDatabaseName() throws Exception {
        this.shouldConsumeEventsWithMaskedAndTruncatedColumns(true);
    }

    @Test
    @FixFor(value={"DBZ-775"})
    public void shouldConsumeEventsWithMaskedAndTruncatedColumnsWithoutDatabaseName() throws Exception {
        this.shouldConsumeEventsWithMaskedAndTruncatedColumns(false);
    }

    public void shouldConsumeEventsWithMaskedAndTruncatedColumns(boolean useDatabaseName) throws Exception {
        Configuration config = useDatabaseName ? ((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with("column.mask.with.12.chars", "ORCLPDB1.DEBEZIUM.MASKED_HASHED_COLUMN_TABLE.NAME").with("column.mask.hash.SHA-256.with.salt.CzQMA0cB5K", "ORCLPDB1.DEBEZIUM.MASKED_HASHED_COLUMN_TABLE.NAME2,ORCLPDB1.DEBEZIUM.MASKED_HASHED_COLUMN_TABLE.NAME3").with("column.truncate.to.4.chars", "ORCLPDB1.DEBEZIUM.TRUNCATED_COLUMN_TABLE.NAME").build() : ((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with("column.mask.with.12.chars", "DEBEZIUM.MASKED_HASHED_COLUMN_TABLE.NAME").with("column.mask.hash.SHA-256.with.salt.CzQMA0cB5K", "DEBEZIUM.MASKED_HASHED_COLUMN_TABLE.NAME2,DEBEZIUM.MASKED_HASHED_COLUMN_TABLE.NAME3").with("column.truncate.to.4.chars", "DEBEZIUM.TRUNCATED_COLUMN_TABLE.NAME").build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        connection.execute(new String[]{"INSERT INTO debezium.masked_hashed_column_table (id, name, name2, name3) VALUES (10, 'some_name', 'test', 'test')"});
        connection.execute(new String[]{"INSERT INTO debezium.truncated_column_table VALUES(11, 'some_name')"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        List tableA = records.recordsForTopic("server1.DEBEZIUM.MASKED_HASHED_COLUMN_TABLE");
        List tableB = records.recordsForTopic("server1.DEBEZIUM.TRUNCATED_COLUMN_TABLE");
        Assertions.assertThat((List)tableA).hasSize(1);
        SourceRecord record = (SourceRecord)tableA.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)10);
        Struct value = (Struct)record.value();
        if (value.getStruct("after") != null) {
            Struct after = value.getStruct("after");
            Assertions.assertThat((String)after.getString("NAME")).isEqualTo((Object)"************");
            Assertions.assertThat((String)after.getString("NAME2")).isEqualTo((Object)"8e68c68edbbac316dfe2f6ada6b0d2d3e2002b487a985d4b7c7c82dd83b0f4d7");
            Assertions.assertThat((String)after.getString("NAME3")).isEqualTo((Object)"8e68c68edbbac316dfe2");
        }
        Assertions.assertThat((List)tableB).hasSize(1);
        record = (SourceRecord)tableB.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)11);
        value = (Struct)record.value();
        if (value.getStruct("after") != null) {
            Assertions.assertThat((String)value.getStruct("after").getString("NAME")).isEqualTo((Object)"some");
        }
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-775"})
    public void shouldRewriteIdentityKeyWithDatabaseName() throws Exception {
        this.shouldRewriteIdentityKey(true);
    }

    @Test
    @FixFor(value={"DBZ-775"})
    public void shouldRewriteIdentityKeyWithoutDatabaseName() throws Exception {
        this.shouldRewriteIdentityKey(false);
    }

    private void shouldRewriteIdentityKey(boolean useDatabaseName) throws Exception {
        Configuration config = useDatabaseName ? ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with(OracleConnectorConfig.MSG_KEY_COLUMNS, "(.*).debezium.customer:id,name")).build() : ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with(OracleConnectorConfig.MSG_KEY_COLUMNS, "debezium.customer:id,name")).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (3, 'Nest', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List recordsForTopic = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((Object)((SourceRecord)recordsForTopic.get(0)).key()).isNotNull();
        Struct key = (Struct)((SourceRecord)recordsForTopic.get(0)).key();
        Assertions.assertThat((Object)key.get("ID")).isNotNull();
        Assertions.assertThat((Object)key.get("NAME")).isNotNull();
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1916", "DBZ-1830"})
    public void shouldPropagateSourceTypeByDatatype() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with("datatype.propagate.source.type", ".+\\.NUMBER,.+\\.VARCHAR2,.+\\.FLOAT").build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        connection.execute(new String[]{"INSERT INTO debezium.dt_table (id,c1,c2,c3a,c3b,f1,f2) values (1,123,456,789.01,'test',1.228,234.56)"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List recordsForTopic = records.recordsForTopic("server1.DEBEZIUM.DT_TABLE");
        Assertions.assertThat((List)recordsForTopic).hasSize(1);
        Field before = ((SourceRecord)recordsForTopic.get(0)).valueSchema().field("before");
        Assertions.assertThat((Map)before.schema().field("ID").schema().parameters()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"__debezium.source.column.type", (Object)"NUMBER"), MapAssert.entry((Object)"__debezium.source.column.length", (Object)"9"), MapAssert.entry((Object)"__debezium.source.column.scale", (Object)"0")});
        Assertions.assertThat((Map)before.schema().field("C1").schema().parameters()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"__debezium.source.column.type", (Object)"NUMBER"), MapAssert.entry((Object)"__debezium.source.column.length", (Object)"38"), MapAssert.entry((Object)"__debezium.source.column.scale", (Object)"0")});
        Assertions.assertThat((Map)before.schema().field("C2").schema().parameters()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"__debezium.source.column.type", (Object)"NUMBER"), MapAssert.entry((Object)"__debezium.source.column.length", (Object)"38"), MapAssert.entry((Object)"__debezium.source.column.scale", (Object)"0")});
        Assertions.assertThat((Map)before.schema().field("C3A").schema().parameters()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"__debezium.source.column.type", (Object)"NUMBER"), MapAssert.entry((Object)"__debezium.source.column.length", (Object)"5"), MapAssert.entry((Object)"__debezium.source.column.scale", (Object)"2")});
        Assertions.assertThat((Map)before.schema().field("C3B").schema().parameters()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"__debezium.source.column.type", (Object)"VARCHAR2"), MapAssert.entry((Object)"__debezium.source.column.length", (Object)"128")});
        Assertions.assertThat((Map)before.schema().field("F2").schema().parameters()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"__debezium.source.column.type", (Object)"NUMBER"), MapAssert.entry((Object)"__debezium.source.column.length", (Object)"8"), MapAssert.entry((Object)"__debezium.source.column.scale", (Object)"4")});
        Assertions.assertThat((Map)before.schema().field("F1").schema().parameters()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"__debezium.source.column.type", (Object)"FLOAT"), MapAssert.entry((Object)"__debezium.source.column.length", (Object)"10")});
    }

    private void verifyHeartbeatRecord(SourceRecord heartbeat) {
        TestCase.assertEquals((String)"__debezium-heartbeat.server1", (String)heartbeat.topic());
        Struct key = (Struct)heartbeat.key();
        Assertions.assertThat((Object)key.get("serverName")).isEqualTo((Object)"server1");
    }

    private long toMicroSecondsSinceEpoch(LocalDateTime localDateTime) {
        return localDateTime.toEpochSecond(ZoneOffset.UTC) * MICROS_PER_SECOND;
    }
}

