/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class OracleConnectorFilterIT
extends AbstractConnectorTest {
    private static OracleConnection connection;
    private static OracleConnection adminConnection;

    @BeforeClass
    public static void beforeClass() throws SQLException {
        connection = TestHelper.testConnection();
        adminConnection = TestHelper.adminConnection();
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Before
    public void before() throws SQLException {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        TestHelper.dropTable(connection, "debezium.table1");
        TestHelper.dropTable(connection, "debezium.table2");
        TestHelper.dropTable(connection, "debezium.table3");
        try {
            adminConnection.execute(new String[]{"DROP USER debezium2 CASCADE"});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        adminConnection.execute(new String[]{"CREATE USER debezium2 IDENTIFIED BY dbz", "GRANT CONNECT TO debezium2", "GRANT CREATE SESSION TO debezium2", "GRANT CREATE TABLE TO debezium2", "GRANT CREATE SEQUENCE TO debezium2", "ALTER USER debezium2 QUOTA 100M ON users", "create table debezium2.table2 (id numeric(9,0) not null,name varchar2(1000),primary key (id))", "create table debezium2.nopk (id numeric(9,0) not null)", "GRANT ALL PRIVILEGES ON debezium2.table2 to debezium", "GRANT SELECT ON debezium2.table2 to c##xstrm", "GRANT SELECT ON debezium2.nopk to c##xstrm", "ALTER TABLE debezium2.table2 ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        String ddl = "create table debezium.table1 (  id numeric(9,0) not null,   name varchar2(1000),   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.table1 to c##xstrm"});
        connection.execute(new String[]{"ALTER TABLE debezium.table1 ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        ddl = "create table debezium.table2 (  id numeric(9,0) not null,   name varchar2(1000),   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.table2 to  c##xstrm"});
        connection.execute(new String[]{"ALTER TABLE debezium.table2 ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @Test
    public void shouldApplyWhitelistConfiguration() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "ORCLPDB1\\.DEBEZIUM2\\.TABLE2,ORCLPDB1\\.DEBEZIUM\\.TABLE1,ORCLPDB1\\.DEBEZIUM\\.TABLE3")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorFilterIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        connection.execute(new String[]{"INSERT INTO debezium.table1 VALUES (1, 'Text-1')"});
        connection.execute(new String[]{"INSERT INTO debezium.table2 VALUES (2, 'Text-2')"});
        connection.execute(new String[]{"COMMIT"});
        String ddl = "create table debezium.table3 (  id numeric(9, 0) not null,   name varchar2(1000),   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.table3 to c##xstrm"});
        connection.execute(new String[]{"INSERT INTO debezium.table3 VALUES (3, 'Text-3')"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE1");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)1);
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-1");
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE2");
        Assertions.assertThat((List)testTableRecords).isNull();
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE3");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)3);
        after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-3");
    }

    @Test
    public void shouldApplyBlacklistConfiguration() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_BLACKLIST, "ORCLPDB1\\.DEBEZIUM\\.TABLE2,ORCLPDB1\\.DEBEZIUM\\.CUSTOMER.*")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleConnectorFilterIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        connection.execute(new String[]{"INSERT INTO debezium.table1 VALUES (1, 'Text-1')"});
        connection.execute(new String[]{"INSERT INTO debezium.table2 VALUES (2, 'Text-2')"});
        connection.execute(new String[]{"COMMIT"});
        String ddl = "create table debezium.table3 (  id numeric(9,0) not null,   name varchar2(1000),   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.table3 to  c##xstrm"});
        connection.execute(new String[]{"INSERT INTO debezium.table3 VALUES (3, 'Text-3')"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE1");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)1);
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-1");
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE2");
        Assertions.assertThat((List)testTableRecords).isNull();
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TABLE3");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)), (String)"ID", (int)3);
        after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Text-3");
    }
}

