/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.util;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectionFactory;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHelper.class);
    public static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    public static final String CONNECTOR_USER = "c##xstrm";
    public static final String CONNECTOR_NAME = "oracle";
    public static final String SERVER_NAME = "server1";

    private static JdbcConfiguration defaultJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, CONNECTOR_USER)).withDefault(JdbcConfiguration.PASSWORD, "xs")).withDefault(JdbcConfiguration.DATABASE, "ORCLCDB")).build();
    }

    public static Configuration.Builder defaultConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.defaultJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(RelationalDatabaseConnectorConfig.SERVER_NAME, SERVER_NAME)).with(OracleConnectorConfig.PDB_NAME, "ORCLPDB1")).with(OracleConnectorConfig.XSTREAM_SERVER_NAME, "dbzxout")).with(OracleConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with(RelationalDatabaseConnectorConfig.INCLUDE_SCHEMA_CHANGES, false);
    }

    public static OracleConnection defaultConnection() {
        Configuration config = TestHelper.defaultConfig().build();
        Configuration jdbcConfig = config.subset("database.", true);
        OracleConnection jdbcConnection = new OracleConnection(jdbcConfig, (JdbcConnection.ConnectionFactory)new OracleConnectionFactory());
        String pdbName = new OracleConnectorConfig(config).getPdbName();
        if (pdbName != null) {
            jdbcConnection.setSessionToPdb(pdbName);
        }
        return jdbcConnection;
    }

    private static JdbcConfiguration testJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, "debezium")).withDefault(JdbcConfiguration.PASSWORD, "dbz")).withDefault(JdbcConfiguration.DATABASE, "ORCLPDB1")).build();
    }

    private static JdbcConfiguration adminJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.admin.")).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, "sys as sysdba")).withDefault(JdbcConfiguration.PASSWORD, "top_secret")).withDefault(JdbcConfiguration.DATABASE, "ORCLPDB1")).build();
    }

    private static Configuration.Builder testConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.testJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        return builder;
    }

    private static Configuration.Builder adminConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.adminJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        return builder;
    }

    public static OracleConnection testConnection() {
        Configuration config = TestHelper.testConfig().build();
        Configuration jdbcConfig = config.subset("database.", true);
        OracleConnection jdbcConnection = new OracleConnection(jdbcConfig, (JdbcConnection.ConnectionFactory)new OracleConnectionFactory());
        try {
            jdbcConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        String pdbName = new OracleConnectorConfig(config).getPdbName();
        if (pdbName != null) {
            jdbcConnection.setSessionToPdb(pdbName);
        }
        return jdbcConnection;
    }

    public static OracleConnection adminConnection() {
        Configuration config = TestHelper.adminConfig().build();
        Configuration jdbcConfig = config.subset("database.", true);
        OracleConnection jdbcConnection = new OracleConnection(jdbcConfig, (JdbcConnection.ConnectionFactory)new OracleConnectionFactory());
        try {
            jdbcConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        String pdbName = new OracleConnectorConfig(config).getPdbName();
        if (pdbName != null) {
            jdbcConnection.setSessionToPdb(pdbName);
        }
        return jdbcConnection;
    }

    public static void dropTable(OracleConnection connection, String table) {
        block2: {
            try {
                connection.execute(new String[]{"drop table " + table});
            }
            catch (SQLException e) {
                if (e.getMessage().contains("table or view does not exist")) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    public static int defaultMessageConsumerPollTimeout() {
        return 120;
    }
}

