/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.util.HexConverter;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.streams.StreamsException;
import oracle.streams.XStreamUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LcrPosition
implements Comparable<LcrPosition> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LcrPosition.class);
    private final byte[] rawPosition;
    private final String stringFromat;
    private final long scn;

    public LcrPosition(byte[] rawPosition) {
        this.rawPosition = rawPosition;
        this.stringFromat = HexConverter.convertToHexString((byte[])rawPosition);
        try {
            this.scn = XStreamUtility.getSCNFromPosition((byte[])rawPosition).longValue();
        }
        catch (SQLException | StreamsException e) {
            throw new RuntimeException(e);
        }
        LOGGER.trace("LCR position {} converted to SCN {}", new Object[]{rawPosition, this.stringFromat, this.scn});
    }

    public static LcrPosition valueOf(String rawPosition) {
        if (rawPosition == null) {
            return null;
        }
        return new LcrPosition(Strings.hexStringToByteArray((String)rawPosition));
    }

    byte[] getRawPosition() {
        return this.rawPosition;
    }

    public long getScn() {
        return this.scn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.rawPosition);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LcrPosition other = (LcrPosition)obj;
        return Arrays.equals(this.rawPosition, other.rawPosition);
    }

    public String toString() {
        return this.stringFromat;
    }

    @Override
    public int compareTo(LcrPosition o) {
        if (o == null) {
            return 1;
        }
        int lenDiff = this.rawPosition.length - o.rawPosition.length;
        if (lenDiff != 0) {
            return lenDiff;
        }
        for (int i = 0; i < this.rawPosition.length; ++i) {
            int diff = (this.rawPosition[i] & 0xFF) - (o.rawPosition[i] & 0xFF);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }
}

