/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.AbstractOracleDatatypesTest;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public class SnapshotDatatypesIT
extends AbstractOracleDatatypesTest {
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws SQLException {
        SnapshotDatatypesIT.createTables();
        SnapshotDatatypesIT.insertStringTypes();
        SnapshotDatatypesIT.insertFpTypes();
        SnapshotDatatypesIT.insertIntTypes();
        SnapshotDatatypesIT.insertTimeTypes();
    }

    @Before
    public void before() throws Exception {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Debug.enable();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Configuration config = this.connectorConfig().build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        Thread.sleep(2000L);
    }

    @Override
    protected Configuration.Builder connectorConfig() {
        return (Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_WHITELIST, this.getTableWhitelist());
    }

    private String getTableWhitelist() {
        switch (this.name.getMethodName()) {
            case "stringTypes": {
                return "ORCLPDB1.debezium.type_string";
            }
            case "fpTypes": 
            case "fpTypesAsString": 
            case "fpTypesAsDouble": {
                return "ORCLPDB1.debezium.type_fp";
            }
            case "intTypes": {
                return "ORCLPDB1.debezium.type_int";
            }
            case "timeTypes": {
                return "ORCLPDB1.debezium.type_time";
            }
        }
        throw new IllegalArgumentException("Unexpected test method: " + this.name.getMethodName());
    }

    @Override
    protected boolean insertRecordsDuringTest() {
        return false;
    }
}

