/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.SchemaAndValueField;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.time.MicroDuration;
import io.debezium.time.MicroTimestamp;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractOracleDatatypesTest
extends AbstractConnectorTest {
    static final String PRECISION_PARAMETER_KEY = "connect.decimal.precision";
    private static final Schema NUMBER_SCHEMA = Decimal.builder((int)0).optional().parameter("connect.decimal.precision", "38").build();
    private static final String DDL_STRING = "create table debezium.type_string (  id numeric(9,0) not null,   val_varchar varchar(1000),   val_varchar2 varchar2(1000),   val_nvarchar2 nvarchar2(1000),   val_char char(3),   val_nchar nchar(3),   primary key (id))";
    private static final String DDL_FP = "create table debezium.type_fp (  id numeric(9,0) not null,   val_bf binary_float,   val_bd binary_double,   val_f float,   val_f_10 float (10),   val_num number(10,6),   val_dp double precision,   val_r real,   val_decimal decimal(10, 6),   val_numeric numeric(10, 6),   val_num_vs number,   primary key (id))";
    private static final String DDL_INT = "create table debezium.type_int (  id numeric(9,0) not null,   val_int int,   val_integer integer,   val_smallint smallint,   val_number_38_no_scale number(38),   val_number_38_scale_0 number(38, 0),   val_number_2 number(2),   val_number_4 number(4),   val_number_9 number(9),   val_number_18 number(18),   val_number_2_negative_scale number(1, -1),   val_number_4_negative_scale number(2, -2),   val_number_9_negative_scale number(8, -1),   val_number_18_negative_scale number(16, -2),   val_decimal decimal(10),   val_numeric numeric(10),   primary key (id))";
    private static final String DDL_TIME = "create table debezium.type_time (  id numeric(9,0) not null,   val_date date,   val_ts timestamp,   val_ts_precision2 timestamp(2),   val_ts_precision4 timestamp(4),   val_tstz timestamp with time zone,   val_tsltz timestamp with local time zone,   val_int_ytm interval year to month,   val_int_dts interval day(3) to second(2),   primary key (id))";
    private static final List<SchemaAndValueField> EXPECTED_STRING = Arrays.asList(new SchemaAndValueField("VAL_VARCHAR", Schema.OPTIONAL_STRING_SCHEMA, (Object)"v\u010d2"), new SchemaAndValueField("VAL_VARCHAR2", Schema.OPTIONAL_STRING_SCHEMA, (Object)"v\u010d2"), new SchemaAndValueField("VAL_NVARCHAR2", Schema.OPTIONAL_STRING_SCHEMA, (Object)"nv\u010d2"), new SchemaAndValueField("VAL_CHAR", Schema.OPTIONAL_STRING_SCHEMA, (Object)"c  "), new SchemaAndValueField("VAL_NCHAR", Schema.OPTIONAL_STRING_SCHEMA, (Object)"n\u010d "));
    private static final List<SchemaAndValueField> EXPECTED_FP = Arrays.asList(new SchemaAndValueField("VAL_BF", Schema.OPTIONAL_FLOAT32_SCHEMA, (Object)Float.valueOf(1.1f)), new SchemaAndValueField("VAL_BD", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)2.22), new SchemaAndValueField("VAL_F", VariableScaleDecimal.builder().optional().build(), (Object)VariableScaleDecimal.fromLogical((Schema)VariableScaleDecimal.builder().optional().build(), (BigDecimal)new BigDecimal("3.33"))), new SchemaAndValueField("VAL_F_10", VariableScaleDecimal.builder().optional().build(), (Object)VariableScaleDecimal.fromLogical((Schema)VariableScaleDecimal.builder().optional().build(), (BigDecimal)new BigDecimal("8.888"))), new SchemaAndValueField("VAL_NUM", Decimal.builder((int)6).parameter("connect.decimal.precision", "10").optional().build(), (Object)new BigDecimal("4.444400")), new SchemaAndValueField("VAL_DP", VariableScaleDecimal.builder().optional().build(), (Object)VariableScaleDecimal.fromLogical((Schema)VariableScaleDecimal.builder().optional().build(), (BigDecimal)new BigDecimal("5.555"))), new SchemaAndValueField("VAL_R", VariableScaleDecimal.builder().optional().build(), (Object)VariableScaleDecimal.fromLogical((Schema)VariableScaleDecimal.builder().optional().build(), (BigDecimal)new BigDecimal("6.66"))), new SchemaAndValueField("VAL_DECIMAL", Decimal.builder((int)6).parameter("connect.decimal.precision", "10").optional().build(), (Object)new BigDecimal("1234.567891")), new SchemaAndValueField("VAL_NUMERIC", Decimal.builder((int)6).parameter("connect.decimal.precision", "10").optional().build(), (Object)new BigDecimal("1234.567891")), new SchemaAndValueField("VAL_NUM_VS", VariableScaleDecimal.builder().optional().build(), (Object)VariableScaleDecimal.fromLogical((Schema)VariableScaleDecimal.builder().optional().build(), (BigDecimal)new BigDecimal("77.323"))));
    private static final List<SchemaAndValueField> EXPECTED_FP_AS_STRING = Arrays.asList(new SchemaAndValueField("VAL_BF", Schema.OPTIONAL_FLOAT32_SCHEMA, (Object)Float.valueOf(1.1f)), new SchemaAndValueField("VAL_BD", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)2.22), new SchemaAndValueField("VAL_F", Schema.OPTIONAL_STRING_SCHEMA, (Object)"3.33"), new SchemaAndValueField("VAL_F_10", Schema.OPTIONAL_STRING_SCHEMA, (Object)"8.888"), new SchemaAndValueField("VAL_NUM", Schema.OPTIONAL_STRING_SCHEMA, (Object)"4.444400"), new SchemaAndValueField("VAL_DP", Schema.OPTIONAL_STRING_SCHEMA, (Object)"5.555"), new SchemaAndValueField("VAL_R", Schema.OPTIONAL_STRING_SCHEMA, (Object)"6.66"), new SchemaAndValueField("VAL_DECIMAL", Schema.OPTIONAL_STRING_SCHEMA, (Object)"1234.567891"), new SchemaAndValueField("VAL_NUMERIC", Schema.OPTIONAL_STRING_SCHEMA, (Object)"1234.567891"), new SchemaAndValueField("VAL_NUM_VS", Schema.OPTIONAL_STRING_SCHEMA, (Object)"77.323"));
    private static final List<SchemaAndValueField> EXPECTED_FP_AS_DOUBLE = Arrays.asList(new SchemaAndValueField("VAL_BF", Schema.OPTIONAL_FLOAT32_SCHEMA, (Object)Float.valueOf(1.1f)), new SchemaAndValueField("VAL_BD", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)2.22), new SchemaAndValueField("VAL_F", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)3.33), new SchemaAndValueField("VAL_F_10", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)8.888), new SchemaAndValueField("VAL_NUM", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)4.4444), new SchemaAndValueField("VAL_DP", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)5.555), new SchemaAndValueField("VAL_R", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)6.66), new SchemaAndValueField("VAL_DECIMAL", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)1234.567891), new SchemaAndValueField("VAL_NUMERIC", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)1234.567891), new SchemaAndValueField("VAL_NUM_VS", Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)77.323));
    private static final List<SchemaAndValueField> EXPECTED_INT = Arrays.asList(new SchemaAndValueField("VAL_INT", NUMBER_SCHEMA, (Object)new BigDecimal("1")), new SchemaAndValueField("VAL_INTEGER", NUMBER_SCHEMA, (Object)new BigDecimal("22")), new SchemaAndValueField("VAL_SMALLINT", NUMBER_SCHEMA, (Object)new BigDecimal("333")), new SchemaAndValueField("VAL_NUMBER_38_NO_SCALE", NUMBER_SCHEMA, (Object)new BigDecimal("4444")), new SchemaAndValueField("VAL_NUMBER_38_SCALE_0", NUMBER_SCHEMA, (Object)new BigDecimal("5555")), new SchemaAndValueField("VAL_NUMBER_2", Schema.OPTIONAL_INT8_SCHEMA, (Object)99), new SchemaAndValueField("VAL_NUMBER_4", Schema.OPTIONAL_INT16_SCHEMA, (Object)9999), new SchemaAndValueField("VAL_NUMBER_9", Schema.OPTIONAL_INT32_SCHEMA, (Object)999999999), new SchemaAndValueField("VAL_NUMBER_18", Schema.OPTIONAL_INT64_SCHEMA, (Object)999999999999999999L), new SchemaAndValueField("VAL_NUMBER_2_NEGATIVE_SCALE", Schema.OPTIONAL_INT8_SCHEMA, (Object)90), new SchemaAndValueField("VAL_NUMBER_4_NEGATIVE_SCALE", Schema.OPTIONAL_INT16_SCHEMA, (Object)9900), new SchemaAndValueField("VAL_NUMBER_9_NEGATIVE_SCALE", Schema.OPTIONAL_INT32_SCHEMA, (Object)999999990), new SchemaAndValueField("VAL_NUMBER_18_NEGATIVE_SCALE", Schema.OPTIONAL_INT64_SCHEMA, (Object)999999999999999900L), new SchemaAndValueField("VAL_DECIMAL", Schema.OPTIONAL_INT64_SCHEMA, (Object)9999999999L), new SchemaAndValueField("VAL_NUMERIC", Schema.OPTIONAL_INT64_SCHEMA, (Object)9999999999L));
    private static final List<SchemaAndValueField> EXPECTED_TIME = Arrays.asList(new SchemaAndValueField("VAL_DATE", Timestamp.builder().optional().build(), (Object)1522108800000L), new SchemaAndValueField("VAL_TS", MicroTimestamp.builder().optional().build(), (Object)(LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 7890L)), new SchemaAndValueField("VAL_TS_PRECISION2", Timestamp.builder().optional().build(), (Object)(LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000L + 130L)), new SchemaAndValueField("VAL_TS_PRECISION4", MicroTimestamp.builder().optional().build(), (Object)(LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 125500L)), new SchemaAndValueField("VAL_TSTZ", ZonedTimestamp.builder().optional().build(), (Object)"2018-03-27T01:34:56.00789-11:00"), new SchemaAndValueField("VAL_INT_YTM", MicroDuration.builder().optional().build(), (Object)-110451600000000L), new SchemaAndValueField("VAL_INT_DTS", MicroDuration.builder().optional().build(), (Object)-93784560000L));
    private static final String[] ALL_TABLES = new String[]{"debezium.type_string", "debezium.type_fp", "debezium.type_int", "debezium.type_time"};
    private static final String[] ALL_DDLS = new String[]{"create table debezium.type_string (  id numeric(9,0) not null,   val_varchar varchar(1000),   val_varchar2 varchar2(1000),   val_nvarchar2 nvarchar2(1000),   val_char char(3),   val_nchar nchar(3),   primary key (id))", "create table debezium.type_fp (  id numeric(9,0) not null,   val_bf binary_float,   val_bd binary_double,   val_f float,   val_f_10 float (10),   val_num number(10,6),   val_dp double precision,   val_r real,   val_decimal decimal(10, 6),   val_numeric numeric(10, 6),   val_num_vs number,   primary key (id))", "create table debezium.type_int (  id numeric(9,0) not null,   val_int int,   val_integer integer,   val_smallint smallint,   val_number_38_no_scale number(38),   val_number_38_scale_0 number(38, 0),   val_number_2 number(2),   val_number_4 number(4),   val_number_9 number(9),   val_number_18 number(18),   val_number_2_negative_scale number(1, -1),   val_number_4_negative_scale number(2, -2),   val_number_9_negative_scale number(8, -1),   val_number_18_negative_scale number(16, -2),   val_decimal decimal(10),   val_numeric numeric(10),   primary key (id))", "create table debezium.type_time (  id numeric(9,0) not null,   val_date date,   val_ts timestamp,   val_ts_precision2 timestamp(2),   val_ts_precision4 timestamp(4),   val_tstz timestamp with time zone,   val_tsltz timestamp with local time zone,   val_int_ytm interval year to month,   val_int_dts interval day(3) to second(2),   primary key (id))"};
    private static OracleConnection connection;

    @BeforeClass
    public static void dropTables() throws SQLException {
        connection = TestHelper.testConnection();
        for (String table : ALL_TABLES) {
            TestHelper.dropTable(connection, table);
        }
    }

    protected static void createTables() throws SQLException {
        connection.execute(ALL_DDLS);
        for (String table : ALL_TABLES) {
            AbstractOracleDatatypesTest.streamTable(table);
        }
    }

    protected List<String> getAllTables() {
        return Arrays.asList(ALL_TABLES);
    }

    protected abstract boolean insertRecordsDuringTest();

    protected abstract Configuration.Builder connectorConfig();

    private static void streamTable(String table) throws SQLException {
        connection.execute(new String[]{"GRANT SELECT ON " + table + " to " + "c##xstrm"});
        connection.execute(new String[]{"ALTER TABLE " + table + " ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Test
    public void stringTypes() throws Exception {
        int expectedRecordCount = 0;
        if (this.insertRecordsDuringTest()) {
            AbstractOracleDatatypesTest.insertStringTypes();
        }
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TYPE_STRING");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValid((SourceRecord)record);
        if (this.insertRecordsDuringTest()) {
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        } else {
            VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
        }
        Struct after = (Struct)((Struct)record.value()).get("after");
        this.assertRecord(after, EXPECTED_STRING);
    }

    @Test
    public void fpTypes() throws Exception {
        int expectedRecordCount = 0;
        if (this.insertRecordsDuringTest()) {
            AbstractOracleDatatypesTest.insertFpTypes();
        }
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TYPE_FP");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValid((SourceRecord)record);
        if (this.insertRecordsDuringTest()) {
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        } else {
            VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
        }
        Struct after = (Struct)((Struct)record.value()).get("after");
        this.assertRecord(after, EXPECTED_FP);
    }

    @Test
    @FixFor(value={"DBZ-1552"})
    public void fpTypesAsString() throws Exception {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        Configuration config = ((Configuration.Builder)this.connectorConfig().with(OracleConnectorConfig.DECIMAL_HANDLING_MODE, (Object)JdbcValueConverters.DecimalMode.STRING)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        Thread.sleep(2000L);
        int expectedRecordCount = 0;
        if (this.insertRecordsDuringTest()) {
            AbstractOracleDatatypesTest.insertFpTypes();
        }
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TYPE_FP");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValid((SourceRecord)record);
        if (this.insertRecordsDuringTest()) {
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        } else {
            VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
        }
        Struct after = (Struct)((Struct)record.value()).get("after");
        this.assertRecord(after, EXPECTED_FP_AS_STRING);
    }

    @Test
    @FixFor(value={"DBZ-1552"})
    public void fpTypesAsDouble() throws Exception {
        this.stopConnector();
        this.initializeConnectorTestFramework();
        Configuration config = ((Configuration.Builder)this.connectorConfig().with(OracleConnectorConfig.DECIMAL_HANDLING_MODE, (Object)JdbcValueConverters.DecimalMode.DOUBLE)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        Thread.sleep(2000L);
        int expectedRecordCount = 0;
        if (this.insertRecordsDuringTest()) {
            AbstractOracleDatatypesTest.insertFpTypes();
        }
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TYPE_FP");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValid((SourceRecord)record);
        if (this.insertRecordsDuringTest()) {
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        } else {
            VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
        }
        Struct after = (Struct)((Struct)record.value()).get("after");
        this.assertRecord(after, EXPECTED_FP_AS_DOUBLE);
    }

    @Test
    public void intTypes() throws Exception {
        int expectedRecordCount = 0;
        if (this.insertRecordsDuringTest()) {
            AbstractOracleDatatypesTest.insertIntTypes();
        }
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TYPE_INT");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValid((SourceRecord)record);
        if (this.insertRecordsDuringTest()) {
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        } else {
            VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
        }
        Struct after = (Struct)((Struct)record.value()).get("after");
        this.assertRecord(after, EXPECTED_INT);
    }

    @Test
    public void timeTypes() throws Exception {
        int expectedRecordCount = 0;
        if (this.insertRecordsDuringTest()) {
            AbstractOracleDatatypesTest.insertTimeTypes();
        }
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TYPE_TIME");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValid((SourceRecord)record);
        if (this.insertRecordsDuringTest()) {
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
        } else {
            VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
        }
        Struct after = (Struct)((Struct)record.value()).get("after");
        this.assertRecord(after, EXPECTED_TIME);
    }

    protected static void insertStringTypes() throws SQLException {
        connection.execute(new String[]{"INSERT INTO debezium.type_string VALUES (1, 'v\u010d2', 'v\u010d2', 'nv\u010d2', 'c', 'n\u010d')"});
        connection.execute(new String[]{"COMMIT"});
    }

    protected static void insertFpTypes() throws SQLException {
        connection.execute(new String[]{"INSERT INTO debezium.type_fp VALUES (1, 1.1, 2.22, 3.33, 8.888, 4.4444, 5.555, 6.66, 1234.567891, 1234.567891, 77.323)"});
        connection.execute(new String[]{"COMMIT"});
    }

    protected static void insertIntTypes() throws SQLException {
        connection.execute(new String[]{"INSERT INTO debezium.type_int VALUES (1, 1, 22, 333, 4444, 5555, 99, 9999, 999999999, 999999999999999999, 94, 9949, 999999994, 999999999999999949, 9999999999, 9999999999)"});
        connection.execute(new String[]{"COMMIT"});
    }

    protected static void insertTimeTypes() throws SQLException {
        connection.execute(new String[]{"INSERT INTO debezium.type_time VALUES (1, TO_DATE('27-MAR-2018', 'dd-MON-yyyy'), TO_TIMESTAMP('27-MAR-2018 12:34:56.00789', 'dd-MON-yyyy HH24:MI:SS.FF5'), TO_TIMESTAMP('27-MAR-2018 12:34:56.12545', 'dd-MON-yyyy HH24:MI:SS.FF5'), TO_TIMESTAMP('27-MAR-2018 12:34:56.12545', 'dd-MON-yyyy HH24:MI:SS.FF5'), TO_TIMESTAMP_TZ('27-MAR-2018 01:34:56.00789 -11:00', 'dd-MON-yyyy HH24:MI:SS.FF5 TZH:TZM'), TO_TIMESTAMP_TZ('27-MAR-2018 01:34:56.00789', 'dd-MON-yyyy HH24:MI:SS.FF5'), INTERVAL '-3-6' YEAR TO MONTH, INTERVAL '-1 2:3:4.56' DAY TO SECOND)"});
        connection.execute(new String[]{"COMMIT"});
    }

    private void assertRecord(Struct record, List<SchemaAndValueField> expected) {
        expected.forEach(schemaAndValueField -> schemaAndValueField.assertFor(record));
    }
}

