/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.relational.history.TableChanges;
import java.util.Map;

public class HistoryRecord {
    private final Document doc;

    public HistoryRecord(Document document) {
        this.doc = document;
    }

    public HistoryRecord(Map<String, ?> source, Map<String, ?> position, String databaseName, String schemaName, String ddl, TableChanges changes) {
        this.doc = Document.create();
        Document src = this.doc.setDocument("source");
        if (source != null) {
            source.forEach(src::set);
        }
        Document pos = this.doc.setDocument("position");
        if (position != null) {
            for (Map.Entry<String, ?> positionElement : position.entrySet()) {
                if (positionElement.getValue() instanceof byte[]) {
                    pos.setBinary(positionElement.getKey(), (byte[])positionElement.getValue());
                    continue;
                }
                pos.set(positionElement.getKey(), positionElement.getValue());
            }
        }
        if (databaseName != null) {
            this.doc.setString("databaseName", databaseName);
        }
        if (schemaName != null) {
            this.doc.setString("schemaName", schemaName);
        }
        if (ddl != null) {
            this.doc.setString("ddl", ddl);
        }
        if (changes != null) {
            this.doc.setArray((CharSequence)"tableChanges", changes.toArray());
        }
    }

    public Document document() {
        return this.doc;
    }

    protected Document source() {
        return this.doc.getDocument("source");
    }

    protected Document position() {
        return this.doc.getDocument("position");
    }

    protected String databaseName() {
        return this.doc.getString("databaseName");
    }

    protected String schemaName() {
        return this.doc.getString("schemaName");
    }

    protected String ddl() {
        return this.doc.getString("ddl");
    }

    protected Array tableChanges() {
        return this.doc.getArray("tableChanges");
    }

    public String toString() {
        return this.doc.toString();
    }

    public boolean isValid() {
        return this.source() != null && this.position() != null;
    }

    public static final class Fields {
        public static final String SOURCE = "source";
        public static final String POSITION = "position";
        public static final String DATABASE_NAME = "databaseName";
        public static final String SCHEMA_NAME = "schemaName";
        public static final String DDL_STATEMENTS = "ddl";
        public static final String TABLE_CHANGES = "tableChanges";
    }
}

