/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.serde.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.debezium.annotation.Incubating;
import io.debezium.serde.json.JsonSerdeConfig;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

@Incubating
public class JsonSerde<T>
implements Serde<T> {
    private static final String PAYLOAD_FIELD = "payload";
    private final ObjectMapper mapper = new ObjectMapper();
    private final ObjectReader reader;
    private boolean isKey;
    private JsonSerdeConfig config;

    public JsonSerde(Class<T> objectType) {
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.reader = this.mapper.readerFor(objectType);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.config = new JsonSerdeConfig(configs);
    }

    public void close() {
    }

    public Serializer<T> serializer() {
        return new JsonSerializer();
    }

    public Deserializer<T> deserializer() {
        return new JsonDeserializer();
    }

    private final class JsonSerializer
    implements Serializer<T> {
        private JsonSerializer() {
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public byte[] serialize(String topic, T data) {
            try {
                return JsonSerde.this.mapper.writeValueAsBytes(data);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
        }
    }

    private final class JsonDeserializer
    implements Deserializer<T> {
        private JsonDeserializer() {
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public T deserialize(String topic, byte[] data) {
            if (data == null) {
                return null;
            }
            try {
                JsonNode node = JsonSerde.this.mapper.readTree(data);
                return JsonSerde.this.isKey ? this.readKey(node) : this.readValue(node);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private T readValue(JsonNode node) throws IOException {
            JsonNode payload = node.get(JsonSerde.PAYLOAD_FIELD);
            if (payload != null) {
                node = payload;
            }
            if (JsonSerde.this.config.asEnvelope()) {
                return JsonSerde.this.reader.readValue(node);
            }
            if (node.has("source") && node.has(JsonSerde.this.config.sourceField())) {
                return JsonSerde.this.reader.readValue(node.get(JsonSerde.this.config.sourceField()));
            }
            return JsonSerde.this.reader.readValue(node);
        }

        private T readKey(JsonNode node) throws IOException {
            if (!node.isObject()) {
                return JsonSerde.this.reader.readValue(node);
            }
            JsonNode keys = node.has(JsonSerde.PAYLOAD_FIELD) ? node.get(JsonSerde.PAYLOAD_FIELD) : node;
            Iterator keyFields = keys.fieldNames();
            if (keyFields.hasNext()) {
                String id = (String)keyFields.next();
                if (!keyFields.hasNext()) {
                    return JsonSerde.this.reader.readValue(keys.get(id));
                }
                return JsonSerde.this.reader.readValue(keys);
            }
            return JsonSerde.this.reader.readValue(keys);
        }

        public void close() {
        }
    }
}

