/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.LcrEventHandler;
import io.debezium.connector.oracle.LcrPosition;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.sql.NUMBER;
import oracle.streams.StreamsException;
import oracle.streams.XStreamLCRCallbackHandler;
import oracle.streams.XStreamOut;
import oracle.streams.XStreamUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleStreamingChangeEventSource
implements StreamingChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleStreamingChangeEventSource.class);
    private final JdbcConnection jdbcConnection;
    private final EventDispatcher<TableId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final OracleOffsetContext offsetContext;
    private final String xStreamServerName;
    private volatile XStreamOut xsOut;
    private final boolean tablenameCaseInsensitive;
    private final int posVersion;

    public OracleStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleOffsetContext offsetContext, JdbcConnection jdbcConnection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema) {
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext;
        this.xStreamServerName = connectorConfig.getXoutServerName();
        this.tablenameCaseInsensitive = connectorConfig.getTablenameCaseInsensitive();
        this.posVersion = connectorConfig.getOracleVersion().getPosVersion();
    }

    public void execute(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        try {
            byte[] startPosition = this.offsetContext.getLcrPosition() != null ? this.offsetContext.getLcrPosition().getRawPosition() : this.convertScnToPosition(this.offsetContext.getScn());
            this.xsOut = XStreamOut.attach((OracleConnection)((OracleConnection)this.jdbcConnection.connection()), (String)this.xStreamServerName, (byte[])startPosition, (int)1, (int)1, (int)0);
            LcrEventHandler handler = new LcrEventHandler(this.errorHandler, this.dispatcher, this.clock, (RelationalDatabaseSchema)this.schema, this.offsetContext, this.tablenameCaseInsensitive);
            while (context.isRunning()) {
                LOGGER.trace("Receiving LCR");
                this.xsOut.receiveLCRCallback((XStreamLCRCallbackHandler)handler, 0);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.xsOut != null) {
                try {
                    XStreamOut xsOut = this.xsOut;
                    this.xsOut = null;
                    xsOut.detach(0);
                }
                catch (StreamsException e) {
                    LOGGER.error("Couldn't detach from XStream outbound server " + this.xStreamServerName, (Throwable)e);
                }
            }
        }
    }

    public void commitOffset(Map<String, ?> offset) {
        if (this.xsOut != null) {
            try {
                LOGGER.debug("Recording offsets to Oracle");
                LcrPosition lcrPosition = LcrPosition.valueOf((String)offset.get("lcr_position"));
                Long scn = (Long)offset.get("scn");
                if (lcrPosition != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Recording position {}", (Object)lcrPosition);
                    }
                    this.xsOut.setProcessedLowWatermark(lcrPosition.getRawPosition(), 0);
                } else if (scn != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Recording position with SCN {}", (Object)scn);
                    }
                    this.xsOut.setProcessedLowWatermark(this.convertScnToPosition(scn), 0);
                } else {
                    LOGGER.warn("Nothing in offsets could be recorded to Oracle");
                    return;
                }
                LOGGER.trace("Offsets recorded to Oracle");
            }
            catch (StreamsException e) {
                throw new RuntimeException("Couldn't set processed low watermark", e);
            }
        }
    }

    private byte[] convertScnToPosition(long scn) {
        try {
            return XStreamUtility.convertSCNToPosition((NUMBER)new NUMBER(scn), (int)this.posVersion);
        }
        catch (StreamsException e) {
            throw new RuntimeException(e);
        }
    }
}

