/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistoryException;
import io.debezium.relational.history.DatabaseHistoryListener;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.TableChanges;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public interface DatabaseHistory {
    public static final String CONFIGURATION_FIELD_PREFIX_STRING = "database.history.";
    public static final Field NAME = Field.create("database.history.name").withDisplayName("Logical name for the database history").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("The name used for the database history, perhaps differently by each implementation.").withValidation(Field::isOptional);
    public static final Field SKIP_UNPARSEABLE_DDL_STATEMENTS = Field.create("database.history.skip.unparseable.ddl").withDisplayName("Skip DDL statements that cannot be parsed").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls the action Debezium will take when it meets a DDL statement in binlog, that it cannot parse.By default the connector will stop operating but by changing the setting it can ignore the statements which it cannot parse. If skipping is enabled then Debezium can miss metadata changes.").withDefault(false);
    public static final Field STORE_ONLY_MONITORED_TABLES_DDL = Field.create("database.history.store.only.monitored.tables.ddl").withDisplayName("Store only DDL that modifies whitelisted/not-blacklisted tables").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls what DDL will Debezium store in database history.By default (false) Debezium will store all incoming DDL statements. If set to truethen only DDL that manipulates a monitored table will be stored.").withDefault(false);
    public static final Field DDL_FILTER = Field.createInternal("database.history.ddl.filter").withDisplayName("DDL filter").withType(ConfigDef.Type.STRING).withDefault("DROP TEMPORARY TABLE IF EXISTS .+ /\\* generated by server \\*/,INSERT INTO mysql.rds_heartbeat2\\(.*\\) values \\(.*\\) ON DUPLICATE KEY UPDATE value = .*,DELETE FROM mysql.rds_sysinfo.*,INSERT INTO mysql.rds_sysinfo\\(.*\\) values \\(.*\\),FLUSH RELAY LOGS.*,flush relay logs.*,SAVEPOINT .*").withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("A regular expression to filter out a subset of incoming DDL statements from processing and storing into schema history evolution.").withValidation(Field::isListOfRegex);

    public void configure(Configuration var1, HistoryRecordComparator var2, DatabaseHistoryListener var3);

    public void start();

    public void record(Map<String, ?> var1, Map<String, ?> var2, String var3, String var4) throws DatabaseHistoryException;

    public void record(Map<String, ?> var1, Map<String, ?> var2, String var3, String var4, String var5, TableChanges var6) throws DatabaseHistoryException;

    public void recover(Map<String, ?> var1, Map<String, ?> var2, Tables var3, DdlParser var4);

    public void stop();

    public boolean exists();

    public void initializeStorage();
}

