/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.data.Envelope;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.spi.ChangeEventCreator;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.HistorizedDatabaseSchema;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcher<T extends DataCollectionId> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDispatcher.class);
    private final TopicSelector<T> topicSelector;
    private final DatabaseSchema<T> schema;
    private final HistorizedDatabaseSchema<T> historizedSchema;
    private final ChangeEventQueue<DataChangeEvent> queue;
    private final DataCollectionFilters.DataCollectionFilter<T> filter;
    private final ChangeEventCreator changeEventCreator;
    private final Heartbeat heartbeat;
    private DataChangeEventListener eventListener = DataChangeEventListener.NO_OP;
    private final boolean emitTombstonesOnDelete;
    private final InconsistentSchemaHandler<T> inconsistentSchemaHandler;
    private final StreamingChangeRecordReceiver streamingReceiver;

    public EventDispatcher(CommonConnectorConfig connectorConfig, TopicSelector<T> topicSelector, DatabaseSchema<T> schema, ChangeEventQueue<DataChangeEvent> queue, DataCollectionFilters.DataCollectionFilter<T> filter, ChangeEventCreator changeEventCreator) {
        this(connectorConfig, topicSelector, schema, queue, filter, changeEventCreator, null);
    }

    public EventDispatcher(CommonConnectorConfig connectorConfig, TopicSelector<T> topicSelector, DatabaseSchema<T> schema, ChangeEventQueue<DataChangeEvent> queue, DataCollectionFilters.DataCollectionFilter<T> filter, ChangeEventCreator changeEventCreator, InconsistentSchemaHandler<T> inconsistentSchemaHandler) {
        this.topicSelector = topicSelector;
        this.schema = schema;
        this.historizedSchema = schema instanceof HistorizedDatabaseSchema ? (HistorizedDatabaseSchema)schema : null;
        this.queue = queue;
        this.filter = filter;
        this.changeEventCreator = changeEventCreator;
        this.streamingReceiver = new StreamingChangeRecordReceiver();
        this.emitTombstonesOnDelete = connectorConfig.isEmitTombstoneOnDelete();
        this.inconsistentSchemaHandler = inconsistentSchemaHandler != null ? inconsistentSchemaHandler : this::errorOnMissingSchema;
        this.heartbeat = Heartbeat.create(connectorConfig.getConfig(), topicSelector.getHeartbeatTopic(), connectorConfig.getLogicalName());
    }

    public void dispatchSnapshotEvent(T dataCollectionId, ChangeRecordEmitter changeRecordEmitter, final SnapshotReceiver receiver) throws InterruptedException {
        final DataCollectionSchema dataCollectionSchema = this.schema.schemaFor(dataCollectionId);
        if (dataCollectionSchema == null) {
            this.errorOnMissingSchema(dataCollectionId, changeRecordEmitter);
        }
        changeRecordEmitter.emitChangeRecords(dataCollectionSchema, new ChangeRecordEmitter.Receiver(){

            @Override
            public void changeRecord(DataCollectionSchema schema, Envelope.Operation operation, Object key, Struct value, OffsetContext offset) throws InterruptedException {
                EventDispatcher.this.eventListener.onEvent(dataCollectionSchema.id(), offset, key, value);
                receiver.changeRecord(dataCollectionSchema, operation, key, value, offset);
            }
        });
    }

    public SnapshotReceiver getSnapshotChangeEventReceiver() {
        return new BufferingSnapshotChangeRecordReceiver();
    }

    public boolean dispatchDataChangeEvent(T dataCollectionId, ChangeRecordEmitter changeRecordEmitter) throws InterruptedException {
        if (!this.filter.isIncluded(dataCollectionId)) {
            LOGGER.trace("Filtered data change event for {}", dataCollectionId);
            this.eventListener.onFilteredEvent("source = " + dataCollectionId);
            return false;
        }
        DataCollectionSchema dataCollectionSchema = this.schema.schemaFor(dataCollectionId);
        if (dataCollectionSchema == null) {
            Optional<DataCollectionSchema> replacementSchema = this.inconsistentSchemaHandler.handle(dataCollectionId, changeRecordEmitter);
            if (!replacementSchema.isPresent()) {
                return false;
            }
            dataCollectionSchema = replacementSchema.get();
        }
        changeRecordEmitter.emitChangeRecords(dataCollectionSchema, new ChangeRecordEmitter.Receiver((DataCollectionId)dataCollectionId){
            final /* synthetic */ DataCollectionId val$dataCollectionId;
            {
                this.val$dataCollectionId = dataCollectionId;
            }

            @Override
            public void changeRecord(DataCollectionSchema schema, Envelope.Operation operation, Object key, Struct value, OffsetContext offset) throws InterruptedException {
                EventDispatcher.this.eventListener.onEvent(this.val$dataCollectionId, offset, key, value);
                EventDispatcher.this.streamingReceiver.changeRecord(schema, operation, key, value, offset);
            }
        });
        this.heartbeat.heartbeat(changeRecordEmitter.getOffset().getPartition(), changeRecordEmitter.getOffset().getOffset(), this::enqueueHeartbeat);
        return true;
    }

    public Optional<DataCollectionSchema> errorOnMissingSchema(T dataCollectionId, ChangeRecordEmitter changeRecordEmitter) {
        this.eventListener.onErroneousEvent("source = " + dataCollectionId);
        throw new IllegalArgumentException("No metadata registered for captured table " + dataCollectionId);
    }

    public Optional<DataCollectionSchema> ignoreMissingSchema(T dataCollectionId, ChangeRecordEmitter changeRecordEmitter) {
        return Optional.empty();
    }

    public void dispatchSchemaChangeEvent(T dataCollectionId, SchemaChangeEventEmitter schemaChangeEventEmitter) throws InterruptedException {
        if (!this.filter.isIncluded(dataCollectionId)) {
            LOGGER.trace("Filtering schema change event for {}", dataCollectionId);
            return;
        }
        schemaChangeEventEmitter.emitSchemaChangeEvent(new SchemaChangeEventReceiver());
    }

    public void alwaysDispatchHeartbeatEvent(OffsetContext offset) throws InterruptedException {
        this.heartbeat.forcedBeat(offset.getPartition(), offset.getOffset(), this::enqueueHeartbeat);
    }

    public void dispatchHeartbeatEvent(OffsetContext offset) throws InterruptedException {
        this.heartbeat.heartbeat(offset.getPartition(), offset.getOffset(), this::enqueueHeartbeat);
    }

    public boolean heartbeatsEnabled() {
        return this.heartbeat.isEnabled();
    }

    private void enqueueHeartbeat(SourceRecord record) throws InterruptedException {
        this.queue.enqueue(new DataChangeEvent(record));
    }

    public void setEventListener(DataChangeEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @FunctionalInterface
    public static interface InconsistentSchemaHandler<T extends DataCollectionId> {
        public Optional<DataCollectionSchema> handle(T var1, ChangeRecordEmitter var2);
    }

    private final class SchemaChangeEventReceiver
    implements SchemaChangeEventEmitter.Receiver {
        private SchemaChangeEventReceiver() {
        }

        @Override
        public void schemaChangeEvent(SchemaChangeEvent event) throws InterruptedException {
            EventDispatcher.this.historizedSchema.applySchemaChange(event);
        }
    }

    private final class BufferingSnapshotChangeRecordReceiver
    implements SnapshotReceiver {
        private Supplier<DataChangeEvent> bufferedEvent;

        private BufferingSnapshotChangeRecordReceiver() {
        }

        @Override
        public void changeRecord(DataCollectionSchema dataCollectionSchema, Envelope.Operation operation, Object key, Struct value, OffsetContext offsetContext) throws InterruptedException {
            Objects.requireNonNull(value, "value must not be null");
            LOGGER.trace("Received change record for {} operation on key {}", (Object)operation, key);
            if (this.bufferedEvent != null) {
                EventDispatcher.this.queue.enqueue(this.bufferedEvent.get());
            }
            Schema keySchema = dataCollectionSchema.keySchema();
            String topicName = EventDispatcher.this.topicSelector.topicNameFor(dataCollectionSchema.id());
            this.bufferedEvent = () -> {
                SourceRecord record = new SourceRecord(offsetContext.getPartition(), offsetContext.getOffset(), topicName, null, keySchema, key, dataCollectionSchema.getEnvelopeSchema().schema(), (Object)value);
                return EventDispatcher.this.changeEventCreator.createDataChangeEvent(record);
            };
        }

        @Override
        public void completeSnapshot() throws InterruptedException {
            if (this.bufferedEvent != null) {
                Struct source;
                SnapshotRecord snapshot;
                DataChangeEvent event = this.bufferedEvent.get();
                Struct envelope = (Struct)event.getRecord().value();
                if (envelope.schema().field("source") != null && (snapshot = SnapshotRecord.fromSource(source = envelope.getStruct("source"))) == SnapshotRecord.TRUE) {
                    SnapshotRecord.LAST.toSource(source);
                }
                EventDispatcher.this.queue.enqueue(event);
                this.bufferedEvent = null;
            }
        }
    }

    private final class StreamingChangeRecordReceiver
    implements ChangeRecordEmitter.Receiver {
        private StreamingChangeRecordReceiver() {
        }

        @Override
        public void changeRecord(DataCollectionSchema dataCollectionSchema, Envelope.Operation operation, Object key, Struct value, OffsetContext offsetContext) throws InterruptedException {
            Objects.requireNonNull(value, "value must not be null");
            LOGGER.trace("Received change record for {} operation on key {}", (Object)operation, key);
            Schema keySchema = dataCollectionSchema.keySchema();
            String topicName = EventDispatcher.this.topicSelector.topicNameFor(dataCollectionSchema.id());
            SourceRecord record = new SourceRecord(offsetContext.getPartition(), offsetContext.getOffset(), topicName, null, keySchema, key, dataCollectionSchema.getEnvelopeSchema().schema(), (Object)value);
            EventDispatcher.this.queue.enqueue(EventDispatcher.this.changeEventCreator.createDataChangeEvent(record));
            if (EventDispatcher.this.emitTombstonesOnDelete && operation == Envelope.Operation.DELETE) {
                SourceRecord tombStone = record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), null, null, record.timestamp());
                EventDispatcher.this.queue.enqueue(EventDispatcher.this.changeEventCreator.createDataChangeEvent(tombStone));
            }
        }
    }

    public static interface SnapshotReceiver
    extends ChangeRecordEmitter.Receiver {
        public void completeSnapshot() throws InterruptedException;
    }
}

