/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.AbstractOracleDatatypesTest;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.Before;

public class StreamingDatatypesIT
extends AbstractOracleDatatypesTest {
    @Before
    public void before() throws Exception {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        StreamingDatatypesIT.dropTables();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        String whitelistedTables = this.getAllTables().stream().map(t -> "ORCLPDB1." + t).map(t -> t.replaceAll("\\.", "\\\\.")).collect(Collectors.joining(","));
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_WHITELIST, whitelistedTables)).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        Thread.sleep(2000L);
        StreamingDatatypesIT.createTables();
    }

    @Override
    protected boolean insertRecordsDuringTest() {
        return true;
    }
}

