/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.oracle.antlr.listener.OracleDdlParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlLexer;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Tables;
import java.util.Arrays;
import java.util.Locale;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleDdlParser
extends AntlrDdlParser<PlSqlLexer, PlSqlParser> {
    private String catalogName;
    private String schemaName;

    public OracleDdlParser() {
        super(true);
    }

    public OracleDdlParser(boolean throwErrorsFromTreeWalk, String catalogName, String schemaName) {
        super(throwErrorsFromTreeWalk);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    public void parse(String ddlContent, Tables databaseTables) {
        if (!ddlContent.endsWith(";")) {
            ddlContent = ddlContent + ";";
        }
        super.parse(this.toUpperCase(ddlContent), databaseTables);
    }

    public ParseTree parseTree(PlSqlParser parser) {
        return parser.unit_statement();
    }

    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new OracleDdlParserListener(this.catalogName, this.schemaName, this);
    }

    protected PlSqlLexer createNewLexerInstance(CharStream charStreams) {
        return new PlSqlLexer(charStreams);
    }

    protected PlSqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new PlSqlParser((TokenStream)commonTokenStream);
    }

    protected boolean isGrammarInUpperCase() {
        return true;
    }

    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(PlSqlParser.Native_datatype_elementContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2, new Integer[]{684}), new DataTypeResolver.DataTypeEntry(2, new Integer[]{676}), new DataTypeResolver.DataTypeEntry(2, new Integer[]{1532}), new DataTypeResolver.DataTypeEntry(2, new Integer[]{1094}), new DataTypeResolver.DataTypeEntry(2, new Integer[]{339}), new DataTypeResolver.DataTypeEntry(2, new Integer[]{1093}), new DataTypeResolver.DataTypeEntry(93, new Integer[]{323}), new DataTypeResolver.DataTypeEntry(-102, new Integer[]{1924}), new DataTypeResolver.DataTypeEntry(-101, new Integer[]{1924}), new DataTypeResolver.DataTypeEntry(93, new Integer[]{1924}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{2066}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{2067}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{1098}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{173}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{884}), new DataTypeResolver.DataTypeEntry(100, new Integer[]{113}), new DataTypeResolver.DataTypeEntry(101, new Integer[]{110}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{528}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{1348}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{126}), new DataTypeResolver.DataTypeEntry(2005, new Integer[]{189})));
        return dataTypeResolverBuilder.build();
    }

    protected SystemVariables createNewSystemVariablesInstance() {
        return null;
    }

    public void setCurrentDatabase(String databaseName) {
        this.catalogName = databaseName;
    }

    public void setCurrentSchema(String schemaName) {
        this.schemaName = schemaName;
    }

    public SystemVariables systemVariables() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    private String toUpperCase(String ddl) {
        return ddl.toUpperCase(Locale.ENGLISH);
    }
}

