/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.oracle.Module;
import java.time.Instant;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

@NotThreadSafe
public class SourceInfo
extends AbstractSourceInfo {
    public static final String SERVER_NAME_KEY = "name";
    public static final String TXID_KEY = "txId";
    public static final String TIMESTAMP_KEY = "ts_ms";
    public static final String SCN_KEY = "scn";
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final Schema SCHEMA = SourceInfo.schemaBuilder().name("io.debezium.connector.oracle.Source").field("name", Schema.STRING_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("txId", Schema.OPTIONAL_STRING_SCHEMA).field("scn", Schema.OPTIONAL_INT64_SCHEMA).field("snapshot", Schema.OPTIONAL_BOOLEAN_SCHEMA).build();
    private final String serverName;
    private long scn;
    private String transactionId;
    private Instant sourceTime;
    private boolean snapshot;

    protected SourceInfo(String serverName) {
        super(Module.version());
        this.serverName = serverName;
    }

    protected Schema schema() {
        return SCHEMA;
    }

    protected String connector() {
        return Module.name();
    }

    public Struct struct() {
        return super.struct().put(SERVER_NAME_KEY, (Object)this.serverName).put(TIMESTAMP_KEY, (Object)this.sourceTime.toEpochMilli()).put(TXID_KEY, (Object)this.transactionId).put(SCN_KEY, (Object)this.scn).put(SNAPSHOT_KEY, (Object)this.snapshot);
    }

    public String getServerName() {
        return this.serverName;
    }

    public long getScn() {
        return this.scn;
    }

    public void setScn(long scn) {
        this.scn = scn;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Instant getSourceTime() {
        return this.sourceTime;
    }

    public void setSourceTime(Instant sourceTime) {
        this.sourceTime = sourceTime;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }
}

