/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.ddl.parser.oracle.generated.PlSqlLexer;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.ddl.parser.oracle.generated.PlSqlParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParser;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class OracleDdlParser
implements DdlParser {
    private String catalogName;
    private String schemaName;

    public void setCurrentDatabase(String databaseName) {
        this.catalogName = databaseName;
    }

    public void setCurrentSchema(String schemaName) {
        this.schemaName = schemaName;
    }

    public DdlChanges getDdlChanges() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String terminator() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public SystemVariables systemVariables() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void parse(String ddlContent, Tables databaseTables) {
        if (!ddlContent.endsWith(";")) {
            ddlContent = ddlContent + ";";
        }
        try {
            PlSqlLexer lexer = new PlSqlLexer((CharStream)new ANTLRInputStream(this.toUpperCase(ddlContent)));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            PlSqlParser parser = new PlSqlParser((TokenStream)tokens);
            PlSqlParser.Unit_statementContext ast = parser.unit_statement();
            CreateTableListener createTablelistener = new CreateTableListener();
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)createTablelistener, (ParseTree)ast);
            if (createTablelistener.getTable() != null) {
                databaseTables.overwriteTable(createTablelistener.getTable());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't parse DDL statement " + ddlContent, e);
        }
    }

    private String toUpperCase(String ddl) {
        return ddl.toUpperCase(Locale.ENGLISH);
    }

    private class CreateTableListener
    extends PlSqlParserBaseListener {
        private TableEditor editor;

        private CreateTableListener() {
        }

        public Table getTable() {
            return this.editor != null ? this.editor.create() : null;
        }

        public void enterCreate_table(PlSqlParser.Create_tableContext ctx) {
            if (ctx.relational_table() == null) {
                throw new IllegalArgumentException("Only relational tables are supported");
            }
            this.editor = Table.editor();
            this.editor.tableId(new TableId(OracleDdlParser.this.catalogName, OracleDdlParser.this.schemaName, this.getTableName(ctx.tableview_name())));
            super.enterCreate_table(ctx);
        }

        private String getTableName(PlSqlParser.Tableview_nameContext tableview_name) {
            if (tableview_name.id_expression() != null) {
                return tableview_name.id_expression().getText();
            }
            return tableview_name.identifier().id_expression().getText();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void exitColumn_definition(PlSqlParser.Column_definitionContext ctx) {
            PlSqlParser.Precision_partContext precisionPart = ctx.datatype().precision_part();
            ColumnEditor columnEditor = Column.editor();
            columnEditor.name(this.getColumnName(ctx.column_name()));
            if (ctx.datatype().native_datatype_element() != null) {
                if (ctx.datatype().native_datatype_element().INT() != null || ctx.datatype().native_datatype_element().INTEGER() != null || ctx.datatype().native_datatype_element().SMALLINT() != null || ctx.datatype().native_datatype_element().NUMERIC() != null || ctx.datatype().native_datatype_element().DECIMAL() != null) {
                    columnEditor.jdbcType(2).type("NUMBER");
                    if (precisionPart == null) {
                        columnEditor.length(38).scale(Integer.valueOf(0));
                    } else {
                        this.setPrecision(precisionPart, columnEditor);
                        this.setScale(precisionPart, columnEditor);
                    }
                } else if (ctx.datatype().native_datatype_element().DATE() != null) {
                    columnEditor.jdbcType(93).type("DATE");
                } else if (ctx.datatype().native_datatype_element().TIMESTAMP() != null) {
                    if (ctx.datatype().WITH() != null && ctx.datatype().TIME() != null && ctx.datatype().ZONE() != null) {
                        if (ctx.datatype().LOCAL() != null) {
                            columnEditor.jdbcType(-102).type("TIMESTAMP WITH LOCAL TIME ZONE");
                        } else {
                            columnEditor.jdbcType(-101).type("TIMESTAMP WITH TIME ZONE");
                        }
                    } else {
                        columnEditor.jdbcType(93).type("TIMESTAMP");
                    }
                    if (precisionPart == null) {
                        columnEditor.length(6);
                    } else {
                        this.setPrecision(precisionPart, columnEditor);
                    }
                } else if (ctx.datatype().native_datatype_element().VARCHAR2() != null || ctx.datatype().native_datatype_element().VARCHAR() != null) {
                    columnEditor.jdbcType(12).type("VARCHAR2");
                    if (precisionPart == null) {
                        columnEditor.length(this.getVarCharDefaultLength());
                    } else {
                        this.setPrecision(precisionPart, columnEditor);
                    }
                } else if (ctx.datatype().native_datatype_element().NVARCHAR2() != null) {
                    columnEditor.jdbcType(-9).type("NVARCHAR2");
                    if (precisionPart == null) {
                        columnEditor.length(this.getVarCharDefaultLength());
                    } else {
                        this.setPrecision(precisionPart, columnEditor);
                    }
                } else if (ctx.datatype().native_datatype_element().CHAR() != null) {
                    columnEditor.jdbcType(1).type("CHAR").length(1);
                } else if (ctx.datatype().native_datatype_element().NCHAR() != null) {
                    columnEditor.jdbcType(-15).type("NCHAR").length(1);
                } else if (ctx.datatype().native_datatype_element().BINARY_FLOAT() != null) {
                    columnEditor.jdbcType(100).type("BINARY_FLOAT");
                } else if (ctx.datatype().native_datatype_element().BINARY_DOUBLE() != null) {
                    columnEditor.jdbcType(101).type("BINARY_DOUBLE");
                } else if (ctx.datatype().native_datatype_element().FLOAT() != null || ctx.datatype().native_datatype_element().DOUBLE() != null && ctx.datatype().native_datatype_element().PRECISION() != null) {
                    columnEditor.jdbcType(6).type("FLOAT").length(126);
                    if (precisionPart != null) {
                        this.setPrecision(precisionPart, columnEditor);
                    }
                } else if (ctx.datatype().native_datatype_element().REAL() != null) {
                    columnEditor.jdbcType(6).type("FLOAT").length(63);
                } else {
                    if (ctx.datatype().native_datatype_element().NUMBER() == null) throw new IllegalArgumentException("Unsupported column type: " + ctx.datatype().native_datatype_element().getText());
                    columnEditor.jdbcType(2).type("NUMBER");
                    if (precisionPart == null) {
                        columnEditor.length(38);
                    } else {
                        this.setPrecision(precisionPart, columnEditor);
                        this.setScale(precisionPart, columnEditor);
                    }
                }
            } else if (ctx.datatype().INTERVAL() != null && ctx.datatype().YEAR() != null && ctx.datatype().TO() != null && ctx.datatype().MONTH() != null) {
                columnEditor.jdbcType(-103).type("INTERVAL YEAR TO MONTH").length(2);
                if (!ctx.datatype().expression().isEmpty()) {
                    columnEditor.length(Integer.valueOf(ctx.datatype().expression(0).getText()).intValue());
                }
            } else {
                if (ctx.datatype().INTERVAL() == null || ctx.datatype().DAY() == null || ctx.datatype().TO() == null || ctx.datatype().SECOND() == null) throw new IllegalArgumentException("Unsupported column type: " + ctx.datatype().getText());
                columnEditor.jdbcType(-104).type("INTERVAL DAY TO SECOND").length(2).scale(Integer.valueOf(6));
                for (PlSqlParser.ExpressionContext e : ctx.datatype().expression()) {
                    if (e.getSourceInterval().startsAfter(ctx.datatype().TO().getSourceInterval())) {
                        columnEditor.scale(Integer.valueOf(e.getText()));
                        continue;
                    }
                    columnEditor.length(Integer.valueOf(e.getText()).intValue());
                }
                if (!ctx.datatype().expression().isEmpty()) {
                    columnEditor.length(Integer.valueOf(ctx.datatype().expression(0).getText()).intValue());
                }
            }
            boolean hasNotNullConstraint = ctx.inline_constraint().stream().filter(c -> c.NOT() != null).findFirst().isPresent();
            columnEditor.optional(!hasNotNullConstraint);
            this.editor.addColumn(columnEditor.create());
            super.exitColumn_definition(ctx);
        }

        private int getVarCharDefaultLength() {
            return 4000;
        }

        private void setPrecision(PlSqlParser.Precision_partContext precisionPart, ColumnEditor columnEditor) {
            columnEditor.length(Integer.valueOf(precisionPart.numeric(0).getText()).intValue());
        }

        private void setScale(PlSqlParser.Precision_partContext precisionPart, ColumnEditor columnEditor) {
            if (precisionPart.numeric().size() > 1) {
                columnEditor.scale(Integer.valueOf(precisionPart.numeric(1).getText()));
            } else if (precisionPart.numeric_negative() != null) {
                columnEditor.scale(Integer.valueOf(precisionPart.numeric_negative().getText()));
            } else {
                columnEditor.scale(Integer.valueOf(0));
            }
        }

        public void exitOut_of_line_constraint(PlSqlParser.Out_of_line_constraintContext ctx) {
            if (ctx.PRIMARY() != null) {
                List pkColumnNames = ctx.column_name().stream().map(this::getColumnName).collect(Collectors.toList());
                this.editor.setPrimaryKeyNames(pkColumnNames);
            }
            super.exitOut_of_line_constraint(ctx);
        }

        private String getColumnName(PlSqlParser.Column_nameContext ctx) {
            return ctx.identifier().id_expression().getText();
        }
    }
}

