/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnection
extends JdbcConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnection.class);
    private static final int ORACLE_UNSET_SCALE = -127;

    public OracleConnection(Configuration config, JdbcConnection.ConnectionFactory connectionFactory) {
        super(config, connectionFactory);
    }

    public void setSessionToPdb(String pdbName) {
        Statement statement = null;
        try {
            statement = this.connection().createStatement();
            statement.execute("alter session set container=" + pdbName);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Couldn't close statement", (Throwable)e);
                }
            }
        }
    }

    public void resetSessionToCdb() {
        Statement statement = null;
        try {
            statement = this.connection().createStatement();
            statement.execute("alter session set container=cdb$root");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Couldn't close statement", (Throwable)e);
                }
            }
        }
    }

    public Set<TableId> readTableNames(String databaseCatalog, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        Set tableIds = super.readTableNames(null, schemaNamePattern, tableNamePattern, tableTypes);
        return tableIds.stream().map(t -> new TableId(databaseCatalog, t.schema(), t.table())).collect(Collectors.toSet());
    }

    public void readSchema(Tables tables, String databaseCatalog, String schemaNamePattern, Tables.TableFilter tableFilter, Tables.ColumnNameFilter columnFilter, boolean removeTablesNotFoundInJdbc) throws SQLException {
        super.readSchema(tables, null, schemaNamePattern, null, columnFilter, removeTablesNotFoundInJdbc);
        HashSet tableIds = new HashSet(tables.tableIds());
        for (TableId tableId : tableIds) {
            TableId tableIdWithCatalog = new TableId(databaseCatalog, tableId.schema(), tableId.table());
            if (tableFilter.isIncluded(tableIdWithCatalog)) {
                TableEditor editor = tables.editTable(tableId);
                editor.tableId(tableIdWithCatalog);
                ArrayList columnNames = new ArrayList(editor.columnNames());
                for (String columnName : columnNames) {
                    Column column = editor.columnWithName(columnName);
                    if (column.jdbcType() == 93) {
                        editor.addColumn(column.edit().length(column.scale().orElse(-1).intValue()).scale(null).create());
                        continue;
                    }
                    if (column.jdbcType() != 2) continue;
                    column.scale().filter(s -> s == -127).ifPresent(s -> editor.addColumn(column.edit().scale(null).create()));
                }
                tables.overwriteTable(editor.create());
            }
            tables.removeTable(tableId);
        }
    }
}

