/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class OracleConnectorIT
extends AbstractConnectorTest {
    private static final long MICROS_PER_SECOND = TimeUnit.SECONDS.toMicros(1L);
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private static OracleConnection connection;

    @BeforeClass
    public static void beforeClass() throws SQLException {
        connection = TestHelper.testConnection();
        TestHelper.dropTable(connection, "debezium.customer");
        String ddl = "create table debezium.customer (  id int not null,   name varchar2(1000),   score decimal(6, 2),   registered timestamp,   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.customer to  c##xstrm"});
        connection.execute(new String[]{"ALTER TABLE debezium.customer ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Before
    public void before() throws SQLException {
        connection.execute(new String[]{"delete from debezium.customer"});
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @Test
    public void shouldTakeSnapshot() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "ORCLPDB1\\.DEBEZIUM\\.CUSTOMER")).build();
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (2, 'Bruce', 2345.67, null)"});
        connection.execute(new String[]{"COMMIT"});
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount += 2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record1 = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValidRead((SourceRecord)record1);
        Struct after = (Struct)((Struct)record1.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
        Assertions.assertThat(record1.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat(record1.sourceOffset().get(SNAPSHOT_COMPLETED_KEY)).isEqualTo((Object)false);
        Struct source = (Struct)((Struct)record1.value()).get("source");
        Assertions.assertThat((Object)source.get("snapshot")).isEqualTo((Object)true);
        SourceRecord record2 = (SourceRecord)testTableRecords.get(1);
        VerifyRecord.isValidRead((SourceRecord)record2);
        after = (Struct)((Struct)record2.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(2L));
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)after.get("REGISTERED")).isNull();
        Assertions.assertThat(record2.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat(record2.sourceOffset().get(SNAPSHOT_COMPLETED_KEY)).isEqualTo((Object)true);
        source = (Struct)((Struct)record2.value()).get("source");
        Assertions.assertThat((Object)source.get("snapshot")).isEqualTo((Object)true);
    }

    @Test
    public void shouldContinueWithStreamingAfterSnapshot() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "ORCLPDB1\\.DEBEZIUM\\.CUSTOMER")).build();
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (2, 'Bruce', 2345.67, null)"});
        connection.execute(new String[]{"COMMIT"});
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount += 2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record1 = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValidRead((SourceRecord)record1);
        Struct after = (Struct)((Struct)record1.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Struct source = (Struct)((Struct)record1.value()).get("source");
        Assertions.assertThat((Object)source.get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat((Object)source.get("scn")).isNotNull();
        Assertions.assertThat((Object)source.get("name")).isEqualTo((Object)"server1");
        Assertions.assertThat((Object)source.get("version")).isNotNull();
        Assertions.assertThat((Object)source.get("txId")).isNull();
        Assertions.assertThat((Object)source.get("ts_ms")).isNotNull();
        Assertions.assertThat(record1.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat(record1.sourceOffset().get(SNAPSHOT_COMPLETED_KEY)).isEqualTo((Object)false);
        SourceRecord record2 = (SourceRecord)testTableRecords.get(1);
        VerifyRecord.isValidRead((SourceRecord)record2);
        after = (Struct)((Struct)record2.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(2L));
        Assertions.assertThat(record2.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        Assertions.assertThat(record2.sourceOffset().get(SNAPSHOT_COMPLETED_KEY)).isEqualTo((Object)true);
        expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (3, 'Brian', 2345.67, null)"});
        connection.execute(new String[]{"COMMIT"});
        records = this.consumeRecordsByTopic(++expectedRecordCount);
        testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        SourceRecord record3 = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record3);
        after = (Struct)((Struct)record3.value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(3L));
        Assertions.assertThat((boolean)record3.sourceOffset().containsKey("snapshot")).isFalse();
        Assertions.assertThat((boolean)record3.sourceOffset().containsKey(SNAPSHOT_COMPLETED_KEY)).isFalse();
        source = (Struct)((Struct)record3.value()).get("source");
        Assertions.assertThat((Object)source.get("snapshot")).isEqualTo((Object)false);
        Assertions.assertThat((Object)source.get("scn")).isNotNull();
        Assertions.assertThat((Object)source.get("name")).isEqualTo((Object)"server1");
        Assertions.assertThat((Object)source.get("version")).isNotNull();
        Assertions.assertThat((Object)source.get("txId")).isNotNull();
        Assertions.assertThat((Object)source.get("ts_ms")).isNotNull();
    }

    @Test
    public void shouldReadChangeStreamForExistingTable() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "ORCLPDB1\\.DEBEZIUM\\.CUSTOMER")).with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        Thread.sleep(1000L);
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"COMMIT"});
        ++expectedRecordCount;
        connection.execute(new String[]{"UPDATE debezium.customer SET name = 'Bruce', score = 2345.67, registered = TO_DATE('2018/03/23', 'yyyy-mm-dd') WHERE id = 1"});
        connection.execute(new String[]{"COMMIT"});
        ++expectedRecordCount;
        connection.execute(new String[]{"UPDATE debezium.customer SET id = 2 WHERE id = 1"});
        connection.execute(new String[]{"COMMIT"});
        expectedRecordCount += 3;
        connection.execute(new String[]{"DELETE debezium.customer WHERE id = 2"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount += 2);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
        Map offset = ((SourceRecord)testTableRecords.get(0)).sourceOffset();
        Assertions.assertThat(offset.get("snapshot")).isNull();
        Assertions.assertThat(offset.get(SNAPSHOT_COMPLETED_KEY)).isNull();
        VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)testTableRecords.get(1)));
        Struct before = (Struct)((Struct)((SourceRecord)testTableRecords.get(1)).value()).get("before");
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)before.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)before.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)before.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
        after = (Struct)((Struct)((SourceRecord)testTableRecords.get(1)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)testTableRecords.get(2)));
        before = (Struct)((Struct)((SourceRecord)testTableRecords.get(2)).value()).get("before");
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)before.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)before.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)before.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)testTableRecords.get(3)));
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(4)));
        after = (Struct)((Struct)((SourceRecord)testTableRecords.get(4)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(2L));
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)testTableRecords.get(5)));
        before = (Struct)((Struct)((SourceRecord)testTableRecords.get(5)).value()).get("before");
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)BigDecimal.valueOf(2L));
        Assertions.assertThat((Object)before.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)before.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)before.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)testTableRecords.get(6)));
    }

    @Test
    public void shouldReadChangeStreamForTableCreatedWhileStreaming() throws Exception {
        TestHelper.dropTable(connection, "debezium.customer2");
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_WHITELIST, "ORCLPDB1\\.DEBEZIUM\\.CUSTOMER2")).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        Thread.sleep(1000L);
        String ddl = "create table debezium.customer2 (  id int not null,   name varchar2(1000),   score decimal(6, 2),   registered timestamp,   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.customer2 to c##xstrm"});
        connection.execute(new String[]{"INSERT INTO debezium.customer2 VALUES (2, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.CUSTOMER2");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(2L));
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
    }

    @Test
    @FixFor(value={"DBZ-800"})
    public void shouldReceiveHeartbeatAlsoWhenChangingNonWhitelistedTable() throws Exception {
        TestHelper.dropTable(connection, "debezium.dbz800a");
        TestHelper.dropTable(connection, "debezium.dbz800b");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(Heartbeat.HEARTBEAT_INTERVAL, "1")).with(OracleConnectorConfig.TABLE_WHITELIST, "ORCLPDB1\\.DEBEZIUM\\.DBZ800B")).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        Thread.sleep(1000L);
        connection.execute(new String[]{"CREATE TABLE debezium.dbz800a (id NUMBER(9) NOT NULL, aaa VARCHAR2(100), PRIMARY KEY (id) )"});
        connection.execute(new String[]{"CREATE TABLE debezium.dbz800b (id NUMBER(9) NOT NULL, bbb VARCHAR2(100), PRIMARY KEY (id) )"});
        connection.execute(new String[]{"INSERT INTO debezium.dbz800a VALUES (1, 'AAA')"});
        connection.execute(new String[]{"INSERT INTO debezium.dbz800b VALUES (2, 'BBB')"});
        connection.execute(new String[]{"COMMIT"});
        List records = this.consumeRecordsByTopic(3).allRecordsInOrder();
        this.verifyHeartbeatRecord((SourceRecord)records.get(0));
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)records.get(1)), (String)"ID", (int)2);
        this.verifyHeartbeatRecord((SourceRecord)records.get(2));
    }

    private void verifyHeartbeatRecord(SourceRecord heartbeat) {
        TestCase.assertEquals((String)"__debezium-heartbeat.server1", (String)heartbeat.topic());
        Struct key = (Struct)heartbeat.key();
        Assertions.assertThat((Object)key.get("serverName")).isEqualTo((Object)"server1");
    }

    private long toMicroSecondsSinceEpoch(LocalDateTime localDateTime) {
        return localDateTime.toEpochSecond(ZoneOffset.UTC) * MICROS_PER_SECOND;
    }
}

