/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.SourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import java.lang.constant.Constable;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class OracleOffsetContext
implements OffsetContext {
    private static final String SERVER_PARTITION_KEY = "server";
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private final Schema sourceInfoSchema;
    private final Map<String, String> partition;
    private final SourceInfo sourceInfo;
    private boolean snapshotCompleted;

    private OracleOffsetContext(String serverName, long scn, boolean snapshot, boolean snapshotCompleted) {
        this.partition = Collections.singletonMap(SERVER_PARTITION_KEY, serverName);
        this.sourceInfo = new SourceInfo(serverName);
        this.sourceInfo.setScn(scn);
        this.sourceInfo.setSnapshot(snapshot);
        this.sourceInfoSchema = this.sourceInfo.schema();
        this.snapshotCompleted = snapshotCompleted;
    }

    public static Builder create() {
        return new Builder();
    }

    public Map<String, ?> getPartition() {
        return this.partition;
    }

    public Map<String, ?> getOffset() {
        if (this.sourceInfo.isSnapshot()) {
            HashMap<String, Constable> offset = new HashMap<String, Constable>();
            offset.put("scn", Long.valueOf(this.sourceInfo.getScn()));
            offset.put("snapshot", Boolean.valueOf(true));
            offset.put(SNAPSHOT_COMPLETED_KEY, Boolean.valueOf(this.snapshotCompleted));
            return offset;
        }
        return Collections.singletonMap("scn", this.sourceInfo.getScn());
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public void setScn(long scn) {
        this.sourceInfo.setScn(scn);
    }

    public long getScn() {
        return this.sourceInfo.getScn();
    }

    public void setTransactionId(String transactionId) {
        this.sourceInfo.setTransactionId(transactionId);
    }

    public void setSourceTime(Instant instant) {
        this.sourceInfo.setSourceTime(instant);
    }

    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && !this.snapshotCompleted;
    }

    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(true);
        this.snapshotCompleted = false;
    }

    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OracleOffsetContext [scn=").append(this.getScn());
        if (this.sourceInfo.isSnapshot()) {
            sb.append(", snapshot=").append(this.sourceInfo.isSnapshot());
            sb.append(", snapshot_completed=").append(this.snapshotCompleted);
        }
        sb.append("]");
        return sb.toString();
    }

    public static class Loader
    implements OffsetContext.Loader {
        private final String logicalName;

        public Loader(String logicalName) {
            this.logicalName = logicalName;
        }

        public Map<String, ?> getPartition() {
            return Collections.singletonMap(OracleOffsetContext.SERVER_PARTITION_KEY, this.logicalName);
        }

        public OffsetContext load(Map<String, ?> offset) {
            Long scn = (Long)offset.get("scn");
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(OracleOffsetContext.SNAPSHOT_COMPLETED_KEY));
            return new OracleOffsetContext(this.logicalName, scn, snapshot, snapshotCompleted);
        }
    }

    public static class Builder {
        private String logicalName;
        private long scn;
        private boolean snapshot;
        private boolean snapshotCompleted;

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            return this;
        }

        public Builder scn(long scn) {
            this.scn = scn;
            return this;
        }

        public Builder snapshot(boolean snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder snapshotCompleted(boolean snapshotCompleted) {
            this.snapshotCompleted = snapshotCompleted;
            return this;
        }

        OracleOffsetContext build() {
            return new OracleOffsetContext(this.logicalName, this.scn, this.snapshot, this.snapshotCompleted);
        }
    }
}

