/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.Tables;
import org.apache.kafka.common.config.ConfigDef;

public abstract class RelationalDatabaseConnectorConfig
extends CommonConnectorConfig {
    public static final Field TABLE_WHITELIST = Field.create("table.whitelist").withDisplayName("Included tables").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isListOfRegex).withDescription("The tables for which changes are to be captured");
    public static final Field TABLE_BLACKLIST = Field.create("table.blacklist").withDisplayName("Excluded tables").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(Field::isListOfRegex, RelationalDatabaseConnectorConfig::validateTableBlacklist).withInvisibleRecommender();
    public static final Field TABLE_IGNORE_BUILTIN = Field.create("table.ignore.builtin").withDisplayName("Ignore system databases").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withValidation(Field::isBoolean).withDescription("Flag specifying whether built-in tables should be ignored.");
    private final RelationalTableFilters tableFilters;

    protected RelationalDatabaseConnectorConfig(Configuration config, String logicalName, Tables.TableFilter systemTablesFilter) {
        super(config, logicalName);
        this.tableFilters = new RelationalTableFilters(config, systemTablesFilter);
    }

    public RelationalTableFilters getTableFilters() {
        return this.tableFilters;
    }

    private static int validateTableBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(TABLE_WHITELIST);
        String blacklist = config.getString(TABLE_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(TABLE_BLACKLIST, blacklist, "Table whitelist is already specified");
            return 1;
        }
        return 0;
    }
}

