/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleDdlParser;
import io.debezium.ddl.parser.oracle.generated.PlSqlLexer;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.util.List;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class OracleDdlParserTest {
    @Test
    public void shouldParseCreateTable() {
        String ddl = "create table debezium.customer (  id int not null,   name varchar2(1000),   score decimal(6, 2),   registered date,   primary key (id));";
        OracleDdlParser parser = new OracleDdlParser();
        parser.setCurrentDatabase("ORCLPDB1");
        parser.setCurrentSchema("DEBEZIUM");
        Tables tables = new Tables();
        parser.parse(ddl, tables);
        Table table = tables.forTable(new TableId("ORCLPDB1", "DEBEZIUM", "CUSTOMER"));
        Assertions.assertThat((Object)table).isNotNull();
        Column id = table.columnWithName("ID");
        Assertions.assertThat((boolean)id.isOptional()).isFalse();
        Assertions.assertThat((int)id.jdbcType()).isEqualTo(2);
        Assertions.assertThat((String)id.typeName()).isEqualTo((Object)"NUMBER");
        Column name = table.columnWithName("NAME");
        Assertions.assertThat((boolean)name.isOptional()).isTrue();
        Assertions.assertThat((int)name.jdbcType()).isEqualTo(12);
        Assertions.assertThat((String)name.typeName()).isEqualTo((Object)"VARCHAR2");
        Assertions.assertThat((int)name.length()).isEqualTo(1000);
        Column score = table.columnWithName("SCORE");
        Assertions.assertThat((boolean)score.isOptional()).isTrue();
        Assertions.assertThat((int)score.jdbcType()).isEqualTo(2);
        Assertions.assertThat((String)score.typeName()).isEqualTo((Object)"NUMBER");
        Assertions.assertThat((int)score.length()).isEqualTo(6);
        Assertions.assertThat((Integer)((Integer)score.scale().get())).isEqualTo(2);
        Assertions.assertThat((List)table.columns()).hasSize(4);
        Assertions.assertThat((boolean)table.isPrimaryKeyColumn("ID"));
    }

    private void printAst(String ddl) {
        PlSqlLexer lexer = new PlSqlLexer((CharStream)new ANTLRInputStream(ddl));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PlSqlParser parser = new PlSqlParser((TokenStream)tokens);
        PlSqlParser.Unit_statementContext ast = parser.unit_statement();
        new AstPrinter().print((RuleContext)ast);
    }

    private static class AstPrinter {
        private AstPrinter() {
        }

        public void print(RuleContext ctx) {
            this.explore(ctx, 0);
        }

        private void explore(RuleContext ctx, int indentation) {
            int i;
            String ruleName = PlSqlParser.ruleNames[ctx.getRuleIndex()];
            for (i = 0; i < indentation; ++i) {
                System.out.print("  ");
            }
            System.out.println(ruleName);
            for (i = 0; i < ctx.getChildCount(); ++i) {
                ParseTree element = ctx.getChild(i);
                if (!(element instanceof RuleContext)) continue;
                this.explore((RuleContext)element, indentation + 1);
            }
        }
    }
}

