/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.SourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class OracleOffsetContext
implements OffsetContext {
    private static final String SERVER_PARTITION_KEY = "server";
    private final Schema sourceInfoSchema;
    private final Map<String, String> partition;
    private final SourceInfo sourceInfo;

    public OracleOffsetContext(String serverName) {
        this.partition = Collections.singletonMap(SERVER_PARTITION_KEY, serverName);
        this.sourceInfo = new SourceInfo(serverName);
        this.sourceInfoSchema = this.sourceInfo.schema();
    }

    public Map<String, ?> getPartition() {
        return this.partition;
    }

    public Map<String, ?> getOffset() {
        return Collections.singletonMap("scn", this.sourceInfo.getScn());
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public void setScn(long scn) {
        this.sourceInfo.setScn(scn);
    }

    public long getScn() {
        return this.sourceInfo.getScn();
    }

    public void setTransactionId(String transactionId) {
        this.sourceInfo.setTransactionId(transactionId);
    }

    public void setSourceTime(Instant instant) {
        this.sourceInfo.setSourceTime(instant);
    }
}

