/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleChangeEventSourceFactory;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectionFactory;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.OracleTopicSelector;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnectorTask
extends BaseSourceTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnectorTask.class);
    private static final String CONTEXT_NAME = "oracle-connector-task";
    private final AtomicReference<State> state = new AtomicReference<State>(State.STOPPED);
    private volatile OracleTaskContext taskContext;
    private volatile ChangeEventQueue<Object> queue;
    private volatile OracleConnection jdbcConnection;
    private volatile ChangeEventSourceCoordinator coordinator;
    private volatile ErrorHandler errorHandler;
    private volatile OracleDatabaseSchema schema;
    private volatile Map<String, ?> lastOffset;

    public String version() {
        return Module.version();
    }

    public void start(Configuration config) {
        if (!this.state.compareAndSet(State.STOPPED, State.RUNNING)) {
            LOGGER.info("Connector has already been started");
            return;
        }
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        this.taskContext = new OracleTaskContext(connectorConfig);
        Clock clock = Clock.system();
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new ErrorHandler(OracleConnector.class, connectorConfig.getLogicalName(), this.queue, this::cleanupResources);
        TopicSelector<TableId> topicSelector = OracleTopicSelector.defaultSelector(connectorConfig);
        Configuration jdbcConfig = config.subset("database.", true);
        this.jdbcConnection = new OracleConnection(jdbcConfig, new OracleConnectionFactory());
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create((Logger)LOGGER);
        this.schema = new OracleDatabaseSchema(connectorConfig, schemaNameAdjuster, topicSelector, this.jdbcConnection);
        OracleOffsetContext previousOffset = this.getPreviousOffset(connectorConfig);
        if (previousOffset != null) {
            this.schema.recover(previousOffset);
        }
        EventDispatcher dispatcher = new EventDispatcher(topicSelector, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter());
        this.coordinator = new ChangeEventSourceCoordinator((OffsetContext)previousOffset, this.errorHandler, OracleConnector.class, connectorConfig.getLogicalName(), (ChangeEventSourceFactory)new OracleChangeEventSourceFactory(connectorConfig, this.jdbcConnection, this.errorHandler, dispatcher, clock, this.schema));
        this.coordinator.start();
    }

    private OracleOffsetContext getPreviousOffset(OracleConnectorConfig connectorConfig) {
        OracleOffsetContext offsetContext = new OracleOffsetContext(connectorConfig.getLogicalName());
        Map previousOffset = (Map)this.context.offsetStorageReader().offsets(Collections.singleton(offsetContext.getPartition())).get(offsetContext.getPartition());
        if (previousOffset != null) {
            long scn = (Long)previousOffset.get("scn");
            offsetContext.setScn(scn);
            LOGGER.info("Found previous offset {}", (Object)offsetContext);
            return offsetContext;
        }
        return null;
    }

    public List<SourceRecord> poll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        if (!sourceRecords.isEmpty()) {
            this.lastOffset = sourceRecords.get(sourceRecords.size() - 1).sourceOffset();
        }
        return sourceRecords;
    }

    public void commit() throws InterruptedException {
        this.coordinator.commitOffset(this.lastOffset);
    }

    public void stop() {
        this.cleanupResources();
    }

    private void cleanupResources() {
        if (!this.state.compareAndSet(State.RUNNING, State.STOPPED)) {
            LOGGER.info("Connector has already been stopped");
            return;
        }
        try {
            if (this.coordinator != null) {
                this.coordinator.stop();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.error("Interrupted while stopping coordinator", (Throwable)e);
            throw new ConnectException("Interrupted while stopping coordinator, failing the task");
        }
        try {
            if (this.errorHandler != null) {
                this.errorHandler.stop();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.error("Interrupted while stopping", (Throwable)e);
        }
        try {
            if (this.jdbcConnection != null) {
                this.jdbcConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
        }
        this.schema.close();
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return OracleConnectorConfig.ALL_FIELDS;
    }

    private static enum State {
        RUNNING,
        STOPPED;

    }
}

