/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.SchemaAndValueField;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.time.MicroDuration;
import io.debezium.time.MicroTimestamp;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractOracleDatatypesTest
extends AbstractConnectorTest {
    static final String PRECISION_PARAMETER_KEY = "connect.decimal.precision";
    private static final Schema INTEGER_SCHEMA = Decimal.builder((int)0).optional().parameter("connect.decimal.precision", "38").build();
    private static final String DDL_STRING = "create table debezium.type_string (  id int not null,   val_varchar2 varchar2(1000),   val_nvarchar2 nvarchar2(1000),   val_char char(3),   val_nchar nchar(3),   primary key (id))";
    private static final String DDL_FP = "create table debezium.type_fp (  id int not null,   val_bf binary_float,   val_bd binary_double,   val_f float,   val_num number(10,6),   val_dp double precision,   val_r real,   val_num_vs number,   primary key (id))";
    private static final String DDL_INT = "create table debezium.type_int (  id int not null,   val_int int,   val_integer integer,   val_smallint smallint,   primary key (id))";
    private static final String DDL_TIME = "create table debezium.type_time (  id int not null,   val_date date,   val_ts timestamp,   val_tstz timestamp with time zone,   val_tsltz timestamp with local time zone,   val_int_ytm interval year to month,   val_int_dts interval day(3) to second(2),   primary key (id))";
    private static final List<SchemaAndValueField> EXPECTED_STRING = Arrays.asList(new SchemaAndValueField("VAL_VARCHAR2", (Object)Schema.OPTIONAL_STRING_SCHEMA, (Object)"v\u010d2"), new SchemaAndValueField("VAL_NVARCHAR2", (Object)Schema.OPTIONAL_STRING_SCHEMA, (Object)"nv\u010d2"), new SchemaAndValueField("VAL_CHAR", (Object)Schema.OPTIONAL_STRING_SCHEMA, (Object)"c  "), new SchemaAndValueField("VAL_NCHAR", (Object)Schema.OPTIONAL_STRING_SCHEMA, (Object)"n\u010d "));
    private static final List<SchemaAndValueField> EXPECTED_FP = Arrays.asList(new SchemaAndValueField("VAL_BF", (Object)Schema.OPTIONAL_FLOAT32_SCHEMA, (Object)Float.valueOf(1.1f)), new SchemaAndValueField("VAL_BD", (Object)Schema.OPTIONAL_FLOAT64_SCHEMA, (Object)2.22), new SchemaAndValueField("VAL_F", (Object)VariableScaleDecimal.builder().optional().build(), (Object)VariableScaleDecimal.fromLogical((Schema)VariableScaleDecimal.builder().optional().build(), (SpecialValueDecimal)new SpecialValueDecimal(new BigDecimal("3.33")))), new SchemaAndValueField("VAL_NUM", (Object)Decimal.builder((int)6).parameter("connect.decimal.precision", "10").optional().build(), (Object)new BigDecimal("4.4444")), new SchemaAndValueField("VAL_DP", (Object)VariableScaleDecimal.builder().optional().build(), (Object)VariableScaleDecimal.fromLogical((Schema)VariableScaleDecimal.builder().optional().build(), (SpecialValueDecimal)new SpecialValueDecimal(new BigDecimal("5.555")))), new SchemaAndValueField("VAL_R", (Object)VariableScaleDecimal.builder().optional().build(), (Object)VariableScaleDecimal.fromLogical((Schema)VariableScaleDecimal.builder().optional().build(), (SpecialValueDecimal)new SpecialValueDecimal(new BigDecimal("6.66")))), new SchemaAndValueField("VAL_NUM_VS", (Object)VariableScaleDecimal.builder().optional().build(), (Object)VariableScaleDecimal.fromLogical((Schema)VariableScaleDecimal.builder().optional().build(), (SpecialValueDecimal)new SpecialValueDecimal(new BigDecimal("77.323")))));
    private static final List<SchemaAndValueField> EXPECTED_INT = Arrays.asList(new SchemaAndValueField("VAL_INT", (Object)INTEGER_SCHEMA, (Object)new BigDecimal("1")), new SchemaAndValueField("VAL_INTEGER", (Object)INTEGER_SCHEMA, (Object)new BigDecimal("22")), new SchemaAndValueField("VAL_SMALLINT", (Object)INTEGER_SCHEMA, (Object)new BigDecimal("333")));
    private static final List<SchemaAndValueField> EXPECTED_TIME = Arrays.asList(new SchemaAndValueField("VAL_DATE", (Object)Timestamp.builder().optional().build(), (Object)1522108800000L), new SchemaAndValueField("VAL_TS", (Object)MicroTimestamp.builder().optional().build(), (Object)(LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 7890L)), new SchemaAndValueField("VAL_TSTZ", (Object)ZonedTimestamp.builder().optional().build(), (Object)"2018-03-27T01:34:56.00789-11:00"), new SchemaAndValueField("VAL_INT_YTM", (Object)MicroDuration.builder().optional().build(), (Object)-1.104516E14), new SchemaAndValueField("VAL_INT_DTS", (Object)MicroDuration.builder().optional().build(), (Object)-9.378456E10));
    private static final String[] ALL_TABLES = new String[]{"debezium.type_string", "debezium.type_fp", "debezium.type_int", "debezium.type_time"};
    private static final String[] ALL_DDLS = new String[]{"create table debezium.type_string (  id int not null,   val_varchar2 varchar2(1000),   val_nvarchar2 nvarchar2(1000),   val_char char(3),   val_nchar nchar(3),   primary key (id))", "create table debezium.type_fp (  id int not null,   val_bf binary_float,   val_bd binary_double,   val_f float,   val_num number(10,6),   val_dp double precision,   val_r real,   val_num_vs number,   primary key (id))", "create table debezium.type_int (  id int not null,   val_int int,   val_integer integer,   val_smallint smallint,   primary key (id))", "create table debezium.type_time (  id int not null,   val_date date,   val_ts timestamp,   val_tstz timestamp with time zone,   val_tsltz timestamp with local time zone,   val_int_ytm interval year to month,   val_int_dts interval day(3) to second(2),   primary key (id))"};
    private static OracleConnection connection;

    @BeforeClass
    public static void dropTables() throws SQLException {
        connection = TestHelper.testConnection();
        for (String table : ALL_TABLES) {
            TestHelper.dropTable(connection, table);
        }
    }

    protected static void createTables() throws SQLException {
        connection.execute(ALL_DDLS);
        for (String table : ALL_TABLES) {
            AbstractOracleDatatypesTest.streamTable(table);
        }
    }

    private static void streamTable(String table) throws SQLException {
        connection.execute(new String[]{"GRANT SELECT ON " + table + " to " + "c##xstrm"});
        connection.execute(new String[]{"ALTER TABLE " + table + " ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Test
    public void stringTypes() throws Exception {
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.type_string VALUES (1, 'v\u010d2', 'nv\u010d2', 'c', 'n\u010d')"});
        connection.execute(new String[]{"COMMIT"});
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TYPE_STRING");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        this.assertRecord(after, EXPECTED_STRING);
    }

    @Test
    public void fpTypes() throws Exception {
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.type_fp VALUES (1, 1.1, 2.22, 3.33, 4.4444, 5.555, 6.66, 77.323)"});
        connection.execute(new String[]{"COMMIT"});
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TYPE_FP");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        this.assertRecord(after, EXPECTED_FP);
    }

    @Test
    public void intTypes() throws Exception {
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.type_int VALUES (1, 1, 22, 333)"});
        connection.execute(new String[]{"COMMIT"});
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TYPE_INT");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        this.assertRecord(after, EXPECTED_INT);
    }

    @Test
    public void timeTypes() throws Exception {
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.type_time VALUES (1, TO_DATE('27-MAR-2018', 'dd-MON-yyyy'), TO_TIMESTAMP('27-MAR-2018 12:34:56.00789', 'dd-MON-yyyy HH24:MI:SS.FF5'), TO_TIMESTAMP_TZ('27-MAR-2018 01:34:56.00789 -11:00', 'dd-MON-yyyy HH24:MI:SS.FF5 TZH:TZM'), TO_TIMESTAMP_TZ('27-MAR-2018 01:34:56.00789', 'dd-MON-yyyy HH24:MI:SS.FF5'), INTERVAL '-3-6' YEAR TO MONTH, INTERVAL '-1 2:3:4.56' DAY TO SECOND)"});
        connection.execute(new String[]{"COMMIT"});
        Testing.debug((Object)"Inserted");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(++expectedRecordCount);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.TYPE_TIME");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        this.assertRecord(after, EXPECTED_TIME);
    }

    private void assertRecord(Struct record, List<SchemaAndValueField> expected) {
        expected.forEach(schemaAndValueField -> schemaAndValueField.assertFor(record));
    }
}

