/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.document.Document;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.KafkaDatabaseHistory;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.errors.ConnectException;

public class OracleConnectorConfig
extends RelationalDatabaseConnectorConfig {
    public static final String DATABASE_CONFIG_PREFIX = "database.";
    public static final Field LOGICAL_NAME = Field.create((String)"database.server.name").withDisplayName("Namespace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Unique name that identifies the database server and all recorded offsets, andthat is used as a prefix for all schemas and topics. Each distinct MySQL installation should have a separate namespace and monitored by at most one Debezium connector.");
    public static final Field DATABASE_NAME = Field.create((String)("database." + JdbcConfiguration.DATABASE)).withDisplayName("Database name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("The name of the database the connector should be monitoring. When working with a multi-tenant set-up, must be set to the CDB name.");
    public static final Field DATABASE_HISTORY = Field.create((String)"database.history").withDisplayName("Database history class").withType(ConfigDef.Type.CLASS).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withInvisibleRecommender().withDescription("The name of the DatabaseHistory class that should be used to store and recover database schema changes. The configuration properties for the history are prefixed with the 'database.history.' string.").withDefault(KafkaDatabaseHistory.class.getName());
    public static final Field PDB_NAME = Field.create((String)"database.pdb.name").withDisplayName("PDB name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Name of the pluggable database when working with a multi-tenant set-up. The CDB name must be given via " + DATABASE_NAME.name() + " in this case.");
    public static final Field XSTREAM_SERVER_NAME = Field.create((String)"database.out.server.name").withDisplayName("XStream out server name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Name of the XStream Out server to connect to.");
    public static Field.Set ALL_FIELDS = Field.setOf((Field[])new Field[]{LOGICAL_NAME, DATABASE_NAME, PDB_NAME, XSTREAM_SERVER_NAME, RelationalDatabaseConnectorConfig.TABLE_WHITELIST, RelationalDatabaseConnectorConfig.TABLE_BLACKLIST, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN, CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE});
    private final String databaseName;
    private final String pdbName;
    private final String xoutServerName;

    public OracleConnectorConfig(Configuration config) {
        super(config, config.getString(LOGICAL_NAME), (Predicate)new SystemTablesPredicate());
        this.databaseName = config.getString(DATABASE_NAME);
        this.pdbName = config.getString(PDB_NAME);
        this.xoutServerName = config.getString(XSTREAM_SERVER_NAME);
    }

    public static ConfigDef configDef() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, (String)"Oracle", (Field[])new Field[]{LOGICAL_NAME, DATABASE_NAME, PDB_NAME, XSTREAM_SERVER_NAME});
        Field.group((ConfigDef)config, (String)"Events", (Field[])new Field[]{RelationalDatabaseConnectorConfig.TABLE_WHITELIST, RelationalDatabaseConnectorConfig.TABLE_BLACKLIST, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN});
        Field.group((ConfigDef)config, (String)"Connector", (Field[])new Field[]{CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE});
        return config;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public String getXoutServerName() {
        return this.xoutServerName;
    }

    public DatabaseHistory getDatabaseHistory() {
        Configuration config = this.getConfig();
        DatabaseHistory databaseHistory = (DatabaseHistory)config.getInstance(DATABASE_HISTORY, DatabaseHistory.class);
        if (databaseHistory == null) {
            throw new ConnectException("Unable to instantiate the database history class " + config.getString(DATABASE_HISTORY));
        }
        Configuration dbHistoryConfig = ((Configuration.Builder)config.subset("database.history.", false).edit().withDefault(DatabaseHistory.NAME, this.getLogicalName() + "-dbhistory")).build();
        HistoryRecordComparator historyComparator = new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return recorded.getLong((CharSequence)"scn").compareTo(desired.getLong((CharSequence)"scn")) < 1;
            }
        };
        databaseHistory.configure(dbHistoryConfig, historyComparator);
        return databaseHistory;
    }

    private static class SystemTablesPredicate
    implements Predicate<TableId> {
        private SystemTablesPredicate() {
        }

        @Override
        public boolean test(TableId t) {
            return t.schema().toLowerCase().equals("system") || t.schema().toLowerCase().equals("sys") || t.schema().toLowerCase().equals("mdsys") || t.schema().toLowerCase().equals("ctxsys") || t.schema().toLowerCase().equals("outln") || t.schema().toLowerCase().equals("xdb");
        }
    }
}

