/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.RelationalChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.util.Clock;
import oracle.streams.ColumnValue;
import oracle.streams.RowLCR;

public class OracleChangeRecordEmitter
extends RelationalChangeRecordEmitter {
    private final RowLCR lcr;
    private final Table table;

    public OracleChangeRecordEmitter(OffsetContext offset, RowLCR lcr, Table table, Clock clock) {
        super(offset, clock);
        this.lcr = lcr;
        this.table = table;
    }

    protected Envelope.Operation getOperation() {
        switch (this.lcr.getCommandType()) {
            case "INSERT": {
                return Envelope.Operation.CREATE;
            }
            case "DELETE": {
                return Envelope.Operation.DELETE;
            }
            case "UPDATE": {
                return Envelope.Operation.UPDATE;
            }
        }
        throw new IllegalArgumentException("Received event of unexpected command type: " + this.lcr);
    }

    protected Object[] getOldColumnValues() {
        return this.getColumnValues(this.lcr.getOldValues());
    }

    protected Object[] getNewColumnValues() {
        return this.getColumnValues(this.lcr.getNewValues());
    }

    private Object[] getColumnValues(ColumnValue[] columnValues) {
        Object[] values = new Object[this.table.columnNames().size()];
        for (ColumnValue columnValue : columnValues) {
            int index = this.table.columnNames().indexOf(columnValue.getColumnName());
            values[index] = columnValue.getColumnData();
        }
        return values;
    }
}

