/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.data.Envelope;
import io.debezium.data.SchemaUtil;
import io.debezium.schema.DataCollectionSchema;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

@Immutable
public class TableSchema
implements DataCollectionSchema {
    private final Schema keySchema;
    private final Envelope envelopeSchema;
    private final Schema valueSchema;
    private final Function<Object[], Object> keyGenerator;
    private final Function<Object[], Struct> valueGenerator;

    public TableSchema(Schema keySchema, Function<Object[], Object> keyGenerator, Envelope envelopeSchema, Schema valueSchema, Function<Object[], Struct> valueGenerator) {
        this.keySchema = keySchema;
        this.envelopeSchema = envelopeSchema;
        this.valueSchema = valueSchema;
        this.keyGenerator = keyGenerator != null ? keyGenerator : row -> null;
        this.valueGenerator = valueGenerator != null ? valueGenerator : row -> null;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    @Override
    public Schema keySchema() {
        return this.keySchema;
    }

    @Override
    public Envelope getEnvelopeSchema() {
        return this.envelopeSchema;
    }

    public Object keyFromColumnData(Object[] columnData) {
        return columnData == null ? null : this.keyGenerator.apply(columnData);
    }

    public Struct valueFromColumnData(Object[] columnData) {
        return columnData == null ? null : this.valueGenerator.apply(columnData);
    }

    public int hashCode() {
        return this.valueSchema().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TableSchema) {
            TableSchema that = (TableSchema)obj;
            return Objects.equals(this.keySchema(), that.keySchema()) && Objects.equals(this.valueSchema(), that.valueSchema());
        }
        return false;
    }

    public String toString() {
        return "{ key : " + SchemaUtil.asString(this.keySchema()) + ", value : " + SchemaUtil.asString(this.valueSchema()) + " }";
    }
}

