/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleDdlParser;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import java.util.Set;
import oracle.streams.DDLLCR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSchemaChangeEventEmitter
implements SchemaChangeEventEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleSchemaChangeEventEmitter.class);
    private final OracleOffsetContext offsetContext;
    private final TableId tableId;
    private final DDLLCR ddlLcr;

    public OracleSchemaChangeEventEmitter(OracleOffsetContext offsetContext, TableId tableId, DDLLCR ddlLcr) {
        this.offsetContext = offsetContext;
        this.tableId = tableId;
        this.ddlLcr = ddlLcr;
    }

    public void emitSchemaChangeEvent(SchemaChangeEventEmitter.Receiver receiver) throws InterruptedException {
        SchemaChangeEvent.SchemaChangeEventType eventType = this.getSchemaChangeEventType();
        if (eventType == null) {
            return;
        }
        Tables tables = new Tables();
        OracleDdlParser parser = new OracleDdlParser();
        parser.setCurrentDatabase(this.ddlLcr.getSourceDatabaseName());
        parser.setCurrentSchema(this.ddlLcr.getObjectOwner());
        parser.parse(this.ddlLcr.getDDLText(), tables);
        Set changedTableIds = tables.drainChanges();
        if (changedTableIds.isEmpty()) {
            throw new IllegalArgumentException("Couldn't parse DDL statement " + this.ddlLcr.getDDLText());
        }
        Table table = tables.forTable(this.tableId);
        receiver.schemaChangeEvent(new SchemaChangeEvent(this.offsetContext.getPartition(), this.offsetContext.getOffset(), this.ddlLcr.getSourceDatabaseName(), this.ddlLcr.getObjectOwner(), this.ddlLcr.getDDLText(), table, eventType, false));
    }

    private SchemaChangeEvent.SchemaChangeEventType getSchemaChangeEventType() {
        switch (this.ddlLcr.getCommandType()) {
            case "CREATE TABLE": {
                return SchemaChangeEvent.SchemaChangeEventType.CREATE;
            }
            case "ALTER TABLE": {
                LOGGER.warn("ALTER TABLE not yet implemented");
            }
            case "DROP TABLE": {
                LOGGER.warn("DROP TABLE not yet implemented");
            }
        }
        LOGGER.debug("Ignoring DDL event of type {}", (Object)this.ddlLcr.getCommandType());
        return null;
    }
}

