/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.LcrEventHandler;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.util.Clock;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.sql.NUMBER;
import oracle.streams.StreamsException;
import oracle.streams.XStreamLCRCallbackHandler;
import oracle.streams.XStreamOut;
import oracle.streams.XStreamUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleStreamingChangeEventSource
implements StreamingChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleStreamingChangeEventSource.class);
    private final JdbcConnection jdbcConnection;
    private final EventDispatcher<?> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final OracleOffsetContext offsetContext;
    private final String xStreamServerName;
    private volatile XStreamOut xsOut;

    public OracleStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleOffsetContext offsetContext, JdbcConnection jdbcConnection, EventDispatcher<?> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema) {
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext;
        this.xStreamServerName = connectorConfig.getXoutServerName();
    }

    public void execute(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        try {
            this.xsOut = XStreamOut.attach((OracleConnection)((OracleConnection)this.jdbcConnection.connection()), (String)this.xStreamServerName, (byte[])this.convertScnToPosition(this.offsetContext.getScn()), (int)1, (int)1, (int)0);
            LcrEventHandler handler = new LcrEventHandler(this.errorHandler, this.dispatcher, this.clock, (RelationalDatabaseSchema)this.schema, this.offsetContext);
            while (context.isRunning()) {
                LOGGER.trace("Receiving LCR");
                this.xsOut.receiveLCRCallback((XStreamLCRCallbackHandler)handler, 0);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.xsOut != null) {
                try {
                    this.xsOut.detach(0);
                }
                catch (StreamsException e) {
                    LOGGER.error("Couldn't detach from XStream outbound server " + this.xStreamServerName, (Throwable)e);
                }
            }
        }
    }

    public void commitOffset(Map<String, ?> offset) {
        if (this.xsOut != null) {
            try {
                LOGGER.debug("Recording offsets to Oracle");
                this.xsOut.setProcessedLowWatermark(this.convertScnToPosition((Long)offset.get("scn")), 0);
                LOGGER.trace("Offsets recorded to Oracle");
            }
            catch (StreamsException e) {
                throw new RuntimeException("Couldn't set processed low watermark", e);
            }
        }
    }

    private byte[] convertScnToPosition(long scn) {
        try {
            return XStreamUtility.convertSCNToPosition((NUMBER)new NUMBER(scn), (int)2);
        }
        catch (StreamsException e) {
            throw new RuntimeException(e);
        }
    }
}

