/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDdlParser;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.SourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleDatabaseSchema.class);
    private final DatabaseHistory databaseHistory;

    public OracleDatabaseSchema(OracleConnectorConfig connectorConfig, SchemaNameAdjuster schemaNameAdjuster, TopicSelector<TableId> topicSelector, OracleConnection connection) {
        super((CommonConnectorConfig)connectorConfig, topicSelector, OracleDatabaseSchema.getTableFilter(connectorConfig), null, new TableSchemaBuilder((ValueConverterProvider)new OracleValueConverters(connection), schemaNameAdjuster, SourceInfo.SCHEMA), false);
        this.databaseHistory = connectorConfig.getDatabaseHistory();
        this.databaseHistory.start();
    }

    private static Predicate<TableId> getTableFilter(OracleConnectorConfig connectorConfig) {
        return t -> connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(t);
    }

    public void recover(OffsetContext offset) {
        this.databaseHistory.recover(offset.getPartition(), offset.getOffset(), this.tables(), (DdlParser)new OracleDdlParser());
        for (TableId tableId : this.tableIds()) {
            this.buildAndRegisterSchema(this.tableFor(tableId));
        }
    }

    public void close() {
        this.databaseHistory.stop();
    }

    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
        Table table = (Table)schemaChange.getTables().iterator().next();
        this.buildAndRegisterSchema(table);
        this.tables().overwriteTable(table);
        TableChanges tableChanges = null;
        if (schemaChange.getType() == SchemaChangeEvent.SchemaChangeEventType.CREATE && schemaChange.isFromSnapshot()) {
            tableChanges = new TableChanges();
            tableChanges.create(table);
        }
        this.databaseHistory.record(schemaChange.getPartition(), schemaChange.getOffset(), schemaChange.getDatabase(), schemaChange.getSchema(), schemaChange.getDdl(), tableChanges);
    }
}

