/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSnapshotChangeEventSource
implements SnapshotChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleSnapshotChangeEventSource.class);
    private final OracleConnectorConfig connectorConfig;
    private final OracleOffsetContext previousOffset;
    private final OracleConnection jdbcConnection;
    private final OracleDatabaseSchema schema;

    public OracleSnapshotChangeEventSource(OracleConnectorConfig connectorConfig, OracleOffsetContext previousOffset, OracleConnection jdbcConnection, OracleDatabaseSchema schema) {
        this.connectorConfig = connectorConfig;
        this.previousOffset = previousOffset;
        this.jdbcConnection = jdbcConnection;
        this.schema = schema;
    }

    public SnapshotResult execute(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        if (this.previousOffset != null) {
            LOGGER.debug("Found previous offset, skipping snapshotting");
            return SnapshotResult.completed((OffsetContext)this.previousOffset);
        }
        Connection connection = null;
        SnapshotContext ctx = null;
        try {
            connection = this.jdbcConnection.connection();
            connection.setAutoCommit(false);
            if (this.connectorConfig.getPdbName() != null) {
                this.jdbcConnection.setSessionToPdb(this.connectorConfig.getPdbName());
            }
            ctx = new SnapshotContext(context, connection, this.connectorConfig.getPdbName() != null ? this.connectorConfig.getPdbName() : this.connectorConfig.getDatabaseName());
            this.determineCapturedTables(ctx);
            if (!this.lockTablesToBeCaptured(ctx)) {
                SnapshotResult snapshotResult = SnapshotResult.aborted();
                return snapshotResult;
            }
            this.determineOffsetContextWithScn(ctx);
            this.readTableStructure(ctx);
            if (!this.createSchemaChangeEventsForTables(ctx)) {
                SnapshotResult snapshotResult = SnapshotResult.aborted();
                return snapshotResult;
            }
            SnapshotResult snapshotResult = SnapshotResult.completed((OffsetContext)ctx.offset);
            return snapshotResult;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ctx != null) {
                ctx.dispose();
            }
            this.rollbackTransaction(connection);
            if (this.connectorConfig.getPdbName() != null) {
                this.jdbcConnection.resetSessionToCdb();
            }
        }
    }

    private void determineCapturedTables(SnapshotContext ctx) throws SQLException {
        Set<TableId> allTableIds = this.jdbcConnection.readTableNames(ctx.catalogName, null, null, new String[]{"TABLE"});
        HashSet<TableId> capturedTables = new HashSet<TableId>();
        for (TableId tableId : allTableIds) {
            if (this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
                capturedTables.add(tableId);
                continue;
            }
            LOGGER.trace("Skipping table {} as it's not included in the filter configuration", (Object)tableId);
        }
        ctx.capturedTables = capturedTables;
    }

    private boolean lockTablesToBeCaptured(SnapshotContext ctx) throws SQLException {
        for (TableId tableId : ctx.capturedTables) {
            if (!ctx.changeEventSourceContext.isRunning()) {
                return false;
            }
            LOGGER.debug("Locking table {}", (Object)tableId);
            ctx.statement.execute("LOCK TABLE " + tableId.schema() + "." + tableId.table() + " IN EXCLUSIVE MODE");
        }
        return true;
    }

    private void determineOffsetContextWithScn(SnapshotContext ctx) throws SQLException {
        ResultSet rs = ctx.statement.executeQuery("select DBMS_FLASHBACK.GET_SYSTEM_CHANGE_NUMBER from dual");
        if (!rs.next()) {
            throw new IllegalStateException("Couldn't get SCN");
        }
        Long scn = rs.getLong(1);
        rs.close();
        ctx.offset = new OracleOffsetContext(this.connectorConfig.getLogicalName());
        ctx.offset.setScn(scn);
    }

    private void readTableStructure(SnapshotContext ctx) throws SQLException {
        ctx.tables = new Tables();
        Set schemas = ctx.capturedTables.stream().map(TableId::schema).collect(Collectors.toSet());
        for (String schema : schemas) {
            this.jdbcConnection.readSchema(ctx.tables, ctx.catalogName, schema, (catalog, schemaName, tableName) -> this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(new TableId(ctx.catalogName, schemaName, tableName)), null, false);
        }
    }

    private boolean createSchemaChangeEventsForTables(SnapshotContext ctx) throws SQLException {
        for (TableId tableId : ctx.capturedTables) {
            if (!ctx.changeEventSourceContext.isRunning()) {
                return false;
            }
            LOGGER.debug("Capturing structure of table {}", (Object)tableId);
            Table table = ctx.tables.forTable(tableId);
            ResultSet rs = ctx.statement.executeQuery("select dbms_metadata.get_ddl( 'TABLE', '" + tableId.table() + "', '" + tableId.schema() + "' ) from dual");
            if (!rs.next()) {
                throw new IllegalStateException("Couldn't get metadata");
            }
            Object res = rs.getObject(1);
            String ddl = ((Clob)res).getSubString(1L, (int)((Clob)res).length());
            rs.close();
            this.schema.applySchemaChange(new SchemaChangeEvent(ctx.offset.getPartition(), ctx.offset.getOffset(), ctx.catalogName, tableId.schema(), ddl, table, SchemaChangeEvent.SchemaChangeEventType.CREATE, true));
        }
        return true;
    }

    private void rollbackTransaction(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SnapshotContext {
        public final ChangeEventSource.ChangeEventSourceContext changeEventSourceContext;
        public final Statement statement;
        public final String catalogName;
        public Set<TableId> capturedTables;
        public OracleOffsetContext offset;
        public Tables tables;

        public SnapshotContext(ChangeEventSource.ChangeEventSourceContext changeEventSourceContext, Connection connection, String catalogName) throws SQLException {
            this.changeEventSourceContext = changeEventSourceContext;
            this.statement = connection.createStatement();
            this.catalogName = catalogName;
        }

        public void dispose() {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("Couldn't close statement", (Throwable)e);
            }
        }
    }
}

