/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class OracleConnectorIT
extends AbstractConnectorTest {
    private static final long MICROS_PER_SECOND = TimeUnit.SECONDS.toMicros(1L);
    private static OracleConnection connection;

    @BeforeClass
    public static void beforeClass() throws SQLException {
        connection = TestHelper.testConnection();
        TestHelper.dropTable(connection, "debezium.customer");
        String ddl = "create table debezium.customer (  id int not null,   name varchar2(1000),   score decimal(6, 2),   registered timestamp,   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.customer to c##xstrmadmin"});
        connection.execute(new String[]{"ALTER TABLE debezium.customer ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Before
    public void before() {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @Test
    public void shouldReadChangeStreamForExistingTable() throws Exception {
        Configuration config = TestHelper.defaultConfig().build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        Thread.sleep(1000L);
        int expectedRecordCount = 0;
        connection.execute(new String[]{"INSERT INTO debezium.customer VALUES (1, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"COMMIT"});
        ++expectedRecordCount;
        connection.execute(new String[]{"UPDATE debezium.customer SET name = 'Bruce', score = 2345.67, registered = TO_DATE('2018/03/23', 'yyyy-mm-dd') WHERE id = 1"});
        connection.execute(new String[]{"COMMIT"});
        ++expectedRecordCount;
        connection.execute(new String[]{"UPDATE debezium.customer SET id = 2 WHERE id = 1"});
        connection.execute(new String[]{"COMMIT"});
        expectedRecordCount += 3;
        connection.execute(new String[]{"DELETE debezium.customer WHERE id = 2"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(expectedRecordCount += 2);
        List testTableRecords = records.recordsForTopic("server1.ORCLPDB1.DEBEZIUM.CUSTOMER");
        Assertions.assertThat((List)testTableRecords).hasSize(expectedRecordCount);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
        VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)testTableRecords.get(1)));
        Struct before = (Struct)((Struct)((SourceRecord)testTableRecords.get(1)).value()).get("before");
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)before.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)before.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)before.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
        after = (Struct)((Struct)((SourceRecord)testTableRecords.get(1)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)testTableRecords.get(2)));
        before = (Struct)((Struct)((SourceRecord)testTableRecords.get(2)).value()).get("before");
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)before.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)before.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)before.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)testTableRecords.get(3)));
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(4)));
        after = (Struct)((Struct)((SourceRecord)testTableRecords.get(4)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(2L));
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidDelete((SourceRecord)((SourceRecord)testTableRecords.get(5)));
        before = (Struct)((Struct)((SourceRecord)testTableRecords.get(5)).value()).get("before");
        Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)BigDecimal.valueOf(2L));
        Assertions.assertThat((Object)before.get("NAME")).isEqualTo((Object)"Bruce");
        Assertions.assertThat((Object)before.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(2345.67));
        Assertions.assertThat((Object)before.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 3, 23, 0, 0, 0)));
        VerifyRecord.isValidTombstone((SourceRecord)((SourceRecord)testTableRecords.get(6)));
    }

    @Test
    public void shouldReadChangeStreamForTableCreatedWhileStreaming() throws Exception {
        TestHelper.dropTable(connection, "debezium.customer2");
        Configuration config = TestHelper.defaultConfig().build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        Thread.sleep(1000L);
        String ddl = "create table debezium.customer2 (  id int not null,   name varchar2(1000),   score decimal(6, 2),   registered timestamp,   primary key (id))";
        connection.execute(new String[]{ddl});
        connection.execute(new String[]{"GRANT SELECT ON debezium.customer2 to c##xstrmadmin"});
        connection.execute(new String[]{"INSERT INTO debezium.customer2 VALUES (2, 'Billie-Bob', 1234.56, TO_DATE('2018/02/22', 'yyyy-mm-dd'))"});
        connection.execute(new String[]{"COMMIT"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List testTableRecords = records.recordsForTopic("server1.ORCLPDB1.DEBEZIUM.CUSTOMER2");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)testTableRecords.get(0)));
        Struct after = (Struct)((Struct)((SourceRecord)testTableRecords.get(0)).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)BigDecimal.valueOf(2L));
        Assertions.assertThat((Object)after.get("NAME")).isEqualTo((Object)"Billie-Bob");
        Assertions.assertThat((Object)after.get("SCORE")).isEqualTo((Object)BigDecimal.valueOf(1234.56));
        Assertions.assertThat((Object)after.get("REGISTERED")).isEqualTo((Object)this.toMicroSecondsSinceEpoch(LocalDateTime.of(2018, 2, 22, 0, 0, 0)));
    }

    private long toMicroSecondsSinceEpoch(LocalDateTime localDateTime) {
        return localDateTime.toEpochSecond(ZoneOffset.UTC) * MICROS_PER_SECOND;
    }
}

