/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDdlParser;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.SourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDatabaseSchema
implements RelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleDatabaseSchema.class);
    private final TopicSelector topicSelector;
    private final Tables tables;
    private final Map<TableId, TableSchema> schemas;
    private final TableSchemaBuilder tableSchemaBuilder;
    private final DatabaseHistory databaseHistory;

    public OracleDatabaseSchema(OracleConnectorConfig connectorConfig, SchemaNameAdjuster schemaNameAdjuster, TopicSelector topicSelector, OracleConnection connection) {
        this.topicSelector = topicSelector;
        this.tables = new Tables();
        this.schemas = new HashMap<TableId, TableSchema>();
        this.tableSchemaBuilder = new TableSchemaBuilder((ValueConverterProvider)new OracleValueConverters(connection), schemaNameAdjuster, SourceInfo.SCHEMA);
        this.databaseHistory = connectorConfig.getDatabaseHistory();
        this.databaseHistory.start();
    }

    public void recover(OffsetContext offset) {
        this.databaseHistory.recover(offset.getPartition(), offset.getOffset(), this.tables, (DdlParser)new OracleDdlParser());
        for (TableId tableId : this.tables.tableIds()) {
            Table table = this.tables.forTable(tableId);
            this.schemas.put(table.id(), this.tableSchemaBuilder.create(null, this.getEnvelopeSchemaName(table), table, null, null));
        }
    }

    public void close() {
        this.databaseHistory.stop();
    }

    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
        Table table = (Table)schemaChange.getTables().iterator().next();
        this.tables.overwriteTable(table);
        this.schemas.put(table.id(), this.tableSchemaBuilder.create(null, this.getEnvelopeSchemaName(table), table, null, null));
        TableChanges tableChanges = null;
        if (schemaChange.getType() == SchemaChangeEvent.SchemaChangeEventType.CREATE && schemaChange.isFromSnapshot()) {
            tableChanges = new TableChanges();
            tableChanges.create(table);
        }
        this.databaseHistory.record(schemaChange.getPartition(), schemaChange.getOffset(), schemaChange.getDatabase(), schemaChange.getSchema(), schemaChange.getDdl(), tableChanges);
    }

    private String getEnvelopeSchemaName(Table table) {
        return this.topicSelector.topicNameFor((DataCollectionId)table.id()) + ".Envelope";
    }

    public DataCollectionSchema getDataCollectionSchema(DataCollectionId id) {
        return (DataCollectionSchema)this.schemas.get(id);
    }

    public Table getTable(TableId id) {
        return this.tables.forTable(id);
    }
}

